/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.VariableLengthScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public class IndependentProductScoringFunction
extends AbstractNormalizableScoringFunction {
    private NormalizableScoringFunction[] score;
    private int[] start;
    private int[] partialLength;
    private int[] params;
    private boolean[] isVariable;
    private IntList partIList;

    private static final AlphabetContainer getAlphabetContainer(NormalizableScoringFunction[] functions, int[] length) throws IllegalArgumentException {
        AlphabetContainer[] cons = new AlphabetContainer[functions.length];
        int[] lengths = new int[functions.length];
        for (int i = 0; i < functions.length; ++i) {
            cons[i] = functions[i].getAlphabetContainer();
            lengths[i] = length[i];
        }
        return new AlphabetContainer(cons, lengths);
    }

    private static final int sum(int[] length) throws IllegalArgumentException {
        int res = 0;
        int i = 0;
        while (i < length.length && length[i] > 0) {
            res += length[i++];
        }
        if (i != length.length) {
            throw new IllegalArgumentException("The length with index " + i + " is 0.");
        }
        return res;
    }

    private static final int[] getLengthArray(NormalizableScoringFunction ... functions) throws IllegalArgumentException {
        int i;
        int[] res = new int[functions.length];
        for (i = 0; i < functions.length && functions[i].getLength() > 0; ++i) {
            res[i] = functions[i].getLength();
        }
        if (i != functions.length) {
            throw new IllegalArgumentException("The NormalizableScoringFunction with index " + i + " has a length 0.");
        }
        return res;
    }

    public IndependentProductScoringFunction(NormalizableScoringFunction ... functions) throws CloneNotSupportedException, IllegalArgumentException {
        this(functions, IndependentProductScoringFunction.getLengthArray(functions));
    }

    public IndependentProductScoringFunction(NormalizableScoringFunction[] functions, int[] length) throws CloneNotSupportedException {
        super(IndependentProductScoringFunction.getAlphabetContainer(functions, length), IndependentProductScoringFunction.sum(length));
        int i;
        this.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])functions);
        this.setStartsAndLengths(length);
        this.setParamsStarts();
        double ess = this.score[0].getEss();
        for (i = 1; i < this.score.length && this.score[i].getEss() == ess; ++i) {
        }
        if (i != this.score.length) {
            throw new IllegalArgumentException("All NormalizableScoringFunction have to use the same ESS. Violated at index " + i + ".");
        }
    }

    public IndependentProductScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void setStartsAndLengths(int[] length) throws IllegalArgumentException {
        int oldStart = 0;
        this.start = new int[this.score.length];
        this.partialLength = new int[this.score.length];
        this.isVariable = new boolean[this.score.length];
        for (int i = 0; i < this.score.length; ++i) {
            this.start[i] = oldStart;
            this.partialLength[i] = length[i];
            this.isVariable[i] = this.score[i] instanceof VariableLengthScoringFunction;
            if (!this.isVariable[i] && this.score[i].getLength() != this.partialLength[i]) {
                throw new IllegalArgumentException("Could not use length " + this.partialLength[i] + " for component " + i + ".");
            }
            oldStart += length[i];
        }
        this.partIList = new IntList();
    }

    private void setParamsStarts() {
        this.params = new int[this.score.length + 1];
        for (int i = 0; i < this.score.length; ++i) {
            int n = this.score[i].getNumberOfParameters();
            if (n == -1) {
                this.params = null;
                break;
            }
            this.params[i + 1] = this.params[i] + n;
        }
    }

    public IndependentProductScoringFunction clone() throws CloneNotSupportedException {
        IndependentProductScoringFunction clone = (IndependentProductScoringFunction)super.clone();
        clone.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
        clone.setStartsAndLengths(this.partialLength);
        clone.setParamsStarts();
        return clone;
    }

    private int getSFIndex(int index) {
        int i;
        for (i = 1; i < this.params.length && index >= this.params[i]; ++i) {
        }
        return i - 1;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        int i = this.getSFIndex(index);
        return this.score[i].getSizeOfEventSpaceForRandomVariablesOfParameter(index - this.params[i]);
    }

    public double getNormalizationConstant() {
        double norm = 1.0;
        for (int i = 0; i < this.score.length; ++i) {
            norm *= this.score[i].getNormalizationConstant();
        }
        return norm;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        int j = this.getSFIndex(parameterIndex);
        double partNorm = 1.0;
        for (int i = 0; i < this.score.length; ++i) {
            if (i == j) {
                partNorm *= this.score[i].getPartialNormalizationConstant(parameterIndex - this.params[i]);
                continue;
            }
            partNorm *= this.score[i].getNormalizationConstant();
        }
        return partNorm;
    }

    public double getEss() {
        return this.score[0].getEss();
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        Sample[] part = new Sample[data.length];
        for (int i = 0; i < this.score.length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                part[j] = data[j].getInfixSample(this.start[i], this.partialLength[i]);
            }
            this.score[i].initializeFunction(index, freeParams, part, weights);
        }
        this.setParamsStarts();
    }

    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getInstanceName());
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "AlphabetContainer");
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.score = (NormalizableScoringFunction[])ArrayHandler.cast(XMLParser.extractStorableArrayForTag(xml, "ScoringFunctions"));
        this.setStartsAndLengths(XMLParser.extractIntArrayForTag(xml, "partialLength"));
        this.setParamsStarts();
    }

    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    public double[] getCurrentParameterValues() throws Exception {
        int numPars = this.getNumberOfParameters();
        double[] pars = new double[numPars];
        int k = 0;
        for (int i = 0; i < this.score.length; ++i) {
            double[] help = this.score[i].getCurrentParameterValues();
            for (int j = 0; j < help.length; ++j) {
                pars[k++] = help[j];
            }
        }
        return pars;
    }

    public double getLogScore(Sequence seq, int start) {
        double s = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            if (this.isVariable[i]) {
                s += ((VariableLengthScoringFunction)this.score[i]).getLogScore(seq, start + this.start[i], this.partialLength[i]);
                continue;
            }
            s += this.score[i].getLogScore(seq, start + this.start[i]);
        }
        return s;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double s = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            this.partIList.clear();
            s = this.isVariable[i] ? (s += ((VariableLengthScoringFunction)this.score[i]).getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partialLength[i], this.partIList, partialDer)) : (s += this.score[i].getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partIList, partialDer));
            for (int j = 0; j < this.partIList.length(); ++j) {
                indices.add(this.partIList.get(j) + this.params[i]);
            }
        }
        return s;
    }

    public int getNumberOfParameters() {
        if (this.params == null) {
            return -1;
        }
        return this.params[this.score.length];
    }

    public int getNumberOfRecommendedStarts() {
        int max = this.score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < this.score.length; ++i) {
            max = Math.max(max, this.score[i].getNumberOfRecommendedStarts());
        }
        return max;
    }

    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].setParameters(params, start + this.params[i]);
        }
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendStorableWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendIntWithTags(xml, this.length, "length");
        XMLParser.appendStorableArrayWithTags(xml, this.score, "ScoringFunctions");
        XMLParser.appendIntArrayWithTags(xml, this.partialLength, "partialLength");
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100000);
        for (int i = 0; i < this.score.length; ++i) {
            sb.append("sequence part beginning at " + this.start[i] + " with length " + this.partialLength[i] + "\n");
            sb.append(this.score[i].toString() + "\n");
        }
        return sb.toString();
    }

    public double getLogPriorTerm() {
        double val = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            val += this.score[i].getLogPriorTerm();
        }
        return val;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].addGradientOfLogPriorTerm(grad, start + this.params[i]);
        }
    }

    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isInitialized(); ++i) {
        }
        return i == this.score.length;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].initializeFunctionRandomly(freeParams);
        }
    }
}

