/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class PMMExplainingAwayResidual
extends Measure {
    private PMMExplainingAwayResidualParameterSet parameters;
    private byte order;
    private double[] ess;

    public PMMExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "pmmExplainingAwayResidual");
        this.order = XMLParser.extractByteForTag(buf, "order");
        this.ess = XMLParser.extractDoubleArrayForTag(buf, "ess");
    }

    public PMMExplainingAwayResidual(byte order, double[] ess) throws Exception {
        if (order < 1 || order > 2) {
            throw new Exception("Only order 1 and 2 allowed (yet).");
        }
        this.ess = ess;
        this.order = order;
    }

    public PMMExplainingAwayResidual(PMMExplainingAwayResidualParameterSet parameters) throws Exception {
        this(parameters.getOrder(), parameters.getEss());
        this.parameters = parameters;
    }

    public PMMExplainingAwayResidual clone() throws CloneNotSupportedException {
        PMMExplainingAwayResidual clone = (PMMExplainingAwayResidual)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    public String getInstanceName() {
        return "Permuted Markov model of order " + this.order + " with explaining away residual";
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        SymmetricTensor t = new SymmetricTensor(length, this.order);
        double nFg = PMMExplainingAwayResidual.sum(weightsFg) + this.ess[0];
        double nBg = PMMExplainingAwayResidual.sum(weightsBg) + this.ess[1];
        PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatistics(fg, weightsFg, length, this.ess[0]), PMMExplainingAwayResidual.getStatistics(bg, weightsBg, length, this.ess[1]), nFg, nBg));
        if (this.order == 2) {
            PMMExplainingAwayResidual.fillTensor((Tensor)t, PMMExplainingAwayResidual.getEAR(PMMExplainingAwayResidual.getStatisticsOrderTwo(fg, weightsFg, length, this.ess[0]), PMMExplainingAwayResidual.getStatisticsOrderTwo(bg, weightsBg, length, this.ess[1]), nFg, nBg));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMExplainingAwayResidual.toParents(o, this.order);
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendByteWithTags(buf, this.order, "order");
        XMLParser.appendDoubleArrayWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "pmmExplainingAwayResidual");
        return buf;
    }

    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new PMMExplainingAwayResidualParameterSet(this.order, this.ess);
    }

    public static class PMMExplainingAwayResidualParameterSet
    extends InstanceParameterSet {
        public PMMExplainingAwayResidualParameterSet() {
            super(PMMExplainingAwayResidual.class);
        }

        public PMMExplainingAwayResidualParameterSet(byte order, double[] ess) throws Exception {
            super(PMMExplainingAwayResidual.class);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue(order);
        }

        public PMMExplainingAwayResidualParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public byte getOrder() {
            return (Byte)((Parameter)this.parameters.get(2)).getValue();
        }

        public String getInstanceComment() {
            return "Permuted Markov model - explaining away residual";
        }

        public String getInstanceName() {
            return "Build a permuted Markov model using explaining away residual as structure measure.";
        }

        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true));
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true));
            this.parameters.add(new SimpleParameter(DataType.BYTE, "Order", "The order of the permuted Markov model. Only 1 or 2 allowed.", true));
        }
    }
}

