/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.DiMRGParams;
import java.util.Arrays;

public class DirichletMRGParams
extends DiMRGParams {
    private double[] alpha;
    private double sum;

    public DirichletMRGParams(double alpha, int n) throws IllegalArgumentException {
        if (n < 2) {
            throw new IllegalArgumentException("The parameter n has to be at least 2.");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The parameter alpha has to be positive.");
        }
        this.alpha = new double[n];
        Arrays.fill(this.alpha, alpha);
        this.sum = (double)n * alpha;
    }

    public DirichletMRGParams(double ... alpha) throws IllegalArgumentException {
        this.alpha = new double[alpha.length];
        this.sum = 0.0;
        for (int i = 0; i < alpha.length; ++i) {
            if (alpha[i] <= 0.0) {
                throw new IllegalArgumentException("Each parameter alpha[i] has to be positive.");
            }
            this.alpha[i] = alpha[i];
            this.sum += alpha[i];
        }
    }

    public int getDimension() {
        return this.alpha.length;
    }

    public double getHyperparameter(int i) {
        return this.alpha[i];
    }

    public double getSumOfHyperparameter() {
        return this.sum;
    }
}

