/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class HmmerAlignmentSAXParser
extends AbstractNativeAppSAXParser {
    private BufferedReader oContents;
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private String oLine;

    HmmerAlignmentSAXParser(BlastLikeVersionSupport poVersion, String poNamespacePrefix) {
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
    }

    public String parse(BufferedReader poContents, String poLine) throws SAXException {
        this.oContents = poContents;
        try {
            this.oLine = poLine;
            this.oLine = this.oContents.readLine();
            int state = 0;
            StringBuffer oSequenceMatch = new StringBuffer();
            StringBuffer oHmmMatch = new StringBuffer();
            StringBuffer oMarkup = new StringBuffer();
            int iAlignLen = 0;
            String oScore = "";
            String oEvalue = "";
            String oRawSummary = "";
            String oIdString = "";
            String oFrom = "";
            String oTo = "";
            int index1 = 0;
            int index2 = 0;
            if (this.oLine.trim().equals("[no hits above thresholds]")) {
                this.oLine = this.oContents.readLine();
                return this.oLine;
            }
            while (!this.oLine.trim().equals("//") && !this.oLine.trim().startsWith("Histogram of all scores:")) {
                switch (state) {
                    case 0: {
                        if (this.oLine.trim().equals("") || this.oLine.startsWith(" ")) break;
                        oMarkup.setLength(0);
                        oHmmMatch.setLength(0);
                        oSequenceMatch.setLength(0);
                        oRawSummary = this.oLine;
                        oIdString = this.oLine.substring(0, this.oLine.indexOf(":"));
                        StringTokenizer st = new StringTokenizer(this.oLine.substring(this.oLine.indexOf(":") + 1), ",:");
                        st.nextToken();
                        String lenString = st.nextToken();
                        String scoreString = st.nextToken();
                        String eString = st.nextToken();
                        st = new StringTokenizer(lenString);
                        st.nextToken();
                        oFrom = st.nextToken();
                        int iFrom = Integer.parseInt(oFrom);
                        st.nextToken();
                        oTo = st.nextToken();
                        int iTo = Integer.parseInt(oTo);
                        st = new StringTokenizer(scoreString);
                        st.nextToken();
                        oScore = st.nextToken();
                        st = new StringTokenizer(eString, "=");
                        st.nextToken();
                        oEvalue = st.nextToken();
                        this.oAtts.clear();
                        iAlignLen = iTo - iFrom + 1;
                        this.startElement(new QName(this, this.prefix("Hit")), this.oAtts);
                        this.oAtts.clear();
                        this.oAttQName.setQName("id");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oIdString);
                        this.oAttQName.setQName("metaData");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "none");
                        this.startElement(new QName(this, this.prefix("HitId")), this.oAtts);
                        this.endElement(new QName(this, this.prefix("HitId")));
                        this.oAtts.clear();
                        this.startElement(new QName(this, this.prefix("HSPCollection")), this.oAtts);
                        this.startElement(new QName(this, this.prefix("HSP")), this.oAtts);
                        state = 1;
                        break;
                    }
                    case 1: {
                        index1 = this.oLine.indexOf("*->");
                        index2 = this.oLine.indexOf("<");
                        if (index2 == -1) {
                            index2 = this.oLine.trim().length() + index1;
                            state = 2;
                        } else {
                            state = 3;
                        }
                        oHmmMatch.append(this.oLine.substring(index1 + 3, index2));
                        this.oLine = this.oContents.readLine();
                        oMarkup.append(this.oLine.substring(index1 + 3, index2));
                        this.oLine = this.oContents.readLine();
                        oSequenceMatch.append(this.oLine.substring(index1 + 3, index2));
                        break;
                    }
                    case 2: {
                        this.oLine = this.oContents.readLine();
                        index2 = this.oLine.indexOf("<");
                        if (index2 == -1) {
                            index2 = this.oLine.trim().length() + index1;
                        } else {
                            state = 3;
                        }
                        oHmmMatch.append(this.oLine.substring(index1, index2));
                        this.oLine = this.oContents.readLine();
                        oMarkup.append(this.oLine.substring(index1, index2));
                        this.oLine = this.oContents.readLine();
                        oSequenceMatch.append(this.oLine.substring(index1, index2));
                        break;
                    }
                    case 3: {
                        String oMarkupString = oMarkup.substring(0);
                        int iNumberOfPlus = this.countChar(oMarkupString, '+');
                        int iNumberOfSpaces = this.countChar(oMarkupString, ' ');
                        String oSequenceString = oSequenceMatch.substring(0);
                        String oHmmString = oHmmMatch.substring(0);
                        int iNumberOfGaps = 0;
                        int iAlignSize = iAlignLen + (iNumberOfGaps += this.countChar(oSequenceString, '-'));
                        int iNumberOfPositives = iAlignSize - iNumberOfSpaces;
                        int iNumberOfIdentities = iNumberOfPositives - iNumberOfPlus;
                        this.oAtts.clear();
                        this.oAttQName.setQName("score");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oScore);
                        this.oAttQName.setQName("expectValue");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oEvalue);
                        this.oAttQName.setQName("numberOfIdentities");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString(iNumberOfIdentities));
                        this.oAttQName.setQName("alignmentSize");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString(iAlignSize));
                        this.oAttQName.setQName("percentageIdentity");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString((int)((double)iNumberOfIdentities / (double)iAlignSize * 100.0)));
                        this.oAttQName.setQName("numberOfPositives");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString(iNumberOfPositives));
                        this.oAttQName.setQName("percentagePositives");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString((int)((double)iNumberOfPositives / (double)iAlignSize * 100.0)));
                        this.oAttQName.setQName("numberOfGaps");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", Integer.toString(iNumberOfGaps));
                        this.startElement(new QName(this, this.prefix("HSPSummary")), this.oAtts);
                        this.oAtts.clear();
                        this.oAttQName.setQName("xml:space");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
                        this.startElement(new QName(this, this.prefix("RawOutput")), this.oAtts);
                        char[] aoChars = oRawSummary.toCharArray();
                        this.characters(aoChars, 0, aoChars.length);
                        this.endElement(new QName(this, this.prefix("RawOutput")));
                        this.endElement(new QName(this, this.prefix("HSPSummary")));
                        this.oAtts.clear();
                        this.startElement(new QName(this, this.prefix("BlastLikeAlignment")), this.oAtts);
                        this.oAtts.clear();
                        this.oAttQName.setQName("startPosition");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oFrom);
                        this.oAttQName.setQName("stopPosition");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oTo);
                        this.startElement(new QName(this, this.prefix("QuerySequence")), this.oAtts);
                        aoChars = oSequenceString.toCharArray();
                        this.characters(aoChars, 0, aoChars.length);
                        this.endElement(new QName(this, this.prefix("QuerySequence")));
                        this.oAtts.clear();
                        this.oAttQName.setQName("xml:space");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
                        this.startElement(new QName(this, this.prefix("MatchConsensus")), this.oAtts);
                        aoChars = oMarkupString.toCharArray();
                        this.characters(aoChars, 0, aoChars.length);
                        this.endElement(new QName(this, this.prefix("MatchConsensus")));
                        this.oAtts.clear();
                        this.oAttQName.setQName("startPosition");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "100");
                        this.oAttQName.setQName("stopPosition");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", "200");
                        this.startElement(new QName(this, this.prefix("HitSequence")), this.oAtts);
                        aoChars = oHmmString.toCharArray();
                        this.characters(aoChars, 0, aoChars.length);
                        this.endElement(new QName(this, this.prefix("HitSequence")));
                        this.endElement(new QName(this, this.prefix(this.prefix("BlastLikeAlignment"))));
                        this.endElement(new QName(this, this.prefix("HSP")));
                        this.endElement(new QName(this, this.prefix("HSPCollection")));
                        this.endElement(new QName(this, this.prefix("Hit")));
                        state = 0;
                        break;
                    }
                    default: {
                        System.out.println("Can't reach here");
                    }
                }
                this.oLine = this.oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
        return this.oLine;
    }

    int countChar(String poString, char pcChar) {
        int index = -1;
        int iCount = 0;
        while ((index = poString.indexOf(pcChar, index + 1)) != -1) {
            ++iCount;
        }
        return iCount;
    }
}

