/*
 * This file is part of Jstacs.
 * 
 * Jstacs is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * Jstacs is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * Jstacs. If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;

/**
 * The main class for any discrete sequence.
 * 
 * @author Jens Keilwagen
 */
public abstract class DiscreteSequence extends Sequence {

	/**
	 * This constructor creates an instance with the {@link AlphabetContainer}
	 * and the annotation, but without the content. The content has to be set by
	 * the constructor of the extending class.
	 * 
	 * @param container
	 *            the {@link AlphabetContainer} of the sequence
	 * @param annotation
	 *            the annotation of the sequence
	 * 
	 * @throws WrongAlphabetException
	 *             if the {@link AlphabetContainer} is not discrete
	 */
	public DiscreteSequence( AlphabetContainer container, SequenceAnnotation[] annotation ) throws WrongAlphabetException {
		super( container, annotation );
		if( !container.isDiscrete() ) {
			throw new WrongAlphabetException( "The alphabet is not discrete." );
		}
	}

	/* (non-Javadoc)
	 * @see de.jstacs.data.Sequence#continuousVal(int)
	 */
	@Override
	public final double continuousVal( int pos ) {
		return discreteVal( pos );
	}

}
