package de.jstacs.models.discrete.homogeneous.parameters;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.models.discrete.homogeneous.HomogeneousMM;

/**
 * This class implements a container for all parameters of a homogeneous Markov model
 * 
 * @author Jens Keilwagen
 */
public class HomMMParameterSet extends HomogeneousModelParameterSet
{
	/**
	 * The constructor for the {@link de.jstacs.Storable} interface.
	 * 
	 * @param s
	 *            the StringBuffer
	 * 
	 * @throws NonParsableException
	 *             if the StringBuffer is not parsable
	 */
	public HomMMParameterSet( StringBuffer s ) throws NonParsableException
	{
		super( s );
	}

	/**
	 * An empty constructor.
	 */
	public HomMMParameterSet()
	{
		super( HomogeneousMM.class );
	}

	/**
	 * The constructor that sets already the ALphabetContainer, ESS, description and order.
	 * 
	 * @param alphabet
	 *            the alphabet
	 * @param ess
	 *            the ESS
	 * @param description
	 *            the description
	 * @param order the Markov order of the model
	 * 
	 * @throws Exception
	 *             if something went wrong
	 */
	public HomMMParameterSet( AlphabetContainer alphabet, double ess, String description, byte order ) throws Exception
	{
		super( HomogeneousMM.class, alphabet, ess, description, order );
	}

	public String getInstanceComment()
	{
		return "a homogeneous Markov model with user-specified order";
	}
}
