package de.jstacs.models.mixture.motif.positionprior;

import de.jstacs.NonParsableException;

/**
 * This prior implements a uniform distribution for the start position.
 * 
 * @author Jens Keilwagen
 */
public class UniformPositionPrior extends PositionPrior
{
	/**
	 * This empty constructor creates an instance with motif length -1.
	 */
	public UniformPositionPrior()
	{
		super();
	}

	/**
	 * The standard constructor for the interface {@link de.jstacs.Storable}.
	 * 
	 * @param xml
	 *            the StringBuffer containing the model
	 * 
	 * @throws NonParsableException
	 *             if the StringBuffer can not be parsed
	 */
	public UniformPositionPrior( StringBuffer xml ) throws NonParsableException
	{
		super( xml );
	}

	public double getLogPriorForPositions( int seqLength, int... starts ) throws IllegalArgumentException
	{
		if( motifLength > 0 )
		{
			return -Math.log( seqLength - motifLength + 1 );
		}
		else
		{
			throw new IllegalArgumentException( "The motif length has to be set." );
		}
	}

	public final int getLength()
	{
		return 0;
	}

	public String getInstanceName()
	{
		return getClass().getSimpleName();
	}

	protected StringBuffer getAdditionalInformation()
	{
		return new StringBuffer();
	}

	protected void extractAdditionalInformation( StringBuffer xml )
	{
	}
}
