/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.Function;
import de.jstacs.algorithms.optimization.OneDimensionalFunction;

public class OneDimensionalSubFunction
extends OneDimensionalFunction {
    private double[] d;
    private double[] current;
    private Function f;

    public OneDimensionalSubFunction(Function f, double[] current, double[] d) throws DimensionException {
        int n = f.getDimensionOfScope();
        if (n != d.length && n != current.length) {
            throw new DimensionException();
        }
        this.f = f;
        this.d = d;
        this.current = current;
    }

    public double evaluateFunction(double x) throws EvaluationException {
        double[] p = new double[this.d.length];
        for (int counter = 0; counter < p.length; ++counter) {
            p[counter] = this.current[counter] + x * this.d[counter];
        }
        try {
            return this.f.evaluateFunction(p);
        }
        catch (DimensionException impossible) {
            EvaluationException ee = new EvaluationException(impossible.getMessage());
            ee.setStackTrace(impossible.getStackTrace());
            throw ee;
        }
    }
}

