/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.AlphabetContainerParameterSet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphabetContainer
implements Storable,
InstantiableFromParameterSet,
Comparable<AlphabetContainer> {
    private static final String XML_TAG = "AlphabetContainer";
    private Alphabet[] alphabet;
    private String delim;
    private int[] index;
    private AlphabetContainerParameterSet parameters;
    private double l;

    public static AlphabetContainer getSimplifiedAlphabetContainer(Alphabet[] abc, int[] assignment) {
        ArrayList<Alphabet> list = new ArrayList<Alphabet>(abc.length);
        int[] assign = new int[assignment.length];
        int[] abcAssign = new int[abc.length];
        Arrays.fill(abcAssign, -1);
        for (int i = 0; i < assign.length; ++i) {
            if (abcAssign[assignment[i]] < 0) {
                int j;
                Alphabet current = abc[assignment[i]];
                for (j = 0; j < list.size() && !((Alphabet)list.get(j)).checkConsistency(current); ++j) {
                }
                abcAssign[i] = j;
                if (j == list.size()) {
                    list.add(current);
                }
            }
            assign[i] = abcAssign[assignment[i]];
        }
        return new AlphabetContainer(list.toArray(new Alphabet[0]), assign);
    }

    public static AlphabetContainer insertAlphabet(AlphabetContainer aC, Alphabet a, boolean[] useNewAlphabet) throws IllegalArgumentException {
        if (useNewAlphabet == null || useNewAlphabet.length == 0) {
            throw new IllegalArgumentException("given useNewAlphabet-array is null or has length 0");
        }
        Alphabet[] tempAs = new Alphabet[aC.alphabet.length + 1];
        tempAs[tempAs.length - 1] = a;
        int[] tempAssign = new int[useNewAlphabet.length];
        int pos1 = 0;
        if (aC.getPossibleLength() == 0) {
            for (int i = 0; i < tempAssign.length; ++i) {
                tempAssign[i] = useNewAlphabet[i] ? 0 : 1;
            }
        } else {
            for (int i = 0; i < tempAssign.length; ++i) {
                tempAssign[i] = useNewAlphabet[i] ? aC.index[pos1++] : tempAs.length - 1;
            }
        }
        return new AlphabetContainer(tempAs, tempAssign);
    }

    public AlphabetContainer(Alphabet abc) {
        this.index = null;
        this.alphabet = new Alphabet[]{abc};
        this.precompute();
    }

    public AlphabetContainer(Alphabet[] abc) {
        this(abc, null);
    }

    public AlphabetContainer(AlphabetContainer[] cons, int[] lengths) throws IllegalArgumentException {
        int j;
        int i;
        int n = 0;
        for (i = 0; i < lengths.length; ++i) {
            j = cons[i].getPossibleLength();
            if (j != 0 && j != lengths[i]) {
                throw new IllegalArgumentException("The AlphabetContainer " + i + " is not able to handle sequences of length " + lengths[i] + ".");
            }
            n += lengths[i];
        }
        this.index = new int[n];
        ArrayList<Alphabet> abcs = new ArrayList<Alphabet>(n);
        n = 0;
        for (i = 0; i < lengths.length; ++i) {
            int[] help = new int[cons[i].alphabet.length];
            for (j = 0; j < help.length; ++j) {
                int k;
                for (k = 0; k < abcs.size() && !cons[i].alphabet[j].checkConsistency((Alphabet)abcs.get(k)); ++k) {
                }
                if (k == abcs.size()) {
                    abcs.add(cons[i].alphabet[j]);
                }
                help[j] = k;
            }
            if (cons[i].index == null) {
                for (j = 0; j < lengths[i]; ++j) {
                    this.index[n++] = help[0];
                }
                continue;
            }
            for (j = 0; j < lengths[i]; ++j) {
                this.index[n++] = help[cons[i].index[j]];
            }
        }
        this.alphabet = abcs.toArray(new Alphabet[0]);
        if (this.alphabet.length == 1) {
            this.index = null;
        }
    }

    public AlphabetContainer(Alphabet[] abc, int[] assignment) throws IllegalArgumentException {
        if (abc.length == 1) {
            this.index = null;
        } else {
            int i = 0;
            if (assignment == null) {
                this.index = new int[abc.length];
                while (i < this.index.length) {
                    this.index[i] = i++;
                }
            } else {
                this.index = new int[assignment.length];
                boolean[] used = new boolean[abc.length];
                while (i < this.index.length && 0 <= assignment[i] && assignment[i] < abc.length) {
                    used[assignment[i]] = true;
                    this.index[i] = assignment[i++];
                }
                if (i < this.index.length) {
                    throw new IllegalArgumentException("The assignment from the positions to the alphabets is corrupted at position " + i + ".");
                }
                i = 1;
                while (i < used.length && (used[0] = used[0] & used[i++])) {
                }
                if (!used[0]) {
                    throw new IllegalArgumentException("The assignment from the positions to the alphabets is not surjective. (Not all alphabets are used.)");
                }
            }
        }
        this.alphabet = (Alphabet[])abc.clone();
        this.precompute();
    }

    public AlphabetContainer(AlphabetContainerParameterSet parameters) throws IllegalArgumentException, DoubleSymbolException, ParameterSetParser.NotInstantiableException {
        try {
            this.parameters = parameters.clone();
            ParameterSet alphSet = (ParameterSet)parameters.getParameterAt(0).getValue();
            if (alphSet instanceof Alphabet.AlphabetParameterSet) {
                this.index = new int[1];
                this.alphabet = new Alphabet[]{(Alphabet)ParameterSetParser.getInstanceFromParameterSet((InstanceParameterSet)alphSet)};
            } else if (alphSet instanceof AlphabetContainerParameterSet.AlphabetArrayParameterSet) {
                this.index = new int[((Integer)alphSet.getParameterAt(0).getValue()).intValue()];
                this.alphabet = new Alphabet[alphSet.getNumberOfParameters() - 1];
                for (int i = 0; i < this.index.length; ++i) {
                    this.index[i] = i;
                    ParameterSet par = (ParameterSet)alphSet.getParameterAt(i + 1).getValue();
                    if (par instanceof SimpleParameterSet) {
                        par = (ParameterSet)par.getParameterAt(0).getValue();
                    }
                    if (!(par instanceof Alphabet.AlphabetParameterSet)) {
                        throw new IllegalArgumentException("The parameters of the alphabet at " + i + " are not given correctly");
                    }
                    this.alphabet[i] = (Alphabet)ParameterSetParser.getInstanceFromParameterSet((InstanceParameterSet)par);
                }
            } else if (alphSet instanceof AlphabetContainerParameterSet.SectionDefinedAlphabetParameterSet) {
                if (!alphSet.hasDefaultOrIsSet()) {
                    throw new IllegalArgumentException(alphSet.getErrorMessage());
                }
                this.index = new int[((Integer)alphSet.getParameterAt(0).getValue()).intValue()];
                this.alphabet = new Alphabet[alphSet.getNumberOfParameters() - 1];
                for (int i = 0; i < this.alphabet.length; ++i) {
                    ParameterSet singleAlph = (ParameterSet)alphSet.getParameterAt(i + 1).getValue();
                    if (!(singleAlph.getParameterAt(0).getValue() instanceof Alphabet.AlphabetParameterSet)) {
                        throw new IllegalArgumentException("Parameter for alphabet no. " + i + " of unexpected type: " + singleAlph.getClass() + ".");
                    }
                    this.alphabet[i] = (Alphabet)ParameterSetParser.getInstanceFromParameterSet((InstanceParameterSet)singleAlph.getParameterAt(0).getValue());
                    String section = (String)singleAlph.getParameterAt(1).getValue();
                    try {
                        Iterator posIt = AlphabetContainerParameterSet.SectionDefinedAlphabetParameterSet.parseSections(section).iterator();
                        while (posIt.hasNext()) {
                            this.index[((Integer)posIt.next()).intValue()] = i;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException("Malformed sections for alphabet no. " + i + ".");
                    }
                }
            } else {
                throw new IllegalArgumentException("Wrong parameter type");
            }
            this.precompute();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.getCause().getMessage());
        }
    }

    public AlphabetContainer(StringBuffer xml) throws NonParsableException {
        StringBuffer buf = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabet = (Alphabet[])ArrayHandler.cast(XMLParser.extractStorableArrayForTag(buf, "Alphabets"));
        if (this.alphabet.length > 1) {
            int i;
            this.index = XMLParser.extractIntArrayForTag(buf, "Assignment");
            for (i = 0; i < this.index.length && this.index[i] < this.alphabet.length; ++i) {
            }
            if (i < this.index.length) {
                throw new NonParsableException("The assignment from the positions to the alphabets is corrupted at position " + i + ".");
            }
        }
        this.precompute();
    }

    public boolean checkConsistency(AlphabetContainer abc) {
        return this.compareTo(abc) == 0;
    }

    @Override
    public int compareTo(AlphabetContainer abc) {
        int a2;
        if (abc == this) {
            return 0;
        }
        int a1 = this.getPossibleLength();
        if (a1 == (a2 = abc.getPossibleLength())) {
            if (a1 == 0) {
                return this.alphabet[0].compareTo(abc.alphabet[0]);
            }
            boolean erg = true;
            byte notChecked = 0;
            byte consistent = 1;
            byte inconsistent = 2;
            byte[][] checked = new byte[this.alphabet.length][abc.alphabet.length];
            int current = 0;
            for (int i = 0; i < a2 && erg; ++i) {
                if (checked[this.index[i]][abc.index[i]] != notChecked) continue;
                current = this.alphabet[this.index[i]].compareTo(abc.alphabet[abc.index[i]]);
                checked[this.index[i]][abc.index[i]] = current == 0 ? consistent : inconsistent;
                erg &= checked[this.index[i]][abc.index[i]] == consistent;
            }
            return current;
        }
        return a1 - a2;
    }

    private void precompute() {
        int i;
        for (i = 0; i < this.alphabet.length && this.alphabet[i] instanceof DiscreteAlphabet && ((DiscreteAlphabet)this.alphabet[i]).getMaximalSymbolLength() == 1; ++i) {
        }
        this.delim = i == this.alphabet.length ? "" : " ";
        this.l = this.alphabet[0].length();
        for (i = 1; i < this.alphabet.length; ++i) {
            this.l = Math.max(this.l, this.alphabet[i].length());
        }
    }

    public Alphabet getAlphabetAt(int pos) {
        if (this.alphabet.length == 1) {
            return this.alphabet[0];
        }
        return this.alphabet[this.index[pos]];
    }

    public double getAlphabetLengthAt(int pos) {
        if (this.alphabet.length == 1) {
            return this.alphabet[0].length();
        }
        return this.alphabet[this.index[pos]].length();
    }

    public double getCode(int pos, String sym) throws WrongAlphabetException {
        if (this.isDiscreteAt(pos)) {
            return ((DiscreteAlphabet)this.getAlphabetAt(pos)).getCode(sym);
        }
        double candidat = Double.parseDouble(sym);
        if (!((ContinuousAlphabet)this.getAlphabetAt(pos)).isEncodedSymbol(candidat)) {
            throw new WrongAlphabetException();
        }
        return candidat;
    }

    public AlphabetContainer getCompositeContainer(int[] start, int[] length) {
        int i;
        if (this.alphabet.length == 1) {
            return this;
        }
        int l = 0;
        for (i = 0; i < length.length; ++i) {
            l += length[i];
        }
        int[] ind = new int[l];
        int[] used = new int[this.alphabet.length];
        Arrays.fill(used, -1);
        ArrayList<Alphabet> list = new ArrayList<Alphabet>();
        l = 0;
        for (i = 0; i < length.length; ++i) {
            for (int j = 0; j < length[i]; ++j) {
                if (used[this.index[start[i] + j]] < 0) {
                    used[this.index[start[i] + j]] = list.size();
                    list.add(this.alphabet[this.index[start[i] + j]]);
                }
                ind[l++] = used[this.index[start[i] + j]];
            }
        }
        if (list.size() == 1) {
            return new AlphabetContainer(this.alphabet[start[0]]);
        }
        return new AlphabetContainer(list.toArray(new Alphabet[0]), ind);
    }

    @Override
    public AlphabetContainerParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters.clone();
        }
        if (this.isSimple()) {
            return new AlphabetContainerParameterSet(this.alphabet[0]);
        }
        if (this.index.length == this.alphabet.length) {
            return new AlphabetContainerParameterSet(this.alphabet);
        }
        return new AlphabetContainerParameterSet(this.alphabet, this.index);
    }

    public String getDelim() {
        return this.delim;
    }

    public double getMaximalAlphabetLength() {
        return this.l;
    }

    public double getMin(int pos) {
        if (this.alphabet.length == 1) {
            return this.alphabet[0].getMin();
        }
        return this.alphabet[this.index[pos]].getMin();
    }

    public double getMinimalAlphabetLength() {
        double length = this.alphabet[0].length();
        for (int i = 1; i < this.alphabet.length; ++i) {
            length = Math.min(length, this.alphabet[i].length());
        }
        return length;
    }

    public int getPossibleLength() {
        return this.alphabet.length == 1 ? 0 : this.index.length;
    }

    public AlphabetContainer getSubContainer(int start, int length) {
        if (this.alphabet.length == 1 || start == 0 && length == this.getPossibleLength()) {
            return this;
        }
        int[] ind = new int[length];
        int[] used = new int[this.alphabet.length];
        Arrays.fill(used, -1);
        ArrayList<Alphabet> list = new ArrayList<Alphabet>();
        int i = 0;
        while (i < length) {
            if (used[this.index[start]] < 0) {
                used[this.index[start]] = list.size();
                list.add(this.alphabet[this.index[start]]);
            }
            ind[i] = used[this.index[start]];
            ++i;
            ++start;
        }
        if (list.size() == 1) {
            return new AlphabetContainer((Alphabet)list.get(0));
        }
        return new AlphabetContainer(list.toArray(new Alphabet[0]), ind);
    }

    public String getSymbol(int pos, double val) {
        if (this.isDiscreteAt(pos)) {
            if (this.isSimple()) {
                return ((DiscreteAlphabet)this.alphabet[0]).getSymbolAt((int)val);
            }
            return ((DiscreteAlphabet)this.alphabet[this.index[pos]]).getSymbolAt((int)val);
        }
        return "" + val;
    }

    public final boolean ignoresCase() {
        int i;
        for (i = 0; i < this.alphabet.length && (this.alphabet[i] instanceof ContinuousAlphabet || ((DiscreteAlphabet)this.alphabet[i]).ignoresCase()); ++i) {
        }
        return this.alphabet.length == i;
    }

    public final boolean isDiscrete() {
        return this.getType() == AlphabetContainerType.DISCRETE;
    }

    public boolean isDiscreteAt(int pos) {
        if (this.alphabet.length == 1) {
            return this.alphabet[0] instanceof DiscreteAlphabet;
        }
        return this.alphabet[this.index[pos]] instanceof DiscreteAlphabet;
    }

    public boolean isEncodedSymbol(int pos, double continuous) {
        if (this.isDiscreteAt(pos)) {
            int discrete = this.toDiscrete(pos, continuous);
            return ((DiscreteAlphabet)this.getAlphabetAt(pos)).isEncodedSymbol(discrete) && (double)discrete - continuous == 0.0;
        }
        return ((ContinuousAlphabet)this.getAlphabetAt(pos)).isEncodedSymbol(continuous);
    }

    public final boolean isSimple() {
        return this.alphabet.length == 1;
    }

    public final boolean isReverseComplementable() {
        return this.isSimple() && this.alphabet[0] instanceof ComplementableDiscreteAlphabet;
    }

    public int toDiscrete(int pos, double val) {
        if (this.isDiscreteAt(pos)) {
            return (int)val;
        }
        return (int)(val - this.getAlphabetAt(pos).getMin());
    }

    public String toString() {
        String erg = "possible length: " + this.getPossibleLength() + "\n";
        erg = erg + "alphabet : ";
        if (this.getPossibleLength() == 0) {
            erg = erg + this.alphabet[0].toString();
        } else {
            for (int i = 0; i < this.getPossibleLength(); ++i) {
                erg = erg + "\n\t" + i + "\t" + this.getAlphabetAt(i).toString();
            }
        }
        return erg + "\n";
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(300 + this.alphabet.length * 200);
        XMLParser.appendStorableArrayWithTags(xml, this.alphabet, "Alphabets");
        if (this.alphabet.length > 1) {
            XMLParser.appendIntArrayWithTags(xml, this.index, "Assignment");
        }
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    public final AlphabetContainerType getType() {
        return AlphabetContainerType.determineType(this.alphabet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlphabetContainerType {
        DISCRETE,
        CONTINUOUS,
        BOTH;


        static AlphabetContainerType determineType(Alphabet[] alphabets) {
            boolean discrete = true;
            boolean continuous = true;
            for (int i = 0; i < alphabets.length; ++i) {
                if ((discrete &= alphabets[i] instanceof DiscreteAlphabet) || (continuous &= alphabets[i] instanceof ContinuousAlphabet)) continue;
                return BOTH;
            }
            AlphabetContainerType type = null;
            type = discrete ? DISCRETE : CONTINUOUS;
            return type;
        }
    }
}

