/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.directory;

import java.util.Collections;
import java.util.Map;
import org.biojava.directory.RegistryException;
import org.biojava.utils.OverlayMap;

public interface RegistryConfiguration {
    public Map getConfiguration() throws RegistryException;

    public String getConfigLocator();

    public static class Composite
    implements RegistryConfiguration {
        private String configLocator;
        private Map config;

        public Map getConfiguration() {
            if (this.config == null) {
                return Collections.EMPTY_MAP;
            }
            return this.config;
        }

        public String getConfigLocator() {
            return this.configLocator;
        }

        public void addTopConfig(RegistryConfiguration newConfig) throws RegistryException {
            Map cfg = newConfig.getConfiguration();
            if (this.config == null) {
                this.config = cfg;
                this.configLocator = newConfig.getConfigLocator();
            } else {
                this.config = new OverlayMap(this.config, cfg);
                this.configLocator = newConfig.getConfigLocator() + "::" + this.configLocator;
            }
        }

        public void addBottomConfig(RegistryConfiguration newConfig) throws RegistryException {
            Map cfg = newConfig.getConfiguration();
            if (this.config == null) {
                this.config = cfg;
                this.configLocator = newConfig.getConfigLocator();
            } else {
                this.config = new OverlayMap(cfg, this.config);
                this.configLocator = this.configLocator + "::" + newConfig.getConfigLocator();
            }
        }
    }

    public static class Impl
    implements RegistryConfiguration {
        private String configFileLocation = null;
        private Map config = null;

        public Impl(String configFileLocation, Map config) {
            this.configFileLocation = configFileLocation;
            this.config = config;
        }

        public Map getConfiguration() {
            return this.config;
        }

        public String getConfigLocator() {
            return this.configFileLocation;
        }
    }
}

