/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ObjectUtil;

public class SimpleSeqSimilaritySearchHit
extends AbstractChangeable
implements SeqSimilaritySearchHit {
    protected transient ChangeForwarder annotationForwarder;
    private double score;
    private double pValue;
    private double eValue;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private String subjectID;
    private Annotation annotation;
    private List subHits;
    private int hc;
    private boolean hcCalc;

    public SimpleSeqSimilaritySearchHit(double score, double eValue, double pValue, int queryStart, int queryEnd, StrandedFeature.Strand queryStrand, int subjectStart, int subjectEnd, StrandedFeature.Strand subjectStrand, String subjectID, Annotation annotation, List subHits) {
        if (Double.isNaN(score)) {
            throw new IllegalArgumentException("score was NaN");
        }
        if (subjectID == null) {
            throw new IllegalArgumentException("subjectID was null");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("annotation was null");
        }
        if (subHits == null) {
            throw new IllegalArgumentException("subHits was null");
        }
        annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.score = score;
        this.eValue = eValue;
        this.pValue = pValue;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.queryStrand = queryStrand;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.subjectStrand = subjectStrand;
        this.subjectID = subjectID;
        this.annotation = annotation;
        this.subHits = Collections.unmodifiableList(subHits);
        this.hcCalc = false;
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.queryStrand;
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.subjectStrand;
    }

    public String getSubjectID() {
        return this.subjectID;
    }

    public List getSubHits() {
        return this.subHits;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSeqSimilaritySearchHit that = (SimpleSeqSimilaritySearchHit)other;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.subjectID, that.subjectID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, that.subHits);
    }

    public int hashCode() {
        if (!this.hcCalc) {
            this.hc = ObjectUtil.hashCode(this.hc, this.score);
            this.hc = ObjectUtil.hashCode(this.hc, this.pValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.eValue);
            this.hc = ObjectUtil.hashCode(this.hc, this.subjectID);
            this.hc = ObjectUtil.hashCode(this.hc, this.subHits);
            this.hcCalc = true;
        }
        return this.hc;
    }

    public String toString() {
        return "SimpleSeqSimilaritySearchHit to " + this.getSubjectID() + " with score " + this.getScore();
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct.isMatchingType(Annotatable.ANNOTATION) || Annotatable.ANNOTATION.isMatchingType(ct))) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        return cs;
    }
}

