/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.Constraint;

public abstract class InhConstraint
extends Constraint
implements Cloneable {
    protected int[] offset;

    private static int product(int[] selected, int[] values) {
        int erg = 1;
        int i = 0;
        while (i < selected.length) {
            erg *= values[selected[i++]];
        }
        return erg;
    }

    public InhConstraint(int[] pos, int[] alphabetLength) {
        super(pos, InhConstraint.product(pos, alphabetLength));
        int i = pos.length;
        this.offset = new int[i--];
        this.offset[i--] = 1;
        while (i >= 0) {
            this.offset[i] = this.offset[i + 1] * alphabetLength[pos[i + 1]];
            --i;
        }
    }

    public InhConstraint(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
        this.offset = XMLParser.extractIntArrayForTag(xml, "offset");
    }

    public InhConstraint clone() throws CloneNotSupportedException {
        InhConstraint clone = (InhConstraint)super.clone();
        clone.offset = (int[])this.offset.clone();
        return clone;
    }

    public int satisfiesSpecificConstraint(Sequence s, int start) {
        int erg = 0;
        for (int counter = 0; counter < this.usedPositions.length; ++counter) {
            erg += this.offset[counter] * s.discreteVal(start + this.usedPositions[counter]);
        }
        return erg;
    }

    protected void appendAdditionalInfo(StringBuffer xml) {
        XMLParser.appendIntArrayWithTags(xml, this.offset, "offset");
    }
}

