/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture.motif;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.models.Model;
import de.jstacs.models.mixture.AbstractMixtureModel;
import de.jstacs.models.mixture.gibbssampling.BurnInTest;
import de.jstacs.models.mixture.motif.positionprior.PositionPrior;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import java.util.Arrays;
import javax.naming.OperationNotSupportedException;

public abstract class HiddenMotifMixture
extends AbstractMixtureModel
implements MotifDiscoverer {
    protected PositionPrior posPrior;

    protected HiddenMotifMixture(Model[] models, boolean[] optimzeArray, int components, int starts, boolean estimateComponentProbs, double[] componentHyperParams, double[] weights, PositionPrior posPrior, AbstractMixtureModel.Algorithm algorithm, double alpha, double eps, AbstractMixtureModel.Parameterization parametrization, int initialIteration, int stationaryIteration, BurnInTest burnInTest) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        super(posPrior.getLength(), models, optimzeArray, components, starts, estimateComponentProbs, componentHyperParams, weights, algorithm, alpha, eps, parametrization, initialIteration, stationaryIteration, burnInTest);
        if (!this.alphabets.isSimple()) {
            throw new WrongAlphabetException("The AlphabetContainer has to be simple.");
        }
        this.posPrior = posPrior.clone();
        this.posPrior.setMotifLength(this.getMotifLength(0));
    }

    protected HiddenMotifMixture(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public HiddenMotifMixture clone() throws CloneNotSupportedException {
        HiddenMotifMixture clone = (HiddenMotifMixture)super.clone();
        clone.posPrior = this.posPrior.clone();
        return clone;
    }

    protected StringBuffer getFurtherInformation() {
        StringBuffer erg = new StringBuffer(1000);
        XMLParser.appendStorableWithTags(erg, this.posPrior, "posPrior");
        return erg;
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.posPrior = (PositionPrior)XMLParser.extractStorableForTag(xml, "posPrior");
        this.posPrior.setMotifLength(this.getMotifLength(0));
    }

    public void train(Sample data, double[] weights) throws Exception {
        if (data.getMinimalElementLength() < this.getMinimalSequenceLength()) {
            throw new IllegalArgumentException("The sample contains sequence that are not allowed in this MotifDiscoverer. The minimal length is " + this.getMinimalSequenceLength() + ".");
        }
        super.train(data, weights);
    }

    protected void getNewParameters(int iteration, double[][] seqWeights, double[] w) throws Exception {
        for (int i = 0; i < seqWeights.length; ++i) {
            this.getNewParametersForModel(i, iteration, i, seqWeights[i]);
        }
        this.getNewComponentProbs(w);
    }

    public abstract void trainBgModel(Sample var1, double[] var2) throws Exception;

    protected void checkLength(int index, int l) {
        if (index == 0) {
            if (this.length != 0 && this.length < l) {
                throw new IllegalArgumentException("The motif length is bigger than the length of the sequences the should be modeled.");
            }
        } else if (l != 0) {
            throw new IllegalArgumentException("All models accept the motif model have to be homogeneous. Violated at position " + index + ".");
        }
    }

    public abstract int getMinimalSequenceLength();

    public String getInstanceName() {
        StringBuffer erg = new StringBuffer(this.getClass().getSimpleName() + "(");
        erg.append(this.model[0].getInstanceName());
        for (int i = 1; i < this.model.length; ++i) {
            erg.append(", ");
            erg.append(this.model[i].getInstanceName());
        }
        erg.append("; " + this.posPrior.getInstanceName());
        if (!this.estimateComponentProbs) {
            erg.append("; " + Arrays.toString(this.weights));
        }
        erg.append(")");
        return erg.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100000);
        sb.append(this.weights[0] + "\tmotif\n");
        sb.append(this.weights[1] + "\tno motif\n\n");
        sb.append("position prior: " + this.posPrior.getInstanceName() + "\n\n");
        for (int i = 0; i < this.dimension; ++i) {
            sb.append(this.model[i].getInstanceName() + "\n" + ((Object)this.model[i]).toString() + "\n");
        }
        return sb.toString();
    }

    protected Sequence[] emitSampleUsingCurrentParameterSet(int n, int ... lengths) throws Exception {
        throw new OperationNotSupportedException();
    }
}

