/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParameterSet
extends ExpandableParameterSet {
    private int numberChanged;
    private String lengthName;
    private String lengthComment;
    private NumberValidator<Integer> allowedLengths;

    public ArrayParameterSet(ParameterSet template, String nameTemplate, String commentTemplate, String lengthName, String lengthComment, NumberValidator<Integer> allowedLengths) {
        super(template, nameTemplate, commentTemplate);
        this.lengthName = lengthName;
        this.lengthComment = lengthComment;
        this.allowedLengths = allowedLengths;
    }

    public ArrayParameterSet(ParameterSet template, String nameTemplate, String commentTemplate) {
        this(template, nameTemplate, commentTemplate, "Length", "The length of the array.", new NumberValidator<Integer>(1, Integer.MAX_VALUE));
    }

    public ArrayParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected final void loadParameters() throws Exception {
        block3: {
            int oldLength;
            int length;
            block4: {
                block2: {
                    if (this.parameters != null) break block2;
                    this.initParameterList();
                    SimpleParameter length2 = new SimpleParameter(DataType.INT, this.lengthName, this.lengthComment, true, this.allowedLengths);
                    length2.setDefault(this.allowedLengths.getLowerBound());
                    length2.setValue(this.allowedLengths.getLowerBound());
                    length2.setRangeable(false);
                    this.parameters.add(length2);
                    this.addParameterToSet();
                    this.numberChanged = 1;
                    break block3;
                }
                length = (Integer)((Parameter)this.parameters.get(0)).getValue();
                oldLength = this.parameters.size() - 1;
                this.numberChanged = length - oldLength;
                if (length <= oldLength) break block4;
                for (int i = 0; i < length - oldLength; ++i) {
                    this.addParameterToSet();
                }
                break block3;
            }
            if (length >= oldLength) break block3;
            for (int i = 0; i < oldLength - length; ++i) {
                this.removeParameterFromSet();
            }
        }
    }

    @Override
    public int getNumberOfParameters() {
        try {
            this.loadParameters();
            if (this.ranged) {
                this.replaceParametersWithRangedInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.getNumberOfParameters();
    }

    @Override
    public Parameter getParameterAt(int i) {
        try {
            this.loadParameters();
            if (this.ranged) {
                this.replaceParametersWithRangedInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.getParameterAt(i);
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.numberChanged != 0) {
            return false;
        }
        return super.hasDefaultOrIsSet();
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "arrayParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superRepresentation"));
        this.lengthName = XMLParser.extractStringForTag(representation, "lengthName");
        this.lengthComment = XMLParser.extractStringForTag(representation, "lengthComment");
        this.allowedLengths = (NumberValidator)XMLParser.extractStorableForTag(representation, "allowedLengths");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer supBuf = super.toXML();
        XMLParser.addTags(supBuf, "superRepresentation");
        XMLParser.appendStringWithTags(supBuf, this.lengthName, "lengthName");
        XMLParser.appendStringWithTags(supBuf, this.lengthComment, "lengthComment");
        XMLParser.appendStorableWithTags(supBuf, this.allowedLengths, "allowedLengths");
        XMLParser.addTags(supBuf, "arrayParameterSet");
        return supBuf;
    }
}

