/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;

public abstract class Parameter
implements Storable,
Cloneable {
    protected ParameterSet neededReference;
    protected Long neededReferenceId;
    protected ParameterSet parent;
    private long id = System.currentTimeMillis() + (long)this.hashCode();

    public long getId() {
        return this.id;
    }

    public abstract String getName();

    public abstract DataType getDatatype();

    public abstract String getComment();

    public abstract boolean isRequired();

    public abstract boolean checkValue(Object var1);

    public abstract void setValue(Object var1) throws SimpleParameter.IllegalValueException;

    public abstract Object getValue();

    public abstract boolean hasDefaultOrIsSet();

    public ParameterSet getNeededReference() {
        return this.neededReference;
    }

    public Long getNeededReferenceId() {
        return this.neededReferenceId;
    }

    public void setNeededReference(ParameterSet reference) {
        this.neededReference = reference;
        this.neededReferenceId = reference.getId();
    }

    public abstract boolean isSet();

    public abstract boolean isAtomic();

    public abstract String getErrorMessage();

    public abstract void simplify();

    public abstract void reset();

    public Parameter clone() throws CloneNotSupportedException {
        Parameter clone = (Parameter)super.clone();
        clone.neededReference = null;
        clone.parent = null;
        return clone;
    }

    public abstract void setDefault(Object var1) throws Exception;

    public void setParent(ParameterSet parent) {
        this.parent = parent;
    }

    public ParameterSet getParent() {
        return this.parent;
    }

    protected void fromXML(StringBuffer source) throws NonParsableException {
        source = XMLParser.extractForTag(source, "parameter");
        this.id = XMLParser.extractLongForTag(source, "id");
        try {
            this.neededReferenceId = XMLParser.extractLongForTag(source, "neededReferenceId");
        }
        catch (NonParsableException e) {
            this.neededReferenceId = null;
        }
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendLongWithTags(buf, this.id, "id");
        XMLParser.addTags(buf, "parameter");
        if (this.neededReference != null) {
            XMLParser.appendLongWithTags(buf, this.neededReferenceId, "neededReferenceId");
        }
        return buf;
    }
}

