/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.DoubleTriple;
import de.jtem.numericalMethods.geometry.geodesic.IntTriple;

public class BaryCoords3d {
    static double eps = 1.0E-6;
    static int FALSE = 0;
    static int TRUE = 0;

    BaryCoords3d() {
    }

    static void correct(double[] dArray) {
        double d = 0.0;
        int n = 0;
        for (n = 0; n < 3; ++n) {
            if (Math.abs(dArray[n]) < eps) {
                dArray[n] = 0.0;
            }
            d += dArray[n];
        }
        for (n = 0; dArray[n] == 0.0 && n < 3; ++n) {
        }
        int n2 = (n + 1) % 3;
        dArray[n2] = dArray[n2] / d;
        int n3 = (n + 2) % 3;
        dArray[n3] = dArray[n3] / d;
        dArray[n] = 1.0 - dArray[n2] - dArray[n3];
    }

    public static double sqr(double d, double d2, double d3, double[] dArray) {
        return -(d * d * dArray[1] * dArray[2] + d2 * d2 * dArray[0] * dArray[2] + d3 * d3 * dArray[1] * dArray[0]);
    }

    public static double abs(double d, double d2, double d3, double[] dArray) {
        return Math.sqrt(-(d * d * dArray[1] * dArray[2] + d2 * d2 * dArray[0] * dArray[2] + d3 * d3 * dArray[1] * dArray[0]));
    }

    public static double dot(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        return -0.5 * (d * d * (dArray[1] * dArray2[2] + dArray[2] * dArray2[1]) + d2 * d2 * (dArray[0] * dArray2[2] + dArray[2] * dArray2[0]) + d3 * d3 * (dArray[1] * dArray2[0] + dArray[0] * dArray2[1]));
    }

    public static double dist(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = dArray[0] - dArray2[0];
        double d5 = dArray[1] - dArray2[1];
        double d6 = dArray[2] - dArray2[2];
        return Math.sqrt(-(d * d * d5 * d6 + d2 * d2 * d4 * d6 + d3 * d3 * d5 * d4));
    }

    static void norm(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        BaryCoords3d.vecScl(dArray, dArray2, 1.0 / Math.sqrt(-(d * d * dArray2[1] * dArray2[2] + d2 * d2 * dArray2[0] * dArray2[2] + d3 * d3 * dArray2[1] * dArray2[0])));
    }

    static void rotate90(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = BaryCoords3d.sqr(d, d2, d3, dArray2);
        dArray[0] = dArray2[2];
        dArray[1] = dArray2[0];
        dArray[2] = dArray2[1];
        BaryCoords3d.vecLinComb(dArray, dArray, 1.0, dArray2, -BaryCoords3d.dot(d, d2, d3, dArray2, dArray) / d4);
        BaryCoords3d.vecScl(dArray, dArray, Math.sqrt(d4) / BaryCoords3d.abs(d, d2, d3, dArray));
    }

    static void normal(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[2];
        dArray[1] = dArray2[0];
        dArray[2] = dArray2[1];
        BaryCoords3d.vecLinComb(dArray, dArray, 1.0, dArray2, -BaryCoords3d.dot(d, d2, d3, dArray2, dArray) / BaryCoords3d.sqr(d, d2, d3, dArray2));
        BaryCoords3d.vecScl(dArray, dArray, 1.0 / BaryCoords3d.abs(d, d2, d3, dArray));
    }

    static void orthonormalize(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        BaryCoords3d.norm(d, d2, d3, dArray, dArray);
        BaryCoords3d.vecLinComb(dArray2, dArray2, 1.0, dArray, -BaryCoords3d.dot(d, d2, d3, dArray, dArray2));
        BaryCoords3d.norm(d, d2, d3, dArray2, dArray2);
    }

    public static double angle(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double d4 = Math.sqrt(-(d * d * dArray[1] * dArray[2] + d2 * d2 * dArray[0] * dArray[2] + d3 * d3 * dArray[1] * dArray[0]));
        double d5 = Math.sqrt(-(d * d * dArray2[1] * dArray2[2] + d2 * d2 * dArray2[0] * dArray2[2] + d3 * d3 * dArray2[1] * dArray2[0]));
        double d6 = BaryCoords3d.dot(d, d2, d3, dArray, dArray2) / d4 / d5;
        d6 = Math.min(1.0, Math.max(-1.0, d6));
        return Math.acos(d6);
    }

    public static double orientedAngle(double d, double d2, double d3, double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        double d4 = Math.sqrt(-(d * d * dArray[1] * dArray[2] + d2 * d2 * dArray[0] * dArray[2] + d3 * d3 * dArray[1] * dArray[0]));
        double d5 = Math.sqrt(-(d * d * dArray2[1] * dArray2[2] + d2 * d2 * dArray2[0] * dArray2[2] + d3 * d3 * dArray2[1] * dArray2[0]));
        double d6 = BaryCoords3d.dot(d, d2, d3, dArray, dArray2) / d4 / d5;
        d6 = Math.min(1.0, Math.max(-1.0, d6));
        BaryCoords3d.normal(d, d2, d3, dArray3, dArray);
        if (BaryCoords3d.dot(d, d2, d3, dArray3, dArray2) < 0.0) {
            return -Math.acos(d6);
        }
        return Math.acos(d6);
    }

    static void rotate(double d, double d2, double d3, double[] dArray, double[] dArray2, double d4) {
        double[] dArray3 = new double[3];
        BaryCoords3d.normal(d, d2, d3, dArray3, dArray);
        BaryCoords3d.vecScl(dArray3, dArray3, BaryCoords3d.abs(d, d2, d3, dArray));
        BaryCoords3d.vecLinComb(dArray2, dArray, Math.cos(d4), dArray3, Math.sin(d4));
    }

    static void convertToVec3(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        dArray[0] = dArray2[0] * dArray3[0] + dArray2[1] * dArray4[0] + dArray2[2] * dArray5[0];
        dArray[1] = dArray2[0] * dArray3[1] + dArray2[1] * dArray4[1] + dArray2[2] * dArray5[1];
        dArray[2] = dArray2[0] * dArray3[2] + dArray2[1] * dArray4[2] + dArray2[2] * dArray5[2];
    }

    int gmBaryInTriangleConvertFromVec3(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d;
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        while (!(Math.abs(d = dArray3[n] * dArray4[n2] - dArray3[n2] * dArray4[n] - (dArray2[n] * dArray4[n2] - dArray2[n2] * dArray4[n]) + dArray2[n] * dArray3[n2] - dArray2[n2] * dArray3[n]) > eps)) {
            if (n2 == 1) {
                n2 = 2;
                n3 = 1;
                continue;
            }
            if (n == 0) {
                n = 1;
                n3 = 0;
                continue;
            }
            System.out.println("mBaryInElementConvertFromVec3: triangle degenerated?");
            return FALSE;
        }
        dArray[0] = (dArray3[n] * dArray4[n2] - dArray3[n2] * dArray4[n] - (dArray5[n] * dArray4[n2] - dArray5[n2] * dArray4[n]) + dArray5[n] * dArray3[n2] - dArray5[n2] * dArray3[n]) / d;
        dArray[1] = (dArray5[n] * dArray4[n2] - dArray5[n2] * dArray4[n] - (dArray2[n] * dArray4[n2] - dArray2[n2] * dArray4[n]) + dArray2[n] * dArray5[n2] - dArray2[n2] * dArray5[n]) / d;
        dArray[2] = 1.0 - dArray[0] - dArray[1];
        if (Math.abs(dArray2[n3] * dArray[0] + dArray3[n3] * dArray[1] + dArray4[n3] * dArray[2] - dArray5[n3]) > 0.001) {
            System.out.println("gmBaryInElementConvertFromVec3: test for third row failed.");
            return FALSE;
        }
        BaryCoords3d.correct(dArray);
        return TRUE;
    }

    int clip(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        int n = FALSE;
        double d = 1.0E98;
        for (int i = 0; i < 3; ++i) {
            double d2;
            if (0.0 <= dArray2[i] && dArray2[i] <= 1.0 || !(dArray2[i] < 0.0) || !((d2 = dArray[i] / (dArray[i] - dArray2[i])) < d)) continue;
            d = d2;
        }
        if (d != 1.0E98) {
            n = TRUE;
            DoubleTriple.sub(dArray3, dArray2, dArray);
            DoubleTriple.scale(dArray3, dArray3, d);
            DoubleTriple.add(dArray2, dArray, dArray3);
            BaryCoords3d.correct(dArray2);
        }
        return n;
    }

    static void interpolate(double[] dArray, double[] dArray2, double[][] dArray3) {
        dArray[0] = dArray2[0] * dArray3[0][0] + dArray2[1] * dArray3[1][0] + dArray2[2] * dArray3[2][0];
        dArray[1] = dArray2[0] * dArray3[0][1] + dArray2[1] * dArray3[1][1] + dArray2[2] * dArray3[2][1];
        dArray[2] = dArray2[0] * dArray3[0][2] + dArray2[1] * dArray3[1][2] + dArray2[2] * dArray3[2][2];
    }

    static void interpolateVec3(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        dArray[0] = dArray2[0] * dArray3[0] + dArray2[1] * dArray4[0] + dArray2[2] * dArray5[0];
        dArray[1] = dArray2[0] * dArray3[1] + dArray2[1] * dArray4[1] + dArray2[2] * dArray5[1];
        dArray[2] = dArray2[0] * dArray3[2] + dArray2[1] * dArray4[2] + dArray2[2] * dArray5[2];
    }

    static void interpolateVec2f(float[] fArray, double[] dArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        throw new RuntimeException("check behavior of this function. ");
    }

    static double add(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        int n2;
        double d;
        int n3;
        double[] dArray4 = new double[3];
        double d2 = 0.0;
        double d3 = 0.0;
        for (n3 = 0; n3 < 3; ++n3) {
            d3 += dArray3[n3];
            d2 += Math.abs(dArray3[n3]);
        }
        if (Math.abs(d3) > d2 * eps) {
            System.out.println("not a barycentric vector");
            return -1.0;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            if (!(Math.abs(dArray3[n3]) < d2 * eps)) continue;
            int n4 = (n3 + 1) % 3;
            dArray3[n4] = dArray3[n4] + dArray3[n3] / 2.0;
            dArray3[(n3 + 2) % 3] = -dArray3[(n3 + 1) % 3];
            dArray3[n3] = 0.0;
        }
        BaryCoords3d.addVec(dArray4, dArray2, dArray3);
        if (BaryCoords3d.isInsideElement(dArray4)) {
            DoubleTriple.copy(dArray, dArray4);
            return 1.0;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            double d4;
            double d5;
            double d6;
            if (dArray3[n3] == 0.0) continue;
            d = -dArray2[n3] / dArray3[n3];
            if (!(d6 > 0.0)) continue;
            n2 = (n3 + 1) % 3;
            dArray4[n2] = dArray2[n2] + d * dArray3[n2];
            if (!(d5 >= 0.0) || !(dArray4[n2] <= 1.0)) continue;
            n = (n3 + 2) % 3;
            dArray4[n] = dArray2[n] + d * dArray3[n];
            if (!(d4 >= 0.0) || !(dArray4[n] <= 1.0)) continue;
            dArray[n3] = 0.0;
            dArray[n2] = dArray4[n2];
            dArray[n] = 1.0 - dArray4[n2];
            return d;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            double d7;
            double d8;
            double d9;
            if (dArray3[n3] == 0.0) continue;
            d = -dArray2[n3] / dArray3[n3];
            if (!(d9 > eps)) continue;
            n2 = (n3 + 1) % 3;
            dArray4[n2] = dArray2[n2] + d * dArray3[n2];
            if (!(d8 > -eps) || !(dArray4[n2] < 1.0 + eps)) continue;
            n = (n3 + 2) % 3;
            dArray4[n] = dArray2[n] + d * dArray3[n];
            if (!(d7 > -eps) || !(dArray4[n] < 1.0 + eps)) continue;
            dArray[n3] = 0.0;
            dArray[n2] = Math.min(Math.max(dArray4[n2], 0.0), 1.0);
            dArray[n] = 1.0 - dArray4[n2];
            return d;
        }
        DoubleTriple.copy(dArray, dArray2);
        return 0.0;
    }

    public static int getVertex(double[] dArray) {
        if (dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0) {
            return 0;
        }
        if (dArray[0] == 0.0 && dArray[1] == 1.0 && dArray[2] == 0.0) {
            return 1;
        }
        if (dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 1.0) {
            return 2;
        }
        return -1;
    }

    public static int getEdge(double[] dArray) {
        if (dArray[0] == 0.0 && dArray[1] != 0.0 && dArray[2] != 0.0) {
            return 0;
        }
        if (dArray[0] != 0.0 && dArray[1] == 0.0 && dArray[2] != 0.0) {
            return 1;
        }
        if (dArray[0] != 0.0 && dArray[1] != 0.0 && dArray[2] == 0.0) {
            return 2;
        }
        return -1;
    }

    public static int onEdgeSwitchElement(double[] dArray, int[] nArray, int[][] nArray2, int[][] nArray3) {
        double[] dArray2 = new double[3];
        int n = BaryCoords3d.getEdge(dArray);
        int n2 = nArray3[nArray[0]][n];
        if (n2 == -1) {
            // empty if block
        }
        dArray2[IntTriple.getLocInd((int[])nArray2[n2], (int)nArray2[nArray[0]][(n + 1) % 3])] = dArray[(n + 1) % 3];
        dArray2[IntTriple.getLocInd((int[])nArray2[n2], (int)nArray2[nArray[0]][(n + 2) % 3])] = dArray[(n + 2) % 3];
        DoubleTriple.copy(dArray, dArray2);
        nArray[0] = n2;
        return 1;
    }

    public static void outsidePointingEdgeNormal(double[] dArray, int n, int n2, double[] dArray2) {
        double[] dArray3 = dArray2;
        double[] dArray4 = new double[3];
        dArray3[n2] = -1.0;
        dArray3[(n2 + 1) % 3] = 0.5;
        dArray3[(n2 + 1) % 3] = 0.5;
        dArray4[(n2 + 1) % 3] = -1.0 / dArray[n2];
        dArray4[(n2 + 2) % 3] = 1.0 / dArray[n2];
        BaryCoords3d.vecLinComb(dArray3, dArray3, 1.0, dArray4, -BaryCoords3d.dot(dArray[0], dArray[1], dArray[2], dArray3, dArray4));
        BaryCoords3d.vecScl(dArray3, dArray3, 1.0 / BaryCoords3d.abs(dArray[0], dArray[1], dArray[2], dArray3));
    }

    public static void changeToOtherElementAtEdge(int n, int n2, int n3, double[] dArray, double[] dArray2, int[][] nArray, double[] dArray3, double[] dArray4) {
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int n4 = (n3 + 1) % 3;
        int n5 = (n3 + 2) % 3;
        int n6 = nArray[n][n4];
        int n7 = nArray[n][n5];
        dArray6[n4] = -1.0 / dArray3[n3];
        dArray6[n5] = 1.0 / dArray3[n3];
        BaryCoords3d.outsidePointingEdgeNormal(dArray3, n, n3, dArray5);
        double d = BaryCoords3d.dot(dArray3[0], dArray3[1], dArray3[2], dArray5, dArray);
        double d2 = BaryCoords3d.dot(dArray3[0], dArray3[1], dArray3[2], dArray6, dArray);
        int n8 = IntTriple.getLocInd(nArray[n2], n6);
        int n9 = IntTriple.getLocInd(nArray[n2], n7);
        int n10 = 2 * (n8 + n9) % 3;
        dArray6[2] = 0.0;
        dArray6[1] = 0.0;
        dArray6[0] = 0.0;
        dArray6[n8] = -1.0 / dArray4[n10];
        dArray6[n9] = 1.0 / dArray4[n10];
        BaryCoords3d.outsidePointingEdgeNormal(dArray4, n2, n10, dArray5);
        BaryCoords3d.vecLinComb(dArray2, dArray5, -d, dArray6, d2);
    }

    public static int getOtherElementAtEdge(double[] dArray, int n, int[][] nArray, int[][] nArray2) {
        int n2;
        for (n2 = 0; n2 < 3 && dArray[n2] != 0.0; ++n2) {
        }
        if (n2 == 3) {
            throw new IllegalArgumentException("bary0d is not on an edge.");
        }
        return nArray2[n][n2];
    }

    public static int setNewElement(double[] dArray, int[] nArray, int[][] nArray2, int[][] nArray3, int n) {
        if (nArray[0] == n) {
            return 1;
        }
        if (BaryCoords3d.isInnerPoint(dArray)) {
            return n == nArray[0] ? TRUE : FALSE;
        }
        if (BaryCoords3d.isOnEdge(dArray)) {
            if (BaryCoords3d.onEdgeSwitchElement(dArray, nArray, nArray2, nArray3) == TRUE) {
                if (nArray[0] == n) {
                    return 1;
                }
                BaryCoords3d.onEdgeSwitchElement(dArray, nArray, nArray2, nArray3);
                return 0;
            }
            return 0;
        }
        int n2 = IntTriple.getLocInd(nArray2[n], nArray2[nArray[0]][BaryCoords3d.getVertex(dArray)]);
        if (n2 == -1) {
            return 0;
        }
        nArray[0] = n;
        dArray[n2] = 1.0;
        dArray[(n2 + 2) % 3] = 0.0;
        dArray[(n2 + 1) % 3] = 0.0;
        return 1;
    }

    public static int getVerticesOfEdge(double[] dArray, int n, int[][] nArray, int[] nArray2, int[] nArray3) {
        int n2 = BaryCoords3d.getEdge(dArray);
        if (n2 == -1) {
            return 0;
        }
        nArray2[0] = nArray[n][(n2 + 2) % 3];
        nArray3[0] = nArray[n][(n2 + 1) % 3];
        return 1;
    }

    public static boolean vertexIsOnEdge(double[] dArray, int n, int[][] nArray, int n2) {
        int n3 = BaryCoords3d.getVertex(dArray);
        if (n3 == -1) {
            return false;
        }
        return nArray[n][(n3 + 2) % 3] == n2 || nArray[n][(n3 + 1) % 3] == n2;
    }

    public static int leftVertexOfEdge(double[] dArray, int n, int[][] nArray) {
        int n2;
        for (n2 = 0; n2 < 3 && dArray[n2] != 0.0; ++n2) {
        }
        if (n2 == 3) {
            throw new RuntimeException("bary0d is not on an edge");
        }
        return nArray[n][(n2 + 2) % 3];
    }

    public static int rightVertexOfEdge(double[] dArray, int n, int[][] nArray) {
        int n2;
        for (n2 = 0; n2 < 3 && dArray[n2] != 0.0; ++n2) {
        }
        if (n2 == 3) {
            throw new RuntimeException("bary0d is not on an edge.");
        }
        return nArray[n][(n2 + 1) % 3];
    }

    public static int changeBase(double[] dArray, int[] nArray, int[] nArray2) {
        double[] dArray2 = new double[3];
        DoubleTriple.copy(dArray2, dArray);
        DoubleTriple.zero(dArray);
        for (int i = 0; i < 3; ++i) {
            int n;
            if (dArray2[i] == 0.0) continue;
            for (n = 0; n < 3; ++n) {
                if (nArray[i] != nArray2[n]) continue;
                dArray[n] = dArray2[i];
                break;
            }
            if (n != 3) continue;
            DoubleTriple.copy(dArray, dArray2);
            return 0;
        }
        return 1;
    }

    public static int canChangeBase(double[] dArray, int[] nArray, int[] nArray2) {
        for (int i = 0; i < 3; ++i) {
            int n;
            if (dArray[i] == 0.0) continue;
            for (n = 0; n < 3 && nArray[i] != nArray2[n]; ++n) {
            }
            if (n != 3) continue;
            return 0;
        }
        return 1;
    }

    public static void vecScl(double[] dArray, double[] dArray2, double d) {
        double d2 = d;
        dArray[0] = dArray2[0] * d2;
        dArray[1] = dArray2[1] * d2;
        dArray[2] = -dArray[0] - dArray[1];
    }

    public static void vecLinComb(double[] dArray, double[] dArray2, double d, double[] dArray3, double d2) {
        double d3 = d;
        double d4 = d2;
        dArray[0] = dArray2[0] * d3 + dArray3[0] * d4;
        dArray[1] = dArray2[1] * d3 + dArray3[1] * d4;
        dArray[2] = -dArray[0] - dArray[1];
    }

    public static void linComb(double[] dArray, double[] dArray2, double d, double[] dArray3, double d2) {
        double d3 = d;
        double d4 = d2;
        dArray[0] = dArray2[0] * d3 + dArray3[0] * d4;
        dArray[1] = dArray2[1] * d3 + dArray3[1] * d4;
        dArray[2] = 1.0 - dArray[0] - dArray[1];
    }

    public static void addVec(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] + dArray3[0];
        dArray[1] = dArray2[1] + dArray3[1];
        dArray[2] = 1.0 - dArray[0] - dArray[1];
    }

    public static void subVec(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = 1.0 - dArray[0] - dArray[1];
    }

    public static void sub(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        dArray[2] = -dArray[0] - dArray[1];
    }

    public static void vecAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] + dArray3[0];
        dArray[1] = dArray2[1] + dArray3[1];
        dArray[2] = -dArray[0] - dArray[1];
    }

    public static void vecSub(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray3[0] - dArray2[0];
        dArray[1] = dArray3[1] - dArray2[1];
        dArray[2] = -dArray[0] - dArray[1];
    }

    public static boolean isPoint(double[] dArray) {
        return BaryCoords3d.isPoint(dArray, eps);
    }

    public static boolean isPoint(double[] dArray, double d) {
        return Math.abs(dArray[0] + dArray[1] + dArray[2] - 1.0) < d;
    }

    public static boolean isVector(double[] dArray) {
        return BaryCoords3d.isVector(dArray, eps);
    }

    public static boolean isVector(double[] dArray, double d) {
        return Math.abs(dArray[0] + dArray[1] + dArray[2]) < d;
    }

    public static boolean isInsideElement(double[] dArray) {
        return BaryCoords3d.isInsideElement(dArray, eps);
    }

    public static boolean isInsideElement(double[] dArray, double d) {
        return dArray[0] > -d && dArray[0] < 1.0 + d && dArray[1] > -d && dArray[1] < 1.0 + d && dArray[2] > -d && dArray[2] < 1.0 + d;
    }

    public static boolean isInnerPoint(double[] dArray) {
        return dArray[0] > 0.0 && dArray[0] < 1.0 && dArray[1] > 0.0 && dArray[1] < 1.0 && dArray[2] > 0.0 && dArray[2] < 1.0;
    }

    public static boolean isOnEdge(double[] dArray) {
        return dArray[0] == 0.0 && dArray[1] != 0.0 && dArray[2] != 0.0 || dArray[0] != 0.0 && dArray[1] == 0.0 && dArray[2] != 0.0 || dArray[0] != 0.0 && dArray[1] != 0.0 && dArray[2] == 0.0;
    }

    public static boolean isOnVertex(double[] dArray) {
        return dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 || dArray[0] == 0.0 && dArray[1] == 1.0 && dArray[2] == 0.0 || dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 1.0;
    }
}

