/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs.tensor;

import de.jstacs.algorithms.graphs.tensor.AsymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import java.util.Arrays;

public class SymmetricTensor
extends Tensor {
    private int[][] pascal;
    private double[][][] tensor;
    private int[][][] trueEdgeName;
    private int[] indices;
    private int idxOfLastBest;

    public SymmetricTensor(int n, byte k) {
        super(n, k);
        int j = 1;
        int i = 0;
        int l = k + 1;
        this.indices = new int[k];
        this.pascal = new int[this.L][l];
        for (i = 0; i < this.L; ++i) {
            this.pascal[i][0] = 1;
        }
        for (i = this.L - 2; i >= 0; --i) {
            for (j = 1; j < l; ++j) {
                this.pascal[i][j] = this.pascal[i + 1][j - 1] + this.pascal[i + 1][j];
            }
        }
        this.trueEdgeName = new int[l - 1][][];
        this.tensor = new double[l][][];
        this.tensor[0] = new double[n][1];
        for (j = 1; j < l; ++j) {
            this.tensor[j] = new double[n][this.pascal[0][j - 1] + this.pascal[0][j]];
            this.trueEdgeName[j - 1] = new int[n][this.tensor[j][0].length];
            for (i = 0; i < n; ++i) {
                Arrays.fill(this.tensor[j][i], Double.NEGATIVE_INFINITY);
            }
        }
        --this.L;
    }

    public SymmetricTensor(SymmetricTensor[] parts, double[] weights) throws IllegalArgumentException {
        this(parts[0].getNumberOfNodes(), parts[0].getOrder());
        int counter1;
        int n = parts.length;
        int l = parts[0].getNumberOfNodes();
        byte k = parts[0].getOrder();
        if (n != weights.length) {
            throw new IllegalArgumentException("The parts and the weights have to have the same dimension.");
        }
        for (counter1 = 1; counter1 < n; ++counter1) {
            if (parts[counter1].getNumberOfNodes() == l && parts[counter1].getOrder() == k) continue;
            throw new IllegalArgumentException("All parts have to have the same order and number of nodes.");
        }
        for (counter1 = 0; counter1 <= k; ++counter1) {
            for (int counter2 = 0; counter2 < l; ++counter2) {
                for (int counter3 = 0; counter3 < this.tensor[counter1][counter2].length; ++counter3) {
                    this.tensor[counter1][counter2][counter3] = parts[0].tensor[counter1][counter2][counter3] * weights[0];
                    if (counter1 > 0) {
                        this.trueEdgeName[counter1 - 1][counter2][counter3] = parts[0].trueEdgeName[counter1 - 1][counter2][counter3];
                    }
                    for (int counter4 = 1; counter4 < n; ++counter4) {
                        if (counter1 > 0 && this.trueEdgeName[counter1 - 1][counter2][counter3] != parts[counter4].trueEdgeName[counter1 - 1][counter2][counter3]) {
                            throw new IllegalArgumentException("The tensors does not encode the same graph, since at least one edge has a differnet parent permutation.");
                        }
                        double[] dArray = this.tensor[counter1][counter2];
                        int n2 = counter3;
                        dArray[n2] = dArray[n2] + parts[counter4].tensor[counter1][counter2][counter3] * weights[counter4];
                    }
                }
            }
        }
    }

    public SymmetricTensor(AsymmetricTensor asym_tensor) {
        this(asym_tensor.tensor, asym_tensor.getNumberOfNodes(), asym_tensor.getOrder());
    }

    public SymmetricTensor(double[][][] asym_tensor, int N, byte k) {
        this(N, k);
        int i = 0;
        do {
            this.setRootValue(i, asym_tensor[0][i][0]);
        } while ((i = (int)((byte)(i + 1))) < N);
        byte M = (byte)(N - 1);
        for (i = 1; i <= this.order; i = (int)((byte)(i + 1))) {
            int l;
            int[] counter = new int[i + 1];
            int[] array = new int[i];
            int j = 0;
            for (l = i - 1; l >= 0; --l) {
                counter[l] = j++;
            }
            do {
                System.arraycopy(counter, 0, array, 0, i);
                Arrays.sort(array);
                int idx = 0;
                for (j = 0; j < i; ++j) {
                    idx *= N;
                    idx += counter[j];
                }
                for (j = 0; j < N; ++j) {
                    boolean erg = array[0] != j;
                    for (l = 1; l < i && (erg &= array[l] != j && array[l] != array[l - 1]); ++l) {
                    }
                    if (l != i || !erg) continue;
                    this.setValue((byte)i, asym_tensor[i][j][idx], j, counter);
                }
                j = 0;
                while (counter[j] == M) {
                    counter[j++] = 0;
                }
                int n = j;
                counter[n] = counter[n] + 1;
            } while (counter[i] == 0);
        }
    }

    public double getBest(int child, int[] par, byte k) {
        int b;
        int i = k;
        int j = 0;
        byte l = (byte)par.length;
        int[] current = new int[k];
        int[] parents = new int[k];
        for (b = 0; b < k; ++b) {
            current[b] = b;
            parents[b] = par[current[b]];
        }
        double max = Double.NEGATIVE_INFINITY;
        do {
            if (max < this.tensor[k][child][j = this.getIndices(parents, j, (byte)k)]) {
                max = this.tensor[k][child][j];
                this.idxOfLastBest = j;
            }
            b = l;
            while (--i >= 0 && current[i] == --b) {
            }
            if (i < 0) continue;
            j = i;
            int n = i;
            int n2 = i++;
            int n3 = current[n2] + 1;
            current[n2] = n3;
            parents[n] = par[n3];
            while (i < k) {
                current[i] = current[i - 1];
                int n4 = i;
                int n5 = current[n4] + 1;
                current[n4] = n5;
                parents[i] = par[n5];
                ++i;
            }
        } while (i == k);
        this.idxOfLastBest = this.trueEdgeName[k - 1][child][this.idxOfLastBest];
        return max;
    }

    public int[] getEdgeFromIndex(int idx, int k) {
        int[] erg = new int[k];
        for (int j = 0; j < k; ++j) {
            erg[j] = idx % this.powers[1];
            idx /= this.powers[1];
        }
        return erg;
    }

    public int[] getMaximalEdgeFor(byte k, int child, int ... parents) {
        return this.getEdgeFromIndex(k == 0 ? child : this.trueEdgeName[k - 1][child][this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k)], k + 1);
    }

    public double getRootValue(int child) {
        return this.tensor[0][child][0];
    }

    public int getTrueIndexForLastGetBest() {
        return this.idxOfLastBest;
    }

    public double getValue(byte k, int child, int ... parents) {
        return this.tensor[k][child][this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k)];
    }

    public void resetValue(byte k, int child, int ... parents) {
        int i = this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k);
        this.tensor[k][child][i] = Double.NEGATIVE_INFINITY;
        this.trueEdgeName[k - 1][child][i] = 0;
    }

    public void setRootValue(int child, double val) {
        this.tensor[0][child][0] = val;
    }

    public void setValue(byte k, double val, int child, int ... parents) {
        int i = this.getIndex(SymmetricTensor.sortAndClear(child, parents, k), k);
        if (this.tensor[k][child][i] < val) {
            this.tensor[k][child][i] = val;
            if (k > 0) {
                this.trueEdgeName[k - 1][child][i] = this.getAsymIndex(child, parents, k) + this.powers[k] * child;
            }
        }
    }

    private static int[] sortAndClear(int child, int[] parents, int anz) {
        int[] cleared_parents = new int[anz];
        int i = 0;
        int last = 0;
        do {
            cleared_parents[i] = parents[i];
            if (parents[i] <= child) continue;
            int n = i;
            cleared_parents[n] = cleared_parents[n] - 1;
        } while (++i < anz);
        if (anz > 1) {
            while (last != anz) {
                int stop = last;
                last = anz;
                for (i = anz - 1; i > stop; --i) {
                    if (cleared_parents[i] >= cleared_parents[i - 1]) continue;
                    int help = cleared_parents[i];
                    cleared_parents[i] = cleared_parents[i - 1];
                    cleared_parents[i - 1] = help;
                    last = i;
                }
            }
        }
        return cleared_parents;
    }

    private int getIndex(int[] current, byte l) {
        int erg = this.pascal[current[0]][l];
        for (int i = 1; i < l; ++i) {
            erg += this.pascal[current[i]][l - i];
        }
        return erg;
    }

    private int getIndices(int[] current, int i, byte l) {
        if (i == 0) {
            this.indices[0] = this.pascal[current[0]][l];
        } else {
            this.indices[i] = this.indices[i - 1] + this.pascal[current[i]][l - i];
        }
        while (++i < l) {
            this.indices[i] = this.indices[i - 1] + this.pascal[current[i]][l - i];
        }
        return this.indices[l - 1];
    }
}

