/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.Info;

public final class NelderMead {
    private static final long serialVersionUID = 1L;
    static int ITMAX = 200;
    static double rho = 1.0;
    static double chi = 2.0;
    static double gamma = 0.5;
    static double sigma = 0.5;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int n) {
        ITMAX = n;
    }

    public static double[][] getStandardBasis(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray[i][i] = 1.0;
        }
        return dArray;
    }

    public static final double search(double[] dArray, double d, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        return NelderMead.search(dArray, NelderMead.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, ITMAX, null);
    }

    public static final double search(double[] dArray, double d, int n, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        return NelderMead.search(dArray, NelderMead.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, n, null);
    }

    public static final double search(double[] dArray, double d, int n, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, Info info) {
        return NelderMead.search(dArray, NelderMead.getStandardBasis(dArray.length), d, realFunctionOfSeveralVariables, n, info);
    }

    public static double search(double[] dArray, double[][] dArray2, double d, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, int n, Info info) {
        String string = "";
        int n2 = realFunctionOfSeveralVariables.getNumberOfVariables();
        if (dArray.length == n2) {
            int n3;
            int n4;
            int n5 = 0;
            double[][] dArray3 = new double[n2 + 1][n2];
            double[] dArray4 = new double[n2 + 1];
            double[] dArray5 = new double[n2];
            double[] dArray6 = new double[n2];
            double[] dArray7 = new double[n2];
            double[] dArray8 = new double[n2];
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n4 = 0; n4 < n2; ++n4) {
                dArray3[0][n4] = dArray[n4];
            }
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray3[n4 + 1][n3] = dArray[n3];
                }
                if (dArray3[n4 + 1][n4] == 0.0) {
                    double[] dArray9 = dArray3[n4 + 1];
                    int n6 = n4;
                    dArray9[n6] = dArray9[n6] + 2.5E-4 * dArray2[n4][n4];
                    continue;
                }
                double[] dArray10 = dArray3[n4 + 1];
                int n7 = n4;
                dArray10[n7] = dArray10[n7] * (1.0 + 0.05 * dArray2[n4][n4]);
            }
            for (n4 = 0; n4 < n2 + 1; ++n4) {
                dArray4[n4] = realFunctionOfSeveralVariables.eval(dArray3[n4]);
            }
            if (info != null) {
                String string2 = new String(" f(p) = " + dArray4[0] + " , p = ");
                for (n3 = 0; n3 < dArray3[0].length; ++n3) {
                    string2 = string2 + dArray3[0][n3] + " ";
                }
                info.setMessage(string2);
                info.setMaxIter(n);
            }
            NelderMead.order(dArray3, dArray4);
            while (Math.abs(dArray4[n2] - dArray4[0]) > d && n5++ < n && NelderMead.sizeMax(dArray3) > d * d) {
                int n8;
                NelderMead.updateMeanVertex(dArray5, dArray3, n2);
                for (n8 = 0; n8 < n2; ++n8) {
                    dArray6[n8] = (1.0 + rho) * dArray5[n8] - rho * dArray3[n2][n8];
                }
                d2 = realFunctionOfSeveralVariables.eval(dArray6);
                if (d2 < dArray4[0]) {
                    for (n8 = 0; n8 < n2; ++n8) {
                        dArray7[n8] = (1.0 + rho * chi) * dArray5[n8] - rho * chi * dArray3[n2][n8];
                    }
                    d3 = realFunctionOfSeveralVariables.eval(dArray7);
                    if (d3 < d2) {
                        for (n8 = 0; n8 < n2; ++n8) {
                            dArray3[n2][n8] = dArray7[n8];
                        }
                        dArray4[n2] = d3;
                        string = "Expand";
                    } else {
                        for (n8 = 0; n8 < n2; ++n8) {
                            dArray3[n2][n8] = dArray6[n8];
                        }
                        dArray4[n2] = d2;
                        string = "Reflection";
                    }
                } else if (d2 >= dArray4[n2 - 1]) {
                    if (d2 < dArray4[n2]) {
                        for (n8 = 0; n8 < n2; ++n8) {
                            dArray8[n8] = (1.0 + rho * gamma) * dArray5[n8] - rho * gamma * dArray3[n2][n8];
                        }
                        d4 = realFunctionOfSeveralVariables.eval(dArray8);
                        if (d4 <= d2) {
                            for (n8 = 0; n8 < n2; ++n8) {
                                dArray3[n2][n8] = dArray8[n8];
                            }
                            dArray4[n2] = d4;
                            string = "Outside Contraction";
                        } else {
                            NelderMead.shrink(dArray3, dArray4, realFunctionOfSeveralVariables);
                            string = "Shrink";
                        }
                    } else {
                        for (n8 = 0; n8 < n2; ++n8) {
                            dArray8[n8] = (1.0 - gamma) * dArray5[n8] + gamma * dArray3[n2][n8];
                        }
                        d4 = realFunctionOfSeveralVariables.eval(dArray8);
                        if (d4 < d2) {
                            for (n8 = 0; n8 < n2; ++n8) {
                                dArray3[n2][n8] = dArray8[n8];
                            }
                            dArray4[n2] = d4;
                            string = "Inside contraction";
                        } else {
                            NelderMead.shrink(dArray3, dArray4, realFunctionOfSeveralVariables);
                            string = "Shrink";
                        }
                    }
                } else {
                    for (n8 = 0; n8 < n2; ++n8) {
                        dArray3[n2][n8] = dArray6[n8];
                    }
                    dArray4[n2] = d2;
                    string = "Reflection";
                }
                if (info != null) {
                    String string3 = new String("iter = " + n5 + ", action = " + string + ", fp = " + dArray4[0] + ", p = ");
                    for (n3 = 0; n3 < dArray3[0].length; ++n3) {
                        string3 = string3 + dArray3[0][n3] + " ";
                    }
                    info.addMessage(string3);
                }
                NelderMead.order(dArray3, dArray4);
            }
            if (Math.abs(dArray4[n2] - dArray4[0]) <= d && info != null) {
                info.setCurrentIter(n5);
                info.printDebug();
            }
            if (info != null && n5 >= n) {
                info.setCurrentIter(n5);
                info.setMessage("Too many iterations in routine Nelder-Mead simplex");
                info.printDebug();
            }
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = dArray3[0][i];
            }
            return dArray4[0];
        }
        System.out.println("Uncompatible number of parameters and initial point");
        return Double.NaN;
    }

    private static void order(double[][] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 1; i < dArray2.length; ++i) {
            int n = i;
            while (n > 0) {
                if (dArray2[n] < dArray2[n - 1]) {
                    d = dArray2[n];
                    dArray2[n] = dArray2[n - 1];
                    dArray2[n - 1] = d;
                    for (int j = 0; j < dArray[0].length; ++j) {
                        d = dArray[n][j];
                        dArray[n][j] = dArray[n - 1][j];
                        dArray[n - 1][j] = d;
                    }
                    --n;
                    continue;
                }
                n = 0;
            }
        }
    }

    private static void updateMeanVertex(double[] dArray, double[][] dArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            for (int i = 0; i < n; ++i) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + dArray2[i][n2];
            }
            int n4 = n2++;
            dArray[n4] = dArray[n4] / (double)n;
        }
    }

    private static void shrink(double[][] dArray, double[] dArray2, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        NelderMead.order(dArray, dArray2);
        for (int i = 1; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                dArray[i][j] = (1.0 - sigma) * dArray[0][j] + sigma * dArray[i][j];
            }
            dArray2[i] = realFunctionOfSeveralVariables.eval(dArray[i]);
        }
        NelderMead.order(dArray, dArray2);
    }

    private static double sizeMax(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            d += (dArray[0][i] - dArray[dArray.length - 1][i]) * (dArray[0][i] - dArray[dArray.length - 1][i]);
        }
        return d;
    }

    private static double norm2(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }
}

