/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class BulirschStoer
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    double eps = 1.0E-7;
    double stepSize = 0.1;
    private TempDataContainer tdc = new TempDataContainer(this.eps);
    private int[] stepInfo = new int[2];
    private double[] h = new double[1];
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    static final int KMAXX = 8;
    static final int IMAXX = 9;
    static final double SAFE1 = 0.25;
    static final double SAFE2 = 0.7;
    static final double REDMAX = 1.0E-5;
    static final double REDMIN = 0.7;
    static final double TINY = 1.0E-30;
    static final double SCALMX = 0.1;
    static int[] nseq = new int[]{0, 2, 4, 6, 8, 10, 12, 14, 16, 18};
    static final int MAX_NUM_OF_STEPS = 10000;
    static final double EPS = 1.0E-15;

    public BulirschStoer(int n) {
        this.setNumOfEquations(n);
    }

    public BulirschStoer() {
        this(1);
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double d) {
        if (this.stepSize == d) {
            return;
        }
        this.stepSize = d;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double d) {
        if (this.eps == d) {
            return;
        }
        this.eps = d;
        this.tdc = new TempDataContainer(d);
    }

    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    public void setNumOfEquations(int n) {
        if (this.numOfEquations == n) {
            return;
        }
        this.numOfEquations = n;
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2) {
        this.h[0] = this.stepSize;
        BulirschStoer.odex(oDE, dArray, d, d2, this.h, 0.0, this.stepInfo, (ODEIntermediateResultListener)null, this.tdc);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.h[0] = this.stepSize;
        BulirschStoer.odex(oDE, dArray, d, d2, this.h, 0.0, this.stepInfo, oDEIntermediateResultListener, this.tdc);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.h[0] = this.stepSize;
        this.tdc.eps = d3;
        BulirschStoer.odex(oDE, dArray, d, d2, this.h, 0.0, this.stepInfo, oDEIntermediateResultListener, this.tdc);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3) {
        BulirschStoer.solve(oDE, dArray, d, d2, d3, null);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        BulirschStoer.solve(oDE, dArray, d, d2, d3, oDEIntermediateResultListener);
    }

    static double step(ODE oDE, double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, TempDataContainer tempDataContainer) {
        double d2;
        double d3;
        double d4;
        int n;
        int n2 = oDE.getNumberOfEquations();
        double[] dArray6 = tempDataContainer.a;
        double[][] dArray7 = tempDataContainer.alf;
        double[] dArray8 = tempDataContainer.err;
        double[] dArray9 = tempDataContainer.x;
        double[][] dArray10 = tempDataContainer.d;
        double[] dArray11 = tempDataContainer.yerr;
        double[] dArray12 = tempDataContainer.ysav;
        double[] dArray13 = tempDataContainer.yseq;
        double[] dArray14 = tempDataContainer.y_;
        double[] dArray15 = tempDataContainer.y__;
        double d5 = tempDataContainer.eps;
        boolean bl = tempDataContainer.first;
        int n3 = tempDataContainer.kmax;
        int n4 = tempDataContainer.kopt;
        double d6 = d;
        System.arraycopy(dArray, 0, dArray12, 0, n2);
        boolean bl2 = false;
        int n5 = 0;
        while (true) {
            boolean bl3 = false;
            double d7 = 42.0;
            for (n = 1; n <= n3; ++n) {
                double d8 = d6 + dArray3[0];
                if (d8 == d6) {
                    throw new RuntimeException("step size underflow");
                }
                d4 = BulirschStoer.midPointStep(oDE, d6, dArray12, dArray2, dArray3[0], nseq[n], dArray13, dArray14, dArray15);
                d3 = dArray3[0] / (double)nseq[n];
                d3 *= d3;
                BulirschStoer.polynomialExtrapolation(n2, n, d3, dArray13, dArray, dArray11, dArray14, dArray9, dArray10);
                d = d8;
                if (n == 1) continue;
                double d9 = 1.0E-30;
                for (int i = 0; i < n2; ++i) {
                    d9 = Math.max(d9, Math.abs(dArray11[i] / dArray4[i]));
                }
                n5 = n - 1;
                dArray8[n5] = Math.pow((d9 /= d5) / 0.25, 1.0 / (double)(2 * n5 + 1));
                if (n < n4 - 1 && !bl) continue;
                if (d9 < 1.0) {
                    bl3 = true;
                    break;
                }
                if (n == n3 || n == n4 + 1) {
                    d7 = 0.7 / dArray8[n5];
                    break;
                }
                if (n == n4 && dArray7[n4 - 1][n4] < dArray8[n5]) {
                    d7 = 1.0 / dArray8[n5];
                    break;
                }
                if (n4 == n3 && dArray7[n5][n3 - 1] < dArray8[n5]) {
                    d7 = dArray7[n5][n3 - 1] * 0.7 / dArray8[n5];
                    break;
                }
                if (!(dArray7[n5][n4] < dArray8[n5])) continue;
                d7 = dArray7[n5][n4 - 1] / dArray8[n5];
                break;
            }
            if (bl3) break;
            d7 = Math.min(d7, 0.7);
            d7 = Math.max(d7, 1.0E-5);
            dArray3[0] = dArray3[0] * d7;
            bl2 = true;
        }
        dArray5[0] = dArray3[0];
        double d10 = 1.0E35;
        double d11 = -99.0;
        for (int i = 1; i <= n5; ++i) {
            d4 = Math.max(dArray8[i], 0.1);
            d3 = d4 * dArray6[i + 1];
            if (!(d3 < d10)) continue;
            d11 = d4;
            d10 = d3;
            n4 = i + 1;
        }
        double d12 = dArray3[0] / d11;
        if (n4 >= n && n4 != n3 && !bl2 && dArray6[n4 + 1] * (d2 = Math.max(d11 / dArray7[n4 - 1][n4], 0.1)) <= d10) {
            d12 = dArray3[0] / d2;
            ++n4;
        }
        tempDataContainer.first = false;
        tempDataContainer.kopt = n4;
        dArray3[0] = d12;
        return d;
    }

    static void polynomialExtrapolation(int n, int n2, double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[][] dArray6) {
        dArray5[n2] = d;
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray, 0, dArray2, 0, n);
        if (n2 == 1) {
            System.arraycopy(dArray, 0, dArray6[1], 0, n);
        } else {
            System.arraycopy(dArray, 0, dArray4, 0, n);
            for (int i = 1; i < n2; ++i) {
                double d2 = 1.0 / (dArray5[n2 - i] - d);
                double d3 = d * d2;
                double d4 = dArray5[n2 - i] * d2;
                for (int j = 0; j < n; ++j) {
                    double d5 = dArray6[i][j];
                    dArray6[i][j] = dArray3[j];
                    double d6 = dArray4[j] - d5;
                    dArray3[j] = d3 * d6;
                    dArray4[j] = d4 * d6;
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + dArray3[j];
                }
            }
            System.arraycopy(dArray3, 0, dArray6[n2], 0, n);
        }
    }

    static double midPointStep(ODE oDE, double d, double[] dArray, double[] dArray2, double d2, int n, double[] dArray3, double[] dArray4, double[] dArray5) {
        int n2;
        double d3 = d2 / (double)n;
        int n3 = dArray.length;
        double d4 = d;
        d += d3;
        System.arraycopy(dArray, 0, dArray4, 0, n3);
        for (int i = 0; i < n3; ++i) {
            dArray5[i] = dArray[i] + d3 * dArray2[i];
        }
        oDE.eval(d, dArray5, dArray3);
        double d5 = 2.0 * d3;
        for (n2 = 2; n2 <= n; ++n2) {
            double[] dArray6 = dArray4;
            dArray4 = dArray5;
            dArray5 = dArray6;
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                dArray5[n4] = dArray5[n4] + d5 * dArray3[i];
            }
            oDE.eval(d += d3, dArray5, dArray3);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray3[n2] = 0.5 * (dArray4[n2] + dArray5[n2] + d3 * dArray3[n2]);
        }
        return d4 + d2;
    }

    public static void odex(ODE oDE, double[] dArray, double d, double d2, double d3, double[] dArray2, double d4, int[] nArray, ODEIntermediateResultListener oDEIntermediateResultListener) {
        BulirschStoer.odex(oDE, dArray, d, d2, dArray2, d4, nArray, oDEIntermediateResultListener, new TempDataContainer(d3));
    }

    public static void odex(ODE oDE, double[] dArray, double d, double d2, double[] dArray2, double d3, int[] nArray, ODEIntermediateResultListener oDEIntermediateResultListener, TempDataContainer tempDataContainer) {
        int n = oDE.getNumberOfEquations();
        tempDataContainer.reinit(n);
        double[] dArray3 = tempDataContainer.yScale;
        double[] dArray4 = tempDataContainer.yPrime;
        double[] dArray5 = new double[1];
        double d4 = d;
        dArray2[0] = d < d2 ? Math.abs(dArray2[0]) : -Math.abs(dArray2[0]);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 10000; ++i) {
            oDE.eval(d4, dArray, dArray4);
            for (int j = 0; j < n; ++j) {
                dArray3[j] = Math.abs(dArray[j]) + Math.abs(dArray4[j] * dArray2[0]) + 1.0E-30;
            }
            if (Math.abs(d2 - d4) < Math.abs(dArray2[0]) * 1.2) {
                dArray2[0] = d2 - d4;
            }
            double d5 = dArray2[0];
            d4 = BulirschStoer.step(oDE, d4, dArray, dArray4, dArray2, dArray3, dArray5, tempDataContainer);
            if (oDEIntermediateResultListener != null) {
                oDEIntermediateResultListener.intermediateResult(d4, dArray, 0);
            }
            if (dArray2[0] == d5) {
                ++n2;
            } else {
                ++n3;
            }
            if (Math.abs((d4 - d2) / d2) < 1.0E-15) {
                nArray[0] = n2;
                nArray[1] = n3;
                return;
            }
            if (!(Math.abs(dArray5[0]) <= d3)) continue;
            throw new RuntimeException("too small step in odex");
        }
        throw new RuntimeException("too many steps in odex");
    }

    public static class TempDataContainer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        double eps;
        boolean first = true;
        int kmax;
        int kopt;
        double[] a = new double[10];
        double[][] alf = new double[9][9];
        double[] err = new double[9];
        double[] x = new double[9];
        double[][] d;
        double[] yerr;
        double[] ysav;
        double[] yseq;
        double[] yScale;
        double[] yPrime;
        double[] y_;
        double[] y__;

        TempDataContainer(double d) {
            int n;
            this.eps = d;
            double d2 = 0.25 * d;
            this.a[1] = nseq[1] + 1;
            for (n = 1; n <= 8; ++n) {
                this.a[n + 1] = this.a[n] + (double)nseq[n + 1];
            }
            for (n = 2; n <= 8; ++n) {
                for (int i = 1; i < n; ++i) {
                    this.alf[i][n] = Math.pow(d2, (this.a[i + 1] - this.a[n + 1]) / ((this.a[n + 1] - this.a[1] + 1.0) * (double)(2 * i + 1)));
                }
            }
            this.kopt = 2;
            while (this.kopt < 8 && !(this.a[this.kopt + 1] > this.a[this.kopt] * this.alf[this.kopt - 1][this.kopt])) {
                ++this.kopt;
            }
            this.kmax = this.kopt;
        }

        void reinit(int n) {
            this.first = true;
            this.kopt = this.kmax;
            if (this.y_ == null || this.y_.length < n) {
                this.d = new double[9][n];
                this.yerr = new double[n];
                this.ysav = new double[n];
                this.yseq = new double[n];
                this.yScale = new double[n];
                this.yPrime = new double[n];
                this.y_ = new double[n];
                this.y__ = new double[n];
            }
        }
    }
}

