package de.jstacs.motifDiscovery.history;

/**
 * This interface is used to manage the history of some process.
 * 
 * @author Jan Grau, Jens Keilwagen
 */
public interface History extends Cloneable {
	
	/**
	 * Returns <code>true</code> if the specified operation is allowed, i.e. it does not conflict with any operation from the history.
	 * 
	 * @param op the operation to be tested
	 * 
	 * @return <code>true</code> if the specified operation is allowed
	 */
	public boolean operationAllowed(int... op);
	
	/**
	 * This method puts an operation to the history.
	 *  
	 * @param op the performed operation
	 */
	public void operationPerfomed(int... op);
	
	/**
	 * This method clears the history, i.e. it removes all operations from the history.
	 */
	public void clear();
	
	/**
	 * This method returns a deep copy of the instance
	 * 
	 * @return a deep copy
	 * 
	 * @throws CloneNotSupportedException if not possible
	 * 
	 * @see Cloneable
	 * @see Object#clone()
	 */
	public History clone() throws CloneNotSupportedException;
}