/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.biojavax.CrossReferenceResolver;
import org.biojavax.DummyCrossReferenceResolver;
import org.biojavax.Namespace;
import org.biojavax.RichObjectBuilder;
import org.biojavax.SimpleNamespace;
import org.biojavax.SimpleRichObjectBuilder;
import org.biojavax.bio.db.biosql.BioSQLCrossReferenceResolver;
import org.biojavax.bio.db.biosql.BioSQLRichObjectBuilder;
import org.biojavax.bio.db.biosql.BioSQLRichSequenceHandler;
import org.biojavax.bio.seq.DummyRichSequenceHandler;
import org.biojavax.bio.seq.PositionResolver;
import org.biojavax.bio.seq.RichSequenceHandler;
import org.biojavax.ontology.ComparableOntology;
import org.biojavax.ontology.SimpleComparableOntology;

public class RichObjectFactory {
    private static RichObjectBuilder builder = new SimpleRichObjectBuilder();
    private static String defaultOntologyName = "biojavax";
    private static String defaultNamespaceName = "lcl";
    private static PositionResolver defaultPositionResolver = new PositionResolver.AverageResolver();
    private static CrossReferenceResolver defaultCrossRefResolver = new DummyCrossReferenceResolver();
    private static RichSequenceHandler defaultRichSequenceHandler = new DummyRichSequenceHandler();
    private static int defaultLRUcacheSize = 20;
    private static Map LRUcacheSizes = new HashMap();
    private static Map cache = new HashMap();
    private static final Map applicationClassMap = new HashMap();

    private RichObjectFactory() {
    }

    public static synchronized void setRichObjectBuilder(RichObjectBuilder b) {
        builder = b;
    }

    public static synchronized Object getObject(Class clazz, Object[] params) {
        Map m;
        List<Object> paramsList = Arrays.asList(params);
        final Class applicationClass = RichObjectFactory.getApplicationClass(clazz);
        if (!cache.containsKey(applicationClass)) {
            int LRUcacheSize = defaultLRUcacheSize;
            if (LRUcacheSizes.containsKey(applicationClass)) {
                LRUcacheSize = (Integer)LRUcacheSizes.get(applicationClass);
            } else {
                LRUcacheSizes.put(applicationClass, new Integer(LRUcacheSize));
            }
            cache.put(applicationClass, new LinkedHashMap(LRUcacheSize, 0.75f, true){

                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > (Integer)LRUcacheSizes.get(applicationClass);
                }
            });
        }
        if (!(m = (Map)cache.get(applicationClass)).containsKey(paramsList)) {
            m.put(paramsList, builder.buildObject(applicationClass, paramsList));
        }
        return m.get(paramsList);
    }

    private static final Map getApplicationClassMap() {
        return applicationClassMap;
    }

    public static final void setApplicationClass(Class theBiojavaClass, Class theApplicationClass) {
        if (theApplicationClass == null || !theBiojavaClass.isAssignableFrom(theApplicationClass)) {
            throw new IllegalArgumentException("RichObjectFactory.setApplicationClass-theApplicationClass: <" + theApplicationClass + "> must be assignable to the biojava class: <" + theBiojavaClass + ">");
        }
        RichObjectFactory.getApplicationClassMap().put(theBiojavaClass, theApplicationClass);
    }

    private static final Class getApplicationClass(Class theBiojavaClass) {
        Class applicationClass = (Class)RichObjectFactory.getApplicationClassMap().get(theBiojavaClass);
        return applicationClass != null ? applicationClass : theBiojavaClass;
    }

    public static synchronized void clearLRUCache() {
        cache.clear();
    }

    public static synchronized void clearLRUCache(Class clazz) {
        cache.remove(clazz);
    }

    public static void setLRUCacheSize(int size) {
        defaultLRUcacheSize = size;
        Iterator i = LRUcacheSizes.keySet().iterator();
        while (i.hasNext()) {
            LRUcacheSizes.put(i.next(), new Integer(size));
        }
    }

    public static void setLRUCacheSize(Class clazz, int size) {
        LRUcacheSizes.put(clazz, new Integer(size));
    }

    public static void setDefaultNamespaceName(String name) {
        defaultNamespaceName = name;
    }

    public static void setDefaultOntologyName(String name) {
        defaultOntologyName = name;
    }

    public static void setDefaultPositionResolver(PositionResolver pr) {
        defaultPositionResolver = pr;
    }

    public static void setDefaultCrossReferenceResolver(CrossReferenceResolver crr) {
        defaultCrossRefResolver = crr;
    }

    public static void setDefaultRichSequenceHandler(RichSequenceHandler rsh) {
        defaultRichSequenceHandler = rsh;
    }

    public static Namespace getDefaultNamespace() {
        return (Namespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{defaultNamespaceName});
    }

    public static ComparableOntology getDefaultOntology() {
        return (ComparableOntology)RichObjectFactory.getObject(SimpleComparableOntology.class, new Object[]{defaultOntologyName});
    }

    public static PositionResolver getDefaultPositionResolver() {
        return defaultPositionResolver;
    }

    public static CrossReferenceResolver getDefaultCrossReferenceResolver() {
        return defaultCrossRefResolver;
    }

    public static RichSequenceHandler getDefaultRichSequenceHandler() {
        return defaultRichSequenceHandler;
    }

    public static void connectToBioSQL(Object session) {
        RichObjectFactory.clearLRUCache();
        RichObjectFactory.setRichObjectBuilder(new BioSQLRichObjectBuilder(session));
        RichObjectFactory.setDefaultCrossReferenceResolver(new BioSQLCrossReferenceResolver(session));
        RichObjectFactory.setDefaultRichSequenceHandler(new BioSQLRichSequenceHandler(session));
    }
}

