/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.logPrior;

import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;

public abstract class SeparateLogPrior
extends LogPrior
implements Cloneable {
    protected NormalizableScoringFunction[] funs;
    protected double[] vars;
    protected double[] classVars;
    protected double[] classMus;
    protected boolean freeParameters;

    public SeparateLogPrior(double[] vars, double[] classVars, double[] classMus) {
        this.vars = vars;
        this.classMus = classMus;
        this.classVars = classVars;
    }

    public SeparateLogPrior(StringBuffer xml) throws NonParsableException {
        StringBuffer content = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.vars = XMLParser.extractDoubleArrayForTag(content, "variances");
        this.classVars = XMLParser.extractDoubleArrayForTag(content, "classVariances");
        this.classMus = XMLParser.extractDoubleArrayForTag(content, "classMeans");
        this.unset();
    }

    public void set(boolean freeParameters, ScoringFunction ... funs) throws Exception {
        this.funs = new NormalizableScoringFunction[funs.length];
        for (int i = 0; i < funs.length; ++i) {
            if (!(funs[i] instanceof NormalizableScoringFunction)) {
                throw new Exception("Only DirectedGraphicalModels allowed.");
            }
            this.funs[i] = (NormalizableScoringFunction)funs[i];
        }
        this.freeParameters = freeParameters;
        this.unset();
    }

    protected abstract void unset();

    public SeparateLogPrior getNewInstance() throws CloneNotSupportedException {
        SeparateLogPrior clone = (SeparateLogPrior)super.clone();
        clone.vars = (double[])this.vars.clone();
        clone.unset();
        clone.funs = null;
        clone.classVars = (double[])this.classVars.clone();
        clone.classMus = (double[])this.classMus.clone();
        return clone;
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(20 * (this.vars.length + this.classVars.length + this.classMus.length) + 1000);
        XMLParser.appendDoubleArrayWithTags(xml, this.vars, "variances");
        XMLParser.appendDoubleArrayWithTags(xml, this.classVars, "classVariances");
        XMLParser.appendDoubleArrayWithTags(xml, this.classMus, "classMeans");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

