/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture.gibbssampling;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.mixture.gibbssampling.AbstractBurnInTest;
import de.jstacs.utils.DoubleList;

public class VarianceRatioBurnInTest
extends AbstractBurnInTest {
    private double threshold;

    public VarianceRatioBurnInTest(int starts) {
        this(starts, 1.2);
    }

    public VarianceRatioBurnInTest(int starts, double t) {
        super(starts);
        if (starts < 3) {
            throw new IllegalArgumentException("The number of chains (starts of the Gibbs Sampler) must be greater than 2.");
        }
        if (t <= 1.0) {
            throw new IllegalArgumentException("The given threshold value for t has to be greater than 1.");
        }
        this.threshold = t;
    }

    public VarianceRatioBurnInTest(StringBuffer rep) throws NonParsableException {
        super(rep);
    }

    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    protected StringBuffer getFurtherInformation() {
        StringBuffer furtherinf = new StringBuffer(2000);
        XMLParser.appendDoubleWithTags(furtherinf, this.threshold, "threshold");
        return furtherinf;
    }

    protected void setFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = XMLParser.extractDoubleForTag(xml, "threshold");
    }

    public String getInstanceName() {
        return "Variance-Ratio burn-in test of Gelman and Rubin for " + this.values.length + " different chains with threshold " + this.threshold;
    }

    protected int computeLengthOfBurnIn() {
        if (this.values[0].length() < 250) {
            return this.values[0].length();
        }
        int m = this.values.length;
        DoubleList meanOfchains = new DoubleList(m);
        for (int it = 250; it < this.values[0].length(); it += 2) {
            int n = it / 2;
            int start = it - n;
            meanOfchains.clear();
            for (int i = 0; i < m; ++i) {
                meanOfchains.add(this.values[i].mean(start, it));
            }
            double meanOfChainMeans = meanOfchains.mean(0, meanOfchains.length());
            double b = 0.0;
            for (int i = 0; i < m; ++i) {
                b += (meanOfchains.get(i) - meanOfChainMeans) * (meanOfchains.get(i) - meanOfChainMeans);
            }
            b /= (double)m - 1.0;
            double w = 0.0;
            for (int i = 0; i < m; ++i) {
                for (int j = start; j < it; ++j) {
                    w += (this.values[i].get(j) - meanOfchains.get(i)) * (this.values[i].get(j) - meanOfchains.get(i));
                }
            }
            double sigma = (1.0 - 1.0 / (double)n) * (w /= (double)m * ((double)n - 1.0));
            double r = Math.sqrt((sigma += (1.0 + 1.0 / (double)m) * b) / w);
            if (!(r < this.threshold)) continue;
            return it;
        }
        return this.values[0].length();
    }
}

