/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.MultiSelectionCollectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;

public class CollectionParameter
extends Parameter
implements Rangeable {
    protected ParameterSet parameters;
    private int selected;
    private int defaultSelected;
    protected boolean userSelected;
    private String name;
    private String comment;
    private boolean required;
    private DataType datatype;
    protected String errorMessage;
    private boolean rangeable;

    public CollectionParameter clone() throws CloneNotSupportedException {
        CollectionParameter clone = (CollectionParameter)super.clone();
        clone.parameters = this.parameters == null ? null : this.parameters.clone();
        return clone;
    }

    private CollectionParameter(DataType datatype, String name, String comment, boolean required) {
        this.datatype = datatype;
        this.comment = comment;
        this.name = name;
        this.required = required;
        this.userSelected = false;
        this.rangeable = true;
        this.defaultSelected = -1;
        this.selected = 0;
    }

    protected CollectionParameter(ParameterSet options, int selected, int defaultSelected, boolean userSelected, String name, String comment, boolean required, DataType datatype, String errorMessage, boolean rangeable) {
        this.parameters = options;
        this.selected = selected;
        this.defaultSelected = defaultSelected;
        this.userSelected = userSelected;
        this.name = name;
        this.comment = comment;
        this.required = required;
        this.datatype = datatype;
        this.errorMessage = errorMessage;
        this.rangeable = rangeable;
        this.defaultSelected = -1;
    }

    public CollectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, keys, values, null, name, comment, required);
    }

    public CollectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, name, comment, required);
        if (keys.length != values.length || comments != null && keys.length != comments.length) {
            throw new InconsistentCollectionException("You have to define the same number of keys and values for a CollectionParameter!");
        }
        this.createParameterSet(values, keys, comments);
    }

    public CollectionParameter(ParameterSet[] values, String[] keys, String[] comments, String name, String comment, boolean required) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, keys, comments);
        }
        catch (Exception doesnothappen) {
            doesnothappen.printStackTrace();
        }
    }

    public CollectionParameter(InstanceParameterSet[] values, String name, String comment, boolean required) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, null, null);
        }
        catch (Exception doesnothappen) {
            // empty catch block
        }
    }

    protected void createParameterSet(Object[] values, String[] keys, String[] comments) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException {
        Parameter[] pars = new Parameter[values.length];
        for (int i = 0; i < pars.length; ++i) {
            String c;
            if (values[i] instanceof InstanceParameterSet) {
                InstanceParameterSet p = (InstanceParameterSet)values[i];
                String k = keys == null || keys[i] == null ? p.getInstanceName() : keys[i];
                c = comments == null ? p.getInstanceComment() : comments[i];
                pars[i] = new ParameterSetContainer(k, c, p);
                continue;
            }
            if (keys == null || keys[i] == null) {
                throw new IllegalArgumentException("You have to state the key for entity " + i);
            }
            c = comments != null ? comments[i] : "";
            if (values[i] instanceof ParameterSet) {
                pars[i] = new ParameterSetContainer(keys[i], c, (ParameterSet)values[i]);
                continue;
            }
            pars[i] = new SimpleParameter(this.datatype, keys[i], c, false);
            pars[i].setValue(values[i]);
        }
        this.parameters = new SimpleParameterSet(pars);
    }

    public boolean isAtomic() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!(this.parameters.getParameterAt(i).getValue() instanceof ParameterSet)) continue;
            return false;
        }
        return true;
    }

    public boolean hasDefault() {
        return this.defaultSelected > -1;
    }

    public boolean hasDefaultOrIsSet() {
        if (this.getValue() instanceof ParameterSet) {
            if (!((ParameterSet)this.getValue()).hasDefaultOrIsSet()) {
                if (((ParameterSet)this.getValue()).getErrorMessage() != null) {
                    this.errorMessage = "Selected value has the following error: " + ((ParameterSet)this.getValue()).getErrorMessage();
                }
                return false;
            }
            return true;
        }
        return this.isSet() || this.selected == this.defaultSelected;
    }

    public boolean isSet() {
        return this.isUserSelected();
    }

    public CollectionParameter(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public ParameterSet getParametersInCollection() {
        return this.parameters;
    }

    public void setRangeable(boolean rangeable) {
        this.rangeable = rangeable;
    }

    public boolean isRangeable() {
        return this.rangeable;
    }

    public boolean checkValue(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            this.errorMessage = "The value is not in the set of defined values (and not even a String)." + value;
            return false;
        }
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(value)) continue;
            this.errorMessage = null;
            return true;
        }
        this.errorMessage = "The value is not in the set of defined values: " + value + ".";
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendEnumWithTags(buf, this.datatype, "datatype");
        XMLParser.appendStringWithTags(buf, this.name, "name");
        XMLParser.appendStringWithTags(buf, this.comment, "comment");
        XMLParser.appendBooleanWithTags(buf, this.required, "required");
        XMLParser.appendBooleanWithTags(buf, this.userSelected, "userSelected");
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendIntWithTags(buf, this.selected, "selected");
        XMLParser.appendIntWithTags(buf, this.defaultSelected, "defaultSelected");
        XMLParser.appendBooleanWithTags(buf, this.rangeable, "rangeable");
        this.appendCollection(buf);
        XMLParser.addTags(buf, "collectionParameter");
        return buf;
    }

    protected void appendCollection(StringBuffer buf) {
        XMLParser.appendStringWithTags(buf, this.parameters.toXML().toString(), "collection");
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "collectionParameter");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.datatype = (DataType)((Object)XMLParser.extractEnumForTag(representation, "datatype"));
        this.name = XMLParser.extractStringForTag(representation, "name");
        this.comment = XMLParser.extractStringForTag(representation, "comment");
        this.required = XMLParser.extractBooleanForTag(representation, "required");
        this.userSelected = XMLParser.extractBooleanForTag(representation, "userSelected");
        this.errorMessage = XMLParser.extractStringForTag(representation, "errorMessage");
        if (this.errorMessage != null && this.errorMessage.equals("null")) {
            this.errorMessage = null;
        }
        this.selected = XMLParser.extractIntForTag(representation, "selected");
        this.defaultSelected = XMLParser.extractIntForTag(representation, "defaultSelected");
        StringBuffer help = XMLParser.extractForTag(representation, "rangeable");
        this.rangeable = help == null ? false : Boolean.parseBoolean(help.toString());
        this.extractCollection(representation);
    }

    protected void extractCollection(StringBuffer buf) throws NonParsableException {
        this.parameters = new SimpleParameterSet(XMLParser.extractForTag(buf, "collection"));
    }

    public String getName() {
        return this.name;
    }

    public DataType getDatatype() {
        return this.datatype;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getSelected() {
        return this.selected;
    }

    protected int getDefault() {
        return this.defaultSelected;
    }

    public boolean isUserSelected() {
        return this.userSelected;
    }

    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (value == null) {
            return;
        }
        if (this.checkValue(value)) {
            for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
                if (!this.parameters.getParameterAt(i).getName().equals(value)) continue;
                this.selected = i;
                this.userSelected = true;
                break;
            }
        } else {
            throw new SimpleParameter.IllegalValueException("Value not in Collection!");
        }
    }

    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        this.setValue(defaultValue);
        this.defaultSelected = this.selected;
        this.userSelected = false;
    }

    public void simplify() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (i != this.selected && this.parameters.getParameterAt(i).getValue() instanceof ParameterSet) {
                this.parameters.getParameterAt(i).reset();
                continue;
            }
            this.parameters.getParameterAt(i).simplify();
        }
    }

    public void reset() {
        this.selected = this.defaultSelected;
        this.simplify();
    }

    public Object getValue() {
        if (this.selected < this.parameters.getNumberOfParameters()) {
            return this.parameters.getParameterAt(this.selected).getValue();
        }
        return null;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof CollectionParameter) {
            ParameterSet parSet2 = ((CollectionParameter)o2).getParametersInCollection();
            if (parSet2.getNumberOfParameters() != this.parameters.getNumberOfParameters()) {
                return false;
            }
            if (!((CollectionParameter)o2).getName().equals(this.name) || !((CollectionParameter)o2).getComment().equals(this.comment)) {
                return false;
            }
            for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
                if (this.parameters.getParameterAt(i).equals(parSet2.getParameterAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Parameter getRangedInstance() throws Exception {
        boolean[] selected = new boolean[this.parameters.getNumberOfParameters()];
        selected[0] = true;
        MultiSelectionCollectionParameter par = new MultiSelectionCollectionParameter(this.parameters.clone(), selected, new boolean[this.parameters.getNumberOfParameters()], false, this.getName(), this.getComment(), this.required, this.datatype, this.errorMessage, 0, true);
        return par;
    }

    public String toString() {
        String s = this.parameters.getParameterAt(0).getName();
        for (int i = 1; i < this.parameters.getNumberOfParameters(); ++i) {
            s = s + ", " + this.parameters.getParameterAt(i).getName();
        }
        return this.name + " (" + this.comment + ", range={" + s + "}" + (this.required ? "" : ", OPTIONAL") + ")\t= " + this.getValue();
    }

    public class InconsistentCollectionException
    extends ParameterException {
        private static final long serialVersionUID = -2703514434545861722L;

        public InconsistentCollectionException(String message) {
            super(message);
        }
    }
}

