/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatedSubSamplingAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public RepeatedSubSamplingAssessParameterSet() throws UnsupportedOperationException {
    }

    protected RepeatedSubSamplingAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public RepeatedSubSamplingAssessParameterSet(int elementLength, boolean exceptionIfMPNotComputable, int repeats, int[] trainNumbers, int[] testNumbers) throws SimpleParameter.IllegalValueException {
        super(elementLength, exceptionIfMPNotComputable);
        ((Parameter)this.parameters.get(2)).setValue(new Integer(repeats));
        ParameterSet[] tempPSA = new ParameterSet[trainNumbers.length];
        int i = 0;
        while (i < tempPSA.length) {
            tempPSA[i] = this.getParameterSetContainingASingleIntValue(trainNumbers[i++], "training");
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get(3)).getValue()).replaceContentWith(tempPSA);
        ParameterSet[] tempPSA2 = new ParameterSet[testNumbers.length];
        int i2 = 0;
        while (i2 < tempPSA2.length) {
            tempPSA2[i2] = this.getParameterSetContainingASingleIntValue(testNumbers[i2++], "testing");
        }
        ((ExpandableParameterSet)((ParameterSetContainer)this.parameters.get(4)).getValue()).replaceContentWith(tempPSA2);
    }

    private ParameterSet getParameterSetContainingASingleIntValue(int num, final String train_test) throws SimpleParameter.IllegalValueException {
        ParameterSet ret = new ParameterSet(){

            protected void loadParameters() throws Exception {
                this.initParameterList(1);
                this.parameters.add(new SimpleParameter(DataType.INT, "number", "Defines a number of elements of data used as " + train_test + " items (class-specific) during a SubSamplingAssessment", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
            }
        };
        ret.getParameterAt(0).setValue(new Integer(num));
        return ret;
    }

    @Override
    protected void initializeMyParametersArrayList() {
        this.initParameterList(6);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.INT, "repeats", "Determines how often the procedure of train/test classifers with random created train- and test-data should be repeated.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
        this.parameters.add(new ParameterSetContainer("trainDataNumbers", "A RepeatedSubSamplingExperiment subsamples the used train- and test-datasets from the given data (for each class) in each iteration. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the number of the items (for each class), that should be subsampled and used as training-data.", new ExpandableParameterSet(this.getParameterSetContainingASingleIntValue(1, "training"), "number", "At pos i in this Expandable ParameterSet defines the number of subsampled items, that should be used as train-data for class i in a RepeatedSubSamplingExperiment.")));
        this.parameters.add(new ParameterSetContainer("testDataNumbers", "A RepeatedSubSamplingExperiment subsamples the used train and test datasets from the given data (for each class) in each iteration. This ParameterSetcontainer contains an ExpandableParameterSet that contains for each class the number of the items (for each class), that should be subsampled and used as test-data.", new ExpandableParameterSet(this.getParameterSetContainingASingleIntValue(1, "testing"), "number", "At pos i in this Expandable ParameterSet defines the number of subsampled items, that should be used as test-data for class i in a RepeatedSubSamplingExperiment.")));
    }

    public int getRepeats() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public int[] getTrain_TestNumbers(boolean train_case) {
        int pos = train_case ? 3 : 4;
        ExpandableParameterSet tempEPS = (ExpandableParameterSet)this.getParameterAt(pos).getValue();
        int[] ret = new int[tempEPS.getNumberOfParameters()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)((ParameterSet)tempEPS.getParameterAt(i).getValue()).getParameterAt(0).getValue();
        }
        return ret;
    }

    @Override
    public Collection<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(3);
        l.add(new NumericalResult("repeats", "The number of iterations", this.getRepeats()));
        l.add(new CategoricalResult("number of elements for train", "The number of the items (for each class), that was subsampled and used as training-data.", Arrays.toString(this.getTrain_TestNumbers(true))));
        l.add(new CategoricalResult("number of elements for assessment", "The number of the items (for each class), that should be subsampled and used as assessment-data.", Arrays.toString(this.getTrain_TestNumbers(false))));
        return l;
    }
}

