/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.cll;

import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifier;
import de.jstacs.classifier.scoringFunctionBased.cll.CLLClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.cll.NormConditionalLogLikelihood;
import de.jstacs.classifier.scoringFunctionBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.ScoringFunction;

public class CLLClassifier
extends ScoreClassifier {
    protected LogPrior prior;
    private static final String XML_TAG = "cll-classifier";

    public CLLClassifier(CLLClassifierParameterSet params, ScoringFunction ... score) throws CloneNotSupportedException {
        this(params, (LogPrior)null, score);
    }

    public CLLClassifier(CLLClassifierParameterSet params, LogPrior prior, ScoringFunction ... score) throws CloneNotSupportedException {
        this(params, prior, Double.NaN, score);
    }

    public CLLClassifier(CLLClassifierParameterSet params, LogPrior prior, double lastScore, ScoringFunction ... score) throws CloneNotSupportedException {
        super(params, lastScore, score);
        this.setPrior(prior);
    }

    public CLLClassifier clone() throws CloneNotSupportedException {
        CLLClassifier clone = (CLLClassifier)super.clone();
        clone.prior = this.prior.getNewInstance();
        return clone;
    }

    public CLLClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected NormConditionalLogLikelihood getFunction(Sample[] data, double[][] weights) throws Exception {
        CLLClassifierParameterSet p = (CLLClassifierParameterSet)this.params;
        return new NormConditionalLogLikelihood(this.score, data, weights, this.prior, p.shouldBeNormalized(), p.useOnlyFreeParameter());
    }

    public void setPrior(LogPrior prior) {
        this.prior = prior != null ? prior : DoesNothingLogPrior.defaultInstance;
        this.hasBeenOptimized = false;
    }

    protected String getXMLTag() {
        return XML_TAG;
    }

    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        if (!(this.prior instanceof DoesNothingLogPrior)) {
            StringBuffer pr = new StringBuffer(1000);
            pr.append("<prior>\n");
            XMLParser.appendStringWithTags(pr, this.prior.getClass().getName(), "className");
            pr.append(this.prior.toXML());
            pr.append("\t</prior>\n");
            xml.append(pr);
        }
        return xml;
    }

    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        StringBuffer pr = XMLParser.extractForTag(xml, "prior");
        if (pr != null) {
            String className = XMLParser.extractStringForTag(pr, "className");
            try {
                this.prior = (LogPrior)Class.forName(className).getConstructor(StringBuffer.class).newInstance(pr);
            }
            catch (NoSuchMethodException e) {
                NonParsableException n = new NonParsableException("You must provide a constructor " + className + "(StringBuffer).");
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
            catch (Exception e) {
                NonParsableException n = new NonParsableException("problem at " + className + ": " + e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.prior = DoesNothingLogPrior.defaultInstance;
        }
        try {
            this.prior.set(((CLLClassifierParameterSet)this.params).useOnlyFreeParameter(), this.score);
        }
        catch (Exception e) {
            NonParsableException n = new NonParsableException("problem when setting the kind of parameter: " + e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public static CLLClassifier[] create(CLLClassifierParameterSet params, LogPrior prior, ScoringFunction[] ... functions) throws CloneNotSupportedException {
        int anz = 1;
        int[] current = new int[functions.length];
        int[] max = new int[functions.length];
        ScoringFunction[] sf = new ScoringFunction[functions.length];
        for (int counter1 = 0; counter1 < functions.length; ++counter1) {
            anz *= functions[counter1].length;
            max[counter1] = functions[counter1].length - 1;
        }
        CLLClassifier[] erg = new CLLClassifier[anz];
        anz = sf.length - 1;
        for (int counter1 = 0; counter1 < erg.length; ++counter1) {
            int counter2;
            for (counter2 = 0; counter2 < sf.length; ++counter2) {
                sf[counter2] = functions[counter2][current[counter2]];
            }
            erg[counter1] = new CLLClassifier(params, prior, sf);
            counter2 = 0;
            while (counter2 < anz && current[counter2] == max[counter2]) {
                current[counter2++] = 0;
            }
            int n = counter2;
            current[n] = current[n] + 1;
        }
        return erg;
    }

    public String getInstanceName() {
        return super.getInstanceName() + (this.prior == null || this.prior == DoesNothingLogPrior.defaultInstance ? "" : " with " + this.prior.getInstanceName());
    }
}

