/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.mix.motifSearch.PositionScoringFunction;

public abstract class DurationScoringFunction
extends PositionScoringFunction {
    protected double ess;
    protected int min;
    protected int max;
    protected int delta;
    private static final String XML_TAG = "DurationScoringFunction";

    protected DurationScoringFunction(int min, int max, double ess) {
        super(min, max);
        this.setMinMax(min, max);
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.reset();
    }

    private void setMinMax(int min, int max) {
        this.min = min;
        if (min < 0) {
            throw new IllegalArgumentException("The given minimum is below 0.");
        }
        this.max = max;
        this.delta = max - min;
    }

    protected DurationScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
        this.reset();
    }

    public StringBuffer toXML() {
        StringBuffer b = super.toXML();
        XMLParser.appendIntWithTags(b, this.max, "max");
        XMLParser.appendIntWithTags(b, this.min, "min");
        XMLParser.appendDoubleWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, XML_TAG);
        return b;
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, XML_TAG);
        super.fromXML(b);
        this.setMinMax(XMLParser.extractIntForTag(b, "min"), XMLParser.extractIntForTag(b, "max"));
        this.ess = XMLParser.extractDoubleForTag(b, "ess");
    }

    public void reset() {
        this.internal[0] = this.min;
    }

    public boolean next() {
        this.internal[0] = this.internal[0] + 1;
        return this.internal[0] <= this.max;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        throw new RuntimeException("???");
    }

    public final double getEss() {
        return this.ess;
    }

    public boolean isPossible(int ... positions) {
        return positions != null && positions.length == 1 && positions[0] >= this.min && positions[0] <= this.max;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public int getNumberOfPossibilities() {
        return this.max - this.min + 1;
    }

    public abstract void initializeUniformly();

    public abstract void adjust(int[] var1, double[] var2);

    public void modify(int delta) {
        if (delta != 0) {
            this.setMinMax(this.min, this.max + delta);
            this.alphabets = new AlphabetContainer(new DiscreteAlphabet(this.min, this.max));
        }
    }

    public final double getNormalizationConstant() {
        return 1.0;
    }

    public final double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        return 0.0;
    }

    protected abstract String getRNotation(String var1);

    public String toString() {
        return this.getRNotation("p");
    }
}

