/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class SubstringFilenameFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter,
FilenameFilter {
    private PartOfName type;
    private String desc;
    private String[] substring;
    private boolean dir;
    private boolean ignoreCase;

    public SubstringFilenameFilter(PartOfName type, String desc, boolean dir, boolean ignoreCase, String ... substring) {
        this.type = type;
        this.desc = desc;
        this.dir = dir;
        this.ignoreCase = ignoreCase;
        this.substring = new String[substring.length];
        for (int i = 0; i < substring.length; ++i) {
            this.substring[i] = ignoreCase ? substring[i].toLowerCase() : substring[i];
        }
    }

    public boolean accept(File arg0) {
        if (this.dir && arg0.isDirectory()) {
            return true;
        }
        return this.accept(arg0.getParentFile(), arg0.getName());
    }

    public boolean accept(File dir, String name) {
        int i = 0;
        if (this.ignoreCase) {
            name = name.toLowerCase();
        }
        switch (this.type) {
            case PREFIX: {
                while (i < this.substring.length && !name.startsWith(this.substring[i])) {
                    ++i;
                }
                break;
            }
            case INFIX: {
                while (i < this.substring.length && !name.contains(this.substring[i])) {
                    ++i;
                }
                break;
            }
            case SUFFIX: {
                while (i < this.substring.length && !name.endsWith(this.substring[i])) {
                    ++i;
                }
                break;
            }
        }
        return i < this.substring.length;
    }

    public String getDescription() {
        return this.desc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartOfName {
        PREFIX,
        INFIX,
        SUFFIX;

    }
}

