/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.ConstraintManager;
import de.jstacs.models.discrete.inhomogeneous.MEMConstraint;
import de.jstacs.models.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.ArrayList;
import java.util.Arrays;

public final class MRFScoringFunction
extends AbstractNormalizableScoringFunction {
    private MEMConstraint[] constr;
    private String name;
    private boolean freeParams;
    private int[] offset;
    private int[] help;
    private double ess;
    private double norm;
    private double[][] partNorm;
    private SequenceIterator seqIt;
    private static final String XML_TAG = "MRFScoringFunction";

    public MRFScoringFunction(AlphabetContainer alphabets, int length, String constr) {
        this(alphabets, length, 0.0, constr);
    }

    public MRFScoringFunction(AlphabetContainer alphabets, int length, double ess, String constr) {
        super(alphabets, length);
        if (!alphabets.isDiscrete()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be discrete.");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("The ess has to be non-negative.");
        }
        this.ess = ess;
        int[] aLength = new int[length];
        int i = 0;
        while (i < length) {
            aLength[i] = (int)alphabets.getAlphabetLengthAt(i++);
        }
        ArrayList<int[]> list = ConstraintManager.extract(length, constr);
        ConstraintManager.reduce(list);
        this.constr = ConstraintManager.createConstraints(list, aLength);
        this.name = constr;
        this.freeParams = false;
        this.getNumberOfParameters();
        this.init(-1.0);
    }

    public MRFScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void init(double n) {
        this.norm = n;
        if (this.partNorm == null) {
            this.partNorm = new double[this.constr.length][];
            for (int i = 0; i < this.partNorm.length; ++i) {
                this.partNorm[i] = new double[this.constr[i].getNumberOfSpecificConstraints()];
            }
            this.help = new int[2];
            int[] aLength = new int[this.length];
            int i = 0;
            while (i < this.length) {
                aLength[i] = (int)this.alphabets.getAlphabetLengthAt(i++);
            }
            this.seqIt = new SequenceIterator(this.length);
            this.seqIt.setBounds(aLength);
        } else {
            for (int i = 0; i < this.partNorm.length; ++i) {
                Arrays.fill(this.partNorm[i], 0.0);
            }
        }
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "alphabets");
        this.ess = XMLParser.extractDoubleForTag(xml, "ess");
        this.name = XMLParser.extractStringForTag(xml, "name");
        this.constr = ArrayHandler.cast(MEMConstraint.class, XMLParser.extractStorableArrayForTag(xml, "constr"));
        this.freeParams = XMLParser.extractBooleanForTag(xml, "freeParams");
        this.getNumberOfParameters();
        this.init(-1.0);
    }

    public MRFScoringFunction clone() throws CloneNotSupportedException {
        MRFScoringFunction clone = (MRFScoringFunction)super.clone();
        clone.constr = (MEMConstraint[])ArrayHandler.clone((Cloneable[])this.constr);
        clone.init(-1.0);
        if (this.norm > 0.0) {
            clone.norm = this.norm;
            for (int i = 0; i < this.partNorm.length; ++i) {
                System.arraycopy(this.partNorm[i], 0, clone.partNorm[i], 0, this.partNorm[i].length);
            }
        }
        clone.help = (int[])this.help.clone();
        clone.getNumberOfParameters();
        return clone;
    }

    public double getLogScore(Sequence seq, int start) {
        double erg = 0.0;
        for (int i = 0; i < this.constr.length; ++i) {
            erg += this.constr[i].getLambda(this.constr[i].satisfiesSpecificConstraint(seq, start));
        }
        return erg;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double erg = 0.0;
        for (int i = 0; i < this.constr.length; ++i) {
            int j = this.constr[i].satisfiesSpecificConstraint(seq, start);
            int z = this.offset[i] + j;
            if (z < this.offset[i + 1]) {
                indices.add(z);
                partialDer.add(1.0);
            }
            erg += this.constr[i].getLambda(j);
        }
        return erg;
    }

    public int getNumberOfParameters() {
        if (this.offset == null) {
            int i = 0;
            int anz = 0;
            this.offset = new int[this.constr.length + 1];
            while (i < this.constr.length) {
                anz += this.constr[i++].getNumberOfSpecificConstraints();
                if (this.freeParams) {
                    // empty if block
                }
                this.offset[i] = --anz;
            }
        }
        return this.offset[this.constr.length];
    }

    public String getInstanceName() {
        return this.name;
    }

    public void setParameters(double[] params, int start) {
        this.norm = -1.0;
        int s = 0;
        for (int i = 0; i < this.constr.length; ++i) {
            this.constr[i].setLambda(this.constr[i].getNumberOfSpecificConstraints() - 1, 0.0);
            int j = 0;
            while (s < this.offset[i + 1]) {
                this.constr[i].setLambda(j, params[start + s]);
                ++s;
                ++j;
            }
        }
    }

    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(10000);
        XMLParser.appendIntWithTags(b, this.length, "length");
        XMLParser.appendStorableWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendDoubleWithTags(b, this.ess, "ess");
        XMLParser.appendStringWithTags(b, this.name, "name");
        XMLParser.appendStorableArrayWithTags(b, this.constr, "constr");
        XMLParser.appendBooleanWithTags(b, this.freeParams, "freeParams");
        XMLParser.addTags(b, XML_TAG);
        return b;
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        if (this.freeParams != freeParams) {
            this.offset = null;
            this.freeParams = freeParams;
            this.getNumberOfParameters();
        }
        double d = 0.0;
        for (int i = 0; i < this.length; ++i) {
            d -= Math.log(this.alphabets.getAlphabetLengthAt(i));
        }
        d /= (double)this.constr.length;
        for (int i = 0; i < this.constr.length; ++i) {
            int k = this.constr[i].getNumberOfSpecificConstraints();
            for (int j = 0; j < k; ++j) {
                this.constr[i].setLambda(j, d);
            }
        }
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        if (this.freeParams != freeParams) {
            this.offset = null;
            this.freeParams = freeParams;
            this.getNumberOfParameters();
        }
        for (int i = 0; i < this.constr.length; ++i) {
            int k = this.constr[i].getNumberOfSpecificConstraints();
            for (int j = 0; j < k; ++j) {
                this.constr[i].setLambda(j, r.nextDouble());
            }
        }
    }

    public double getNormalizationConstant() {
        if (this.norm < 0.0) {
            this.precompute();
        }
        return this.norm;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        if (this.norm < 0.0) {
            this.precompute();
        }
        this.computeIndices(parameterIndex);
        return this.partNorm[this.help[0]][this.help[1]];
    }

    private void precompute() {
        this.init(0.0);
        this.seqIt.reset();
        int i = 0;
        int[] fulfilled = new int[this.constr.length];
        this.seqIt.reset();
        do {
            double s = this.getScore(fulfilled, this.seqIt);
            for (i = 0; i < this.constr.length; ++i) {
                double[] dArray = this.partNorm[i];
                int n = fulfilled[i];
                dArray[n] = dArray[n] + s;
            }
            this.norm += s;
        } while (this.seqIt.next());
    }

    private double getScore(int[] fulfilled, SequenceIterator sequence) {
        double s = 1.0;
        for (int counter = 0; counter < this.constr.length; ++counter) {
            fulfilled[counter] = this.constr[counter].satisfiesSpecificConstraint(sequence);
            s *= this.constr[counter].getExpLambda(fulfilled[counter]);
        }
        return s;
    }

    public double getEss() {
        return this.ess;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        this.computeIndices(index);
        return this.constr[this.help[0]].getNumberOfSpecificConstraints();
    }

    private void computeIndices(int index) {
        this.help[0] = 0;
        while (index >= this.offset[this.help[0]]) {
            this.help[0] = this.help[0] + 1;
        }
        this.help[0] = this.help[0] - 1;
        this.help[1] = index - this.offset[this.help[0]];
    }

    public double getLogPriorTerm() {
        double logPriorTerm = 0.0;
        int s = 0;
        for (int i = 0; i < this.constr.length; ++i) {
            double d = this.ess / (double)this.constr[i].getNumberOfSpecificConstraints();
            int j = 0;
            while (s < this.offset[i + 1]) {
                logPriorTerm += this.constr[i].getLambda(j) * d;
                ++s;
                ++j;
            }
        }
        return logPriorTerm;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) {
        int s = 0;
        for (int i = 0; i < this.constr.length; ++i) {
            double d = this.ess / (double)this.constr[i].getNumberOfSpecificConstraints();
            int j = 0;
            while (s < this.offset[i + 1]) {
                int n = start + s;
                grad[n] = grad[n] + d;
                ++s;
                ++j;
            }
        }
    }

    public double[] getCurrentParameterValues() throws Exception {
        double[] start = new double[this.offset[this.constr.length]];
        int n = 0;
        for (int i = 0; i < this.constr.length; ++i) {
            int k = this.constr[i].getNumberOfSpecificConstraints();
            int j = 0;
            while (j < k) {
                start[n] = this.constr[i].getLambda(j);
                ++j;
                ++n;
            }
        }
        return start;
    }

    public boolean isInitialized() {
        return true;
    }
}

