/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.gendismix;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifier;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class GenDisMixClassifierParameterSet
extends ScoreClassifierParameterSet {
    public GenDisMixClassifierParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
        if (this.parameters != null && this.parameters.size() == 7) {
            this.parameters.add(GenDisMixClassifierParameterSet.getThreadsParameter());
        }
    }

    public GenDisMixClassifierParameterSet(AlphabetContainer alphabet, int length, byte algo, double eps, double lineps, double startD, boolean free, OptimizableFunction.KindOfParameter kind, boolean norm, int threads) throws Exception {
        this(GenDisMixClassifier.class, alphabet, length, algo, eps, lineps, startD, free, kind, norm, threads);
    }

    protected GenDisMixClassifierParameterSet(Class<? extends ScoreClassifier> instanceClass, AlphabetContainer alphabet, int length, byte algo, double eps, double lineps, double startD, boolean free, OptimizableFunction.KindOfParameter kind, boolean norm, int threads) throws Exception {
        super(instanceClass, alphabet, length, algo, eps, lineps, startD, free, kind);
        ((Parameter)this.parameters.get(6)).setValue(norm);
        this.setNumberOfThreads(threads);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.BOOLEAN, "Normalize", "If true the conditional likelihood will be normalized to the number of samples.", true, new Boolean(true)));
        this.parameters.add(GenDisMixClassifierParameterSet.getThreadsParameter());
    }

    private static Parameter getThreadsParameter() {
        try {
            return new SimpleParameter(DataType.INT, "Threads", "The number of threads that is used during an optimization.", true, new NumberValidator<Integer>(1, 128), 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean shouldBeNormalized() {
        return (Boolean)this.getParameterAt(6).getValue();
    }

    public int getNumberOfThreads() {
        return (Integer)this.getParameterAt(7).getValue();
    }

    public void setNumberOfThreads(int threads) throws SimpleParameter.IllegalValueException {
        ((Parameter)this.parameters.get(7)).setValue(threads);
    }
}

