/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.ShortSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.NullSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SymbolExtractor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sample
implements Iterable<Sequence> {
    private String annotation;
    private AlphabetContainer alphabetContainer;
    private Sequence[] seqs;
    private int length;
    private int[] indexOfFirstSubseq;

    public static final String getAnnotation(Sample ... s) {
        if (s == null || s.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(s.length * 100);
        sb.append(s[0].getAnnotation());
        for (int i = 1; i < s.length; ++i) {
            sb.append(", ");
            sb.append(s[i].getAnnotation());
        }
        return "[" + sb.toString() + "]";
    }

    public static final Sample diff(Sample data, Sample ... samples) throws EmptySampleException, WrongAlphabetException {
        int[] occurrence;
        Sequence seq;
        int n;
        Hashtable<Sequence, int[]> hash = new Hashtable<Sequence, int[]>(data.getNumberOfElements() * 2);
        AlphabetContainer abc = data.getAlphabetContainer();
        int i = 0;
        int anz = data.getNumberOfElements();
        for (n = 0; n < anz; ++n) {
            seq = data.getElementAt(n);
            occurrence = (int[])hash.get(seq);
            if (occurrence != null) {
                occurrence[0] = occurrence[0] + 1;
                continue;
            }
            hash.put(seq, new int[]{1});
        }
        while (i < samples.length && hash.size() > 0) {
            if (!abc.checkConsistency(samples[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("The sample do not have the same AlphabetContainer.");
            }
            for (n = 0; n < samples[i].getNumberOfElements(); ++n) {
                seq = samples[i].getElementAt(n);
                occurrence = (int[])hash.get(seq);
                if (occurrence == null) continue;
                if (occurrence[0] == 1) {
                    hash.remove(seq);
                } else {
                    occurrence[0] = occurrence[0] - 1;
                }
                --anz;
            }
            ++i;
        }
        Sequence[] seqs = new Sequence[anz];
        Iterator it = hash.entrySet().iterator();
        anz = 0;
        while (it.hasNext()) {
            Map.Entry current = it.next();
            seq = (Sequence)current.getKey();
            occurrence = (int[])current.getValue();
            for (i = 0; i < occurrence[0]; ++i) {
                seqs[anz++] = seq;
            }
        }
        return new Sample("diff of " + data.getAnnotation() + " and " + Sample.getAnnotation(samples), seqs);
    }

    public static final Sample intersection(Sample ... samples) throws IllegalArgumentException, EmptySampleException {
        WeightedSampleFactory[] wsf = new WeightedSampleFactory[samples.length];
        int[] index = new int[samples.length];
        int i = 0;
        int len = -1;
        AlphabetContainer abc = samples[i].getAlphabetContainer();
        while (i < wsf.length) {
            if (!abc.checkConsistency(samples[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("The sample do not have the same AlphabetContainer.");
            }
            try {
                wsf[i] = new WeightedSampleFactory(WeightedSampleFactory.SortOperation.SORT_BY_SEQUENCE, samples[i++]);
            }
            catch (WrongAlphabetException doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
            catch (WrongLengthException doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
        }
        boolean goOn = true;
        ArrayList<Sequence> list = new ArrayList<Sequence>(100);
        do {
            String help;
            String current = wsf[0].getElementAt(index[0]).toString();
            for (i = 1; i < samples.length; ++i) {
                help = wsf[i].getElementAt(index[i]).toString();
                if (current.compareTo(help) >= 0) continue;
                current = help;
            }
            boolean same = true;
            for (i = 0; i < samples.length; ++i) {
                help = "";
                while (index[i] < wsf[i].getNumberOfElements() && current.compareTo(help = wsf[i].getElementAt(index[i]).toString()) > 0) {
                    int n = i;
                    index[n] = index[n] + 1;
                }
                same &= current.equals(help);
            }
            if (same) {
                double anz = wsf[0].getWeight(index[0]);
                i = 1;
                while (i < samples.length) {
                    if (anz > wsf[i].getWeight(index[i])) {
                        anz = wsf[i].getWeight(index[i]);
                    }
                    int n = i++;
                    index[n] = index[n] + 1;
                }
                if (list.size() == 0) {
                    len = wsf[0].getElementAt(index[0]).getLength();
                } else if (len != wsf[0].getElementAt(index[0]).getLength()) {
                    len = 0;
                }
                i = 0;
                while ((double)i < anz) {
                    list.add(wsf[0].getElementAt(index[0]));
                    ++i;
                }
                index[0] = index[0] + 1;
            }
            for (i = 0; i < samples.length; ++i) {
                if (index[i] != wsf[i].getNumberOfElements()) continue;
                goOn = false;
            }
        } while (goOn);
        return new Sample(abc, list.toArray(new Sequence[0]), len, "intersection of " + Sample.getAnnotation(samples));
    }

    public static final Sample union(Sample[] s, boolean[] in) throws IllegalArgumentException, EmptySampleException {
        try {
            return Sample.union(s, in, 0);
        }
        catch (WrongLengthException doesNotHappen) {
            IllegalArgumentException i = new IllegalArgumentException(doesNotHappen.getMessage());
            i.setStackTrace(doesNotHappen.getStackTrace());
            throw i;
        }
    }

    public static final Sample union(Sample ... s) throws IllegalArgumentException {
        if (s == null || s.length == 0) {
            return null;
        }
        boolean[] in = new boolean[s.length];
        Arrays.fill(in, true);
        try {
            return Sample.union(s, in);
        }
        catch (EmptySampleException doesNotHappen) {
            return null;
        }
    }

    public static final Sample union(Sample[] s, boolean[] in, int subsequenceLength) throws IllegalArgumentException, EmptySampleException, WrongLengthException {
        boolean subseq;
        int i;
        if (s == null || s.length == 0) {
            return null;
        }
        if (in.length != s.length) {
            throw new IllegalArgumentException("The arrays have to have the same dimension.");
        }
        int l = s.length;
        for (i = 0; i < l && !in[i]; ++i) {
        }
        if (i == l) {
            return null;
        }
        int start = i;
        int len = s[i].getMinimalElementLength();
        int anz = s[i].getNumberOfElements();
        String annot = "the union of [" + s[i].getAnnotation();
        boolean seq = s[i++].indexOfFirstSubseq == null;
        boolean bl = subseq = !seq;
        while (i < l && (!in[i] || s[start].alphabetContainer.checkConsistency(s[i].alphabetContainer))) {
            if (in[i]) {
                anz += s[i].getNumberOfElements();
                if (len != 0 && len != s[i].getMinimalElementLength()) {
                    len = 0;
                }
                seq &= s[i].indexOfFirstSubseq == null;
                subseq &= s[i].indexOfFirstSubseq != null;
                annot = annot + ", " + s[i].getAnnotation();
            }
            ++i;
        }
        if (i < l) {
            throw new IllegalArgumentException("The alphabets of the samples do not match.");
        }
        if (len < subsequenceLength) {
            throw new WrongLengthException(subsequenceLength);
        }
        Sequence[] seqs = new Sequence[anz];
        anz = 0;
        for (i = 0; i < l; ++i) {
            if (!in[i]) continue;
            ElementEnumerator ei = new ElementEnumerator(s[i]);
            while (ei.hasMoreElements()) {
                seqs[anz++] = ei.nextElement();
            }
        }
        Sample res = new Sample(s[start].alphabetContainer, seqs, len, annot + "]");
        res.setSubsequenceLength(subsequenceLength);
        return res;
    }

    public static final Sample union(Sample[] s, int subsequenceLength) throws IllegalArgumentException, WrongLengthException {
        if (s == null || s.length == 0) {
            return null;
        }
        boolean[] in = new boolean[s.length];
        Arrays.fill(in, true);
        try {
            return Sample.union(s, in, subsequenceLength);
        }
        catch (EmptySampleException doesNotHappen) {
            return null;
        }
    }

    private Sample(AlphabetContainer abc, Sequence[] seqs, int length, String annotation) throws EmptySampleException {
        if (seqs == null || seqs.length == 0) {
            throw new EmptySampleException();
        }
        this.alphabetContainer = abc;
        this.seqs = seqs;
        this.length = length;
        this.annotation = annotation;
    }

    public Sample(AlphabetContainer abc, AbstractStringExtractor se) throws WrongAlphabetException, EmptySampleException, WrongLengthException {
        this(abc, se, abc.getDelim(), 0);
    }

    public Sample(AlphabetContainer abc, AbstractStringExtractor se, int subsequenceLength) throws WrongAlphabetException, WrongLengthException, EmptySampleException {
        this(abc, se, abc.getDelim(), subsequenceLength);
    }

    public Sample(AlphabetContainer abc, AbstractStringExtractor se, String delim) throws WrongAlphabetException, EmptySampleException, WrongLengthException {
        this(abc, se, delim, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sample(AlphabetContainer abc, AbstractStringExtractor se, String delim, int subsequenceLength) throws EmptySampleException, WrongAlphabetException, WrongLengthException {
        this.alphabetContainer = abc;
        LinkedList<Sequence> newSeqs = new LinkedList<Sequence>();
        SymbolExtractor temp = new SymbolExtractor(delim);
        this.length = -1;
        try {
            if (this.alphabetContainer.isDiscrete()) {
                int l = (int)this.alphabetContainer.getMaximalAlphabetLength();
                if (l <= 127) {
                    while (se.hasMoreElements()) {
                        SequenceAnnotation[] annot = se.getCurrentSequenceAnnotations();
                        temp.setStringToBeParsed((String)se.nextElement());
                        if (this.length < 0) {
                            this.length = temp.countElements();
                        } else if (this.length > 0 && temp.countElements() != this.length) {
                            this.length = 0;
                        }
                        newSeqs.add(new ByteSequence(this.alphabetContainer, annot, temp));
                    }
                } else if (l <= Short.MAX_VALUE) {
                    while (se.hasMoreElements()) {
                        SequenceAnnotation[] annot = se.getCurrentSequenceAnnotations();
                        temp.setStringToBeParsed((String)se.nextElement());
                        if (this.length < 0) {
                            this.length = temp.countElements();
                        } else if (this.length > 0 && temp.countElements() != this.length) {
                            this.length = 0;
                        }
                        newSeqs.add(new ShortSequence(this.alphabetContainer, annot, temp));
                    }
                } else {
                    if (l > Integer.MAX_VALUE) throw new WrongAlphabetException("Could not encode. Too many symbols.");
                    while (se.hasMoreElements()) {
                        SequenceAnnotation[] annot = se.getCurrentSequenceAnnotations();
                        temp.setStringToBeParsed((String)se.nextElement());
                        if (this.length < 0) {
                            this.length = temp.countElements();
                        } else if (this.length > 0 && temp.countElements() != this.length) {
                            this.length = 0;
                        }
                        newSeqs.add(new IntSequence(this.alphabetContainer, annot, temp));
                    }
                }
            } else {
                if (delim.length() == 0) {
                    throw new IllegalArgumentException("delim has to be not empty");
                }
                while (se.hasMoreElements()) {
                    SequenceAnnotation[] annot = se.getCurrentSequenceAnnotations();
                    temp.setStringToBeParsed((String)se.nextElement());
                    if (this.length < 0) {
                        this.length = temp.countElements();
                    } else if (this.length > 0 && temp.countElements() != this.length) {
                        this.length = 0;
                    }
                    newSeqs.add(new ArbitrarySequence(this.alphabetContainer, annot, temp));
                }
            }
        }
        catch (WrongSequenceTypeException e) {
            RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
            doesNotHappen.setStackTrace(e.getStackTrace());
            throw doesNotHappen;
        }
        this.seqs = new Sequence[newSeqs.size()];
        if (this.seqs.length == 0) {
            throw new EmptySampleException();
        }
        newSeqs.toArray(this.seqs);
        this.setSubsequenceLength(subsequenceLength);
        this.annotation = subsequenceLength > 0 ? "all subsequences of length " + subsequenceLength + " from " + se.getAnnotation() : se.getAnnotation();
    }

    public Sample(Sample s, int subsequenceLength) throws WrongLengthException {
        this(s, subsequenceLength, false);
    }

    private Sample(Sample s, int subsequenceLength, boolean copy) throws WrongLengthException {
        if (copy) {
            this.alphabetContainer = s.alphabetContainer;
            this.seqs = s.getAllElements();
            this.setSubsequenceLength(subsequenceLength);
            this.seqs = this.getAllElements();
            this.indexOfFirstSubseq = null;
            this.length = subsequenceLength;
            this.annotation = "all subsequences of length " + subsequenceLength + " from " + s.annotation;
        } else {
            this.alphabetContainer = s.alphabetContainer;
            this.seqs = s.indexOfFirstSubseq == null ? s.seqs : s.getAllElements();
            this.length = s.length;
            this.setSubsequenceLength(subsequenceLength);
            this.annotation = "all subsequences of length " + subsequenceLength + " from " + s.annotation;
        }
    }

    public Sample(String annotation, Sequence ... seqs) throws EmptySampleException, WrongAlphabetException {
        if (seqs == null || seqs.length == 0) {
            throw new EmptySampleException();
        }
        this.alphabetContainer = seqs[0].getAlphabetContainer();
        this.seqs = new Sequence[seqs.length];
        int i = 1;
        this.length = seqs[0].getLength();
        this.seqs[0] = seqs[0];
        while (i < seqs.length) {
            this.seqs[i] = seqs[i];
            if (this.length != seqs[i].getLength()) {
                this.length = 0;
            }
            if (this.alphabetContainer.checkConsistency(seqs[i++].getAlphabetContainer())) continue;
            throw new WrongAlphabetException("The sequences are not defined over the same AlphabetContainer.");
        }
        this.indexOfFirstSubseq = null;
        this.annotation = annotation;
    }

    public Sequence[] getAllElements() {
        Sequence[] res = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        for (int i = 0; i < res.length; ++i) {
            res[i] = ei.nextElement();
        }
        return res;
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabetContainer;
    }

    public final String getAnnotation() {
        return this.annotation;
    }

    public final Sample getCompositeSample(int[] starts, int[] lengths) throws IllegalArgumentException {
        AlphabetContainer abc = this.alphabetContainer.getCompositeContainer(starts, lengths);
        Sequence[] n = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        int i = 0;
        int length = 0;
        while (i < n.length) {
            n[i++] = ei.nextElement().getCompositeSequence(abc, starts, lengths);
        }
        for (i = 0; i < lengths.length; ++i) {
            length += lengths[i];
        }
        try {
            return new Sample(abc, n, length, "composite sample (starts=" + Arrays.toString(starts) + ", lengths=" + Arrays.toString(lengths) + ") of " + this.annotation);
        }
        catch (EmptySampleException doesNotHappen) {
            return null;
        }
    }

    public Sequence getElementAt(int i) {
        if (this.indexOfFirstSubseq == null) {
            return this.seqs[i];
        }
        int seqInd = this.getIndexOfSeq(i);
        int startPos = i - (seqInd == 0 ? 0 : this.indexOfFirstSubseq[seqInd - 1]);
        if (this.length == 0) {
            return this.seqs[seqInd].getSubSequence(startPos);
        }
        return this.seqs[seqInd].getSubSequence(startPos, this.length);
    }

    public int getElementLength() {
        return this.length;
    }

    public final Sample getInfixSample(int start, int length) throws IllegalArgumentException {
        int i;
        if (length <= 0) {
            throw new IllegalArgumentException("The length has to be positive.");
        }
        int n = i = this.length == 0 ? this.getMinimalElementLength() : this.length;
        if (i >= start + length) {
            if (start == 0 && length == this.length) {
                return this;
            }
            AlphabetContainer abc = this.alphabetContainer.getSubContainer(start, length);
            Sequence[] n2 = new Sequence[this.getNumberOfElements()];
            ElementEnumerator ei = new ElementEnumerator(this);
            for (i = 0; i < n2.length; ++i) {
                n2[i] = ei.nextElement().getSubSequence(abc, start, length);
            }
            try {
                return new Sample(abc, n2, length, "infix sample (start=" + start + ", length=" + length + ") of " + this.annotation);
            }
            catch (EmptySampleException doesNotHappen) {
                return null;
            }
        }
        throw new IllegalArgumentException("The values for start and length or not suitable.");
    }

    public int getMinimalElementLength() {
        if (this.length != 0) {
            return this.length;
        }
        if (this.indexOfFirstSubseq != null) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        ElementEnumerator ei = new ElementEnumerator(this);
        while (ei.hasMoreElements() && min != 0) {
            int l = ei.nextElement().getLength();
            if (l >= min) continue;
            min = l;
        }
        return min;
    }

    public int getMaximalElementLength() {
        if (this.length != 0) {
            return this.length;
        }
        int max = Integer.MIN_VALUE;
        ElementEnumerator ei = new ElementEnumerator(this);
        while (ei.hasMoreElements()) {
            int l = ei.nextElement().getLength();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    public int getNumberOfElements() {
        if (this.indexOfFirstSubseq == null) {
            return this.seqs.length;
        }
        return this.indexOfFirstSubseq[this.seqs.length - 1];
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new ElementEnumerator(this);
    }

    public int getNumberOfElementsWithLength(int len) throws WrongLengthException {
        return (int)this.getNumberOfElementsWithLength(len, null);
    }

    public double getNumberOfElementsWithLength(int len, double[] weights) throws WrongLengthException, IllegalArgumentException {
        double w = 1.0;
        double all = 0.0;
        if (weights != null && weights.length != this.getNumberOfElements()) {
            throw new IllegalArgumentException("The weights array has the wrong dimension");
        }
        if (this.length == 0 || weights != null) {
            for (int i = 0; i < this.seqs.length; ++i) {
                int l = this.seqs[i].getLength();
                if (weights != null) {
                    w = weights[i];
                }
                if (l < len) {
                    throw new WrongLengthException(len);
                }
                all += w * (double)(l - len + 1);
            }
        } else {
            if (this.length < len) {
                throw new WrongLengthException(len);
            }
            all = (this.length - len + 1) * this.seqs.length;
        }
        return all;
    }

    public final Sample getSuffixSample(int start) throws IllegalArgumentException {
        int l = 0;
        if (this.length != 0) {
            l = this.length - start;
        }
        if (this.alphabetContainer.isSimple()) {
            AlphabetContainer alphabetContainer = this.alphabetContainer;
        }
        AlphabetContainer abc = this.alphabetContainer.getSubContainer(start, l);
        Sequence[] n = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        for (int i = 0; i < n.length; ++i) {
            n[i] = ei.nextElement().getSubSequence(abc, start);
        }
        try {
            return new Sample(abc, n, l, "suffix sample (start=" + start + ") of " + this.annotation);
        }
        catch (EmptySampleException doesNotHappen) {
            return null;
        }
    }

    public final boolean isSimpleSample() {
        return this.alphabetContainer.isSimple();
    }

    public final boolean isDiscreteSample() {
        return this.alphabetContainer.isDiscrete();
    }

    public Sample[] partition(double p, PartitionMethod method, int subsequenceLength) throws WrongLengthException, UnsupportedOperationException, EmptySampleException {
        if (!this.isSimpleSample() && this.length != subsequenceLength) {
            throw new UnsupportedOperationException("The is method can only be used for simple samples.");
        }
        Sample[] parts = this.partition(method, 1.0 - p, p);
        parts[1].setSubsequenceLength(subsequenceLength);
        return parts;
    }

    public Sample[] partition(PartitionMethod method, double ... percentage) throws IllegalArgumentException, EmptySampleException {
        long l;
        int i;
        if (percentage == null | percentage.length <= 1) {
            return new Sample[]{this};
        }
        double sum = 0.0;
        for (i = 0; i < percentage.length; ++i) {
            if (0.0 > percentage[i] || 1.0 < percentage[i]) {
                throw new IllegalArgumentException("The value of percentage[" + i + "] is not in [0,1].");
            }
            sum += percentage[i];
        }
        if (sum != 1.0) {
            throw new IllegalArgumentException("The sum of the percentages is not 1. (sum = " + sum + ")");
        }
        long[] anz = new long[percentage.length];
        switch (method) {
            case PARTITION_BY_NUMBER_OF_ELEMENTS: {
                l = this.getNumberOfElements();
                break;
            }
            case PARTITION_BY_NUMBER_OF_SYMBOLS: {
                l = 0L;
                ElementEnumerator ei = new ElementEnumerator(this);
                while (ei.hasMoreElements()) {
                    l += (long)ei.nextElement().getLength();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The partitioning criterion is unknown.");
            }
        }
        long sumAnz = 0L;
        for (i = 0; i < anz.length; ++i) {
            anz[i] = (long)Math.ceil((double)l * percentage[i]);
            sumAnz += anz[i];
        }
        i = anz.length - 1;
        while (sumAnz < l) {
            int n = i--;
            anz[n] = anz[n] + 1L;
            if (i >= 0) continue;
            i = anz.length - 1;
        }
        return this.partition(anz, method);
    }

    public Sample[] partition(int k, PartitionMethod method) throws IllegalArgumentException, EmptySampleException {
        long r;
        long l;
        if (k < 1) {
            throw new IllegalArgumentException("Can't partition in " + k + " parts.");
        }
        if (k == 1) {
            return new Sample[]{this};
        }
        long[] anz = new long[k];
        switch (method) {
            case PARTITION_BY_NUMBER_OF_ELEMENTS: {
                l = this.getNumberOfElements();
                r = l % (long)k;
                l /= (long)k;
                break;
            }
            case PARTITION_BY_NUMBER_OF_SYMBOLS: {
                long all = 0L;
                ElementEnumerator ei = new ElementEnumerator(this);
                while (ei.hasMoreElements()) {
                    all += (long)ei.nextElement().getLength();
                }
                l = all / (long)k;
                r = all % (long)k;
                break;
            }
            default: {
                throw new IllegalArgumentException("The partitioning criterion is unknown.");
            }
        }
        int i = k - 1;
        Arrays.fill(anz, l);
        while (r > 0L) {
            int n = i--;
            anz[n] = anz[n] + 1L;
            --r;
        }
        return this.partition(anz, method);
    }

    private Sample[] partition(long[] anz, PartitionMethod method) throws EmptySampleException {
        int[] pos = new int[this.getNumberOfElements()];
        int[] ends = new int[anz.length];
        int last = pos.length;
        int i = 0;
        for (i = 0; i < last; ++i) {
            pos[i] = i;
        }
        Random r = new Random();
        switch (method) {
            case PARTITION_BY_NUMBER_OF_ELEMENTS: {
                int help;
                int drawn;
                for (i = anz.length - 1; i > 0; --i) {
                    ends[i] = last;
                    int j = 0;
                    while ((long)j < anz[i]) {
                        drawn = r.nextInt(last);
                        help = pos[drawn];
                        pos[drawn] = pos[--last];
                        pos[last] = help;
                        ++j;
                    }
                }
                break;
            }
            case PARTITION_BY_NUMBER_OF_SYMBOLS: {
                int help;
                int drawn;
                for (i = anz.length - 1; i > 0; --i) {
                    ends[i] = last;
                    for (long l = 0L; l < anz[i]; l += (long)this.getElementAt(help).getLength()) {
                        drawn = r.nextInt(last);
                        help = pos[drawn];
                        pos[drawn] = pos[--last];
                        pos[last] = help;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The partitioning criterion is unknown.");
            }
        }
        ends[i] = last;
        Sequence[][] seqs = this.getPartitionsOfElements(pos, ends);
        Sample[] parts = new Sample[seqs.length];
        for (i = 0; i < anz.length; ++i) {
            parts[i] = new Sample(this.alphabetContainer, seqs[i], this.length, "partition of " + this.annotation);
        }
        return parts;
    }

    public Sample subSampling(int number) throws EmptySampleException {
        if (number <= 0) {
            throw new EmptySampleException();
        }
        Random r = new Random();
        Sequence[] subsampled_seqs = new Sequence[number];
        int numOfElements = this.getNumberOfElements();
        for (int i = 0; i < subsampled_seqs.length; ++i) {
            subsampled_seqs[i] = this.getElementAt(r.nextInt(numOfElements));
        }
        return new Sample(this.alphabetContainer, subsampled_seqs, this.length, "subsample of " + this.annotation);
    }

    public final void save(File f) throws IOException {
        this.save(new FileOutputStream(f), '>', null);
    }

    public final void save(OutputStream stream, char commentChar, SequenceAnnotationParser p) throws IOException {
        BufferedWriter b = new BufferedWriter(new OutputStreamWriter(stream));
        ElementEnumerator ei = new ElementEnumerator(this);
        if (p == null) {
            p = NullSequenceAnnotationParser.DEFAULT_INSTANCE;
        }
        while (ei.hasMoreElements()) {
            Sequence current = ei.nextElement();
            b.write(p.parseAnnotationToComment(commentChar, current.getAnnotation()));
            b.newLine();
            b.write(current.toString());
            if (!ei.hasMoreElements()) continue;
            b.newLine();
        }
        b.close();
    }

    public String toString() {
        ElementEnumerator ei = new ElementEnumerator(this);
        int l = this.getNumberOfElements();
        StringBuffer erg = new StringBuffer(l * Math.max(this.getElementLength(), 10));
        erg.append("annotation       : " + this.annotation + "\n\n");
        erg.append("AlphabetContainer:\n" + this.alphabetContainer + "\n");
        erg.append("element length   : " + this.getElementLength() + "\n");
        erg.append("# of elements    : " + l + "\n\nsequences:\n");
        Pattern cp = Pattern.compile("\n");
        Matcher m = cp.matcher(erg);
        String temp = m.replaceAll("\n# ");
        erg.delete(0, erg.length());
        erg.append("# ");
        erg.append(temp);
        erg.append("\n");
        while (ei.hasMoreElements()) {
            erg.append(ei.nextElement() + "\n");
        }
        return erg.toString();
    }

    private int getIndexOfSeq(int overAllIndex) throws IndexOutOfBoundsException {
        if (overAllIndex < 0 || overAllIndex > this.indexOfFirstSubseq[this.seqs.length - 1]) {
            throw new IndexOutOfBoundsException();
        }
        int lower = 0;
        int upper = this.seqs.length - 1;
        if (overAllIndex < this.indexOfFirstSubseq[lower]) {
            return 0;
        }
        do {
            int sep;
            if (overAllIndex < this.indexOfFirstSubseq[sep = (upper + lower) / 2]) {
                upper = sep;
                continue;
            }
            lower = sep;
        } while (upper - lower > 1);
        return lower + 1;
    }

    private Sequence[][] getPartitionsOfElements(int[] pos, int[] ends) {
        int i;
        int j = 0;
        int[] part = new int[pos.length];
        for (i = 0; i < pos.length; ++i) {
            if (i == ends[j]) {
                // empty if block
            }
            part[pos[i]] = ++j;
        }
        int[] index = new int[ends.length];
        ElementEnumerator ei = new ElementEnumerator(this);
        Sequence[][] seqs = new Sequence[ends.length][];
        j = 0;
        for (i = 0; i < seqs.length; ++i) {
            seqs[i] = new Sequence[ends[i] - j];
            j = ends[i];
        }
        i = 0;
        while (ei.hasMoreElements()) {
            int n = part[i];
            int n2 = index[n];
            index[n] = n2 + 1;
            seqs[part[i]][n2] = ei.nextElement();
            ++i;
        }
        return seqs;
    }

    private void setSubsequenceLength(int len) throws WrongLengthException {
        if (len < 0) {
            throw new WrongLengthException(len);
        }
        if (this.length != len) {
            if (len == 0) {
                return;
            }
            if (this.indexOfFirstSubseq != null) {
                throw new UnsupportedOperationException("operation not supported since indexOfFirstSubseq != null");
            }
            if (this.isSimpleSample()) {
                this.indexOfFirstSubseq = new int[this.seqs.length];
                if (this.length == 0) {
                    int i = 0;
                    int all = 0;
                    while (i < this.seqs.length) {
                        int l = this.seqs[i].getLength();
                        if (l < len) {
                            throw new WrongLengthException(len);
                        }
                        this.indexOfFirstSubseq[i++] = all += l - len + 1;
                    }
                } else {
                    int offset;
                    if (this.length < len) {
                        throw new WrongLengthException(len);
                    }
                    int i = 0;
                    int all = offset = this.length - len + 1;
                    while (i < this.seqs.length) {
                        this.indexOfFirstSubseq[i] = all;
                        ++i;
                        all += offset;
                    }
                }
                this.length = len;
            } else {
                throw new UnsupportedOperationException("For this sample it is impossible to have a sliding window, since the AlphabetContainer is not simple.");
            }
        }
    }

    public Hashtable<String, HashSet<String>> getAnnotationTypesAndIdentifier() {
        Hashtable<String, HashSet<String>> res = new Hashtable<String, HashSet<String>>();
        for (Sequence s : this) {
            SequenceAnnotation[] seqAn = s.getAnnotation();
            if (seqAn == null) continue;
            for (SequenceAnnotation current : seqAn) {
                HashSet<String> help = res.get(current.getType());
                boolean add = false;
                if (help == null) {
                    add = true;
                    help = new HashSet();
                }
                help.add(current.getIdentifier());
                if (!add) continue;
                res.put(current.getType(), help);
            }
        }
        return res;
    }

    public int[][] getSequenceAnnotationIndexMatrix(String rowType, Hashtable<String, Integer> rowHash, String columnType, Hashtable<String, Integer> columnHash) {
        int[][] result = new int[rowHash.size()][columnHash.size()];
        for (int r = 0; r < result.length; ++r) {
            Arrays.fill(result[r], -1);
        }
        int idx = 0;
        for (Sequence s : this) {
            SequenceAnnotation[] seqAn = s.getAnnotation();
            int idxColumn = -1;
            int idxRow = -1;
            if (seqAn != null) {
                for (SequenceAnnotation current : seqAn) {
                    String help = current.getType();
                    if (help.equals(rowType)) {
                        idxRow = rowHash.get(current.getIdentifier());
                        continue;
                    }
                    if (!help.equals(columnType)) continue;
                    idxColumn = columnHash.get(current.getIdentifier());
                }
            }
            if (idxRow >= 0 && idxColumn >= 0) {
                result[idxRow][idxColumn] = idx;
            }
            ++idx;
        }
        return result;
    }

    public static class WeightedSampleFactory {
        private Sample res;
        private double[] weights;

        public WeightedSampleFactory(SortOperation sort, Sample ... data) throws WrongAlphabetException, WrongLengthException {
            this(sort, data, (double[][])null, 0);
        }

        public WeightedSampleFactory(SortOperation sort, Sample data, double[] weights) throws WrongAlphabetException, WrongLengthException {
            this(sort, new Sample[]{data}, new double[][]{weights}, 0);
        }

        public WeightedSampleFactory(SortOperation sort, Sample data, double[] weights, int length) throws WrongAlphabetException, WrongLengthException {
            this(sort, new Sample[]{data}, new double[][]{weights}, length);
        }

        public WeightedSampleFactory(SortOperation sort, Sample[] data, double[][] weights, int length) throws WrongAlphabetException, WrongLengthException {
            Hashtable<Sequence, double[]> ht = new Hashtable<Sequence, double[]>(data.length * data[0].getNumberOfElements());
            for (int i = 0; i < data.length; ++i) {
                if (data[0].alphabetContainer.checkConsistency(data[i].alphabetContainer)) {
                    if (weights != null) {
                        this.add(ht, data[i], weights[i], length);
                        continue;
                    }
                    this.add(ht, data[i], null, length);
                    continue;
                }
                throw new WrongAlphabetException("The AlphabetContainer for all Sample has to be consistent.");
            }
            this.create("all sequences" + (length > 0 ? " of length " + length : "") + " that occur in " + Sample.getAnnotation(data), sort, ht);
        }

        private void add(Hashtable<Sequence, double[]> ht, Sample data, double[] weights, int length) throws WrongLengthException {
            double w = 1.0;
            int anz = data.getNumberOfElements();
            for (int i = 0; i < anz; ++i) {
                Sequence s = data.getElementAt(i);
                if (weights != null) {
                    w = weights[i];
                }
                if (length == 0) {
                    this.put(ht, s, w);
                    continue;
                }
                int l = s.getLength() - length + 1;
                if (l > 0) {
                    for (int j = 0; j < l; ++j) {
                        this.put(ht, s.getSubSequence(s.alphabetCon, j, length), w);
                    }
                    continue;
                }
                throw new WrongLengthException(length);
            }
        }

        private void put(Hashtable<Sequence, double[]> ht, Sequence s, double w) {
            double[] value = ht.get(s);
            if (value != null) {
                value[0] = value[0] + w;
            } else {
                ht.put(s, new double[]{w});
            }
        }

        private void create(String annotation, SortOperation sort, Hashtable<Sequence, double[]> ht) {
            Map.Entry[] array = ht.entrySet().toArray(new Map.Entry[0]);
            switch (sort) {
                case NO_SORT: {
                    break;
                }
                case SORT_BY_SEQUENCE: {
                    Arrays.sort(array, SequenceComparator.DEFAULT);
                    break;
                }
                case SORT_BY_WEIGHTS: {
                    Arrays.sort(array, WeightsComparator.DEFAULT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown sort operation");
                }
            }
            Sequence[] seqs = new Sequence[array.length];
            this.weights = new double[array.length];
            for (int i = 0; i < this.weights.length; ++i) {
                Map.Entry e = array[i];
                seqs[i] = (Sequence)e.getKey();
                this.weights[i] = ((double[])e.getValue())[0];
            }
            try {
                this.res = new Sample(annotation, seqs);
            }
            catch (Exception doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
        }

        public Sequence getElementAt(int index) {
            return this.res.getElementAt(index);
        }

        public int getNumberOfElements() {
            return this.res.getNumberOfElements();
        }

        public Sample getSample() {
            return this.res;
        }

        public double getSumOfWeights() {
            double res = 0.0;
            for (int i = 0; i < this.weights.length; ++i) {
                res += this.weights[i];
            }
            return res;
        }

        public double getWeight(int index) {
            return this.weights[index];
        }

        public double[] getWeights() {
            return (double[])this.weights.clone();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer((10 + this.res.getElementLength()) * this.weights.length);
            for (int i = 0; i < this.weights.length; ++i) {
                sb.append(i + " " + this.res.getElementAt(i) + "\t" + this.weights[i] + "\n");
            }
            return sb.toString();
        }

        private static final class SequenceComparator
        implements Comparator<Map.Entry<Sequence, double[]>> {
            public static final SequenceComparator DEFAULT = new SequenceComparator();

            private SequenceComparator() {
            }

            @Override
            public int compare(Map.Entry<Sequence, double[]> o1, Map.Entry<Sequence, double[]> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        }

        private static final class WeightsComparator
        implements Comparator<Map.Entry<Sequence, double[]>> {
            public static final WeightsComparator DEFAULT = new WeightsComparator();

            private WeightsComparator() {
            }

            @Override
            public int compare(Map.Entry<Sequence, double[]> o1, Map.Entry<Sequence, double[]> o2) {
                return (int)Math.signum(o2.getValue()[0] - o1.getValue()[0]);
            }
        }

        public static enum SortOperation {
            NO_SORT,
            SORT_BY_SEQUENCE,
            SORT_BY_WEIGHTS;

        }
    }

    public static class ElementEnumerator
    implements RecyclableSequenceEnumerator,
    Iterator<Sequence> {
        private int seqCounter;
        private int startPosCounter;
        private Sample s;

        public ElementEnumerator(Sample data) {
            this.s = data;
            this.reset();
        }

        @Override
        public boolean hasMoreElements() {
            return this.seqCounter < this.s.seqs.length;
        }

        @Override
        public Sequence nextElement() {
            if (this.s.indexOfFirstSubseq == null) {
                return this.s.seqs[this.seqCounter++];
            }
            Sequence current = this.s.length != 0 ? this.s.seqs[this.seqCounter].getSubSequence(this.startPosCounter, this.s.length) : this.s.seqs[this.seqCounter].getSubSequence(this.startPosCounter);
            if (++this.startPosCounter + this.s.length > this.s.seqs[this.seqCounter].getLength()) {
                ++this.seqCounter;
                this.startPosCounter = 0;
            }
            return current;
        }

        @Override
        public void reset() {
            this.startPosCounter = 0;
            this.seqCounter = 0;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public Sequence next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Samples are immutable");
        }
    }

    public static enum PartitionMethod {
        PARTITION_BY_NUMBER_OF_ELEMENTS,
        PARTITION_BY_NUMBER_OF_SYMBOLS;

    }
}

