/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous.shared;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.DiscreteGraphicalModel;
import de.jstacs.models.discrete.inhomogeneous.FSDAGModel;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.IDGMParameterSet;
import de.jstacs.models.mixture.AbstractMixtureModel;
import de.jstacs.models.mixture.MixtureModel;

public class SharedStructureMixture
extends MixtureModel {
    private static final long serialVersionUID = -9019277262448497915L;
    private StructureLearner sl;
    private StructureLearner.ModelType modelType;
    private byte order;
    private StructureLearner.LearningType method;
    private static final String XML_TAG = "SharedStructureMixture";

    private static double[] getClassHyperParams(DiscreteGraphicalModel[] m) {
        double[] erg = new double[m.length];
        for (int i = 0; i < erg.length; ++i) {
            erg[i] = m[i].getESS();
        }
        return erg;
    }

    public SharedStructureMixture(FSDAGModel[] m, StructureLearner.ModelType model, byte order, int starts, double alpha, double epsilon) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException {
        this(m, model, order, starts, true, null, alpha, epsilon);
    }

    public SharedStructureMixture(FSDAGModel[] m, StructureLearner.ModelType model, byte order, int starts, double[] weights, double alpha, double epsilon) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException {
        this(m, model, order, starts, false, weights, alpha, epsilon);
    }

    protected SharedStructureMixture(FSDAGModel[] m, StructureLearner.ModelType model, byte order, int starts, boolean estimateComponentProbs, double[] weights, double alpha, double epsilon) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException {
        super(m[0].getLength(), m, starts, estimateComponentProbs, SharedStructureMixture.getClassHyperParams(m), weights, AbstractMixtureModel.Algorithm.EM, alpha, epsilon, AbstractMixtureModel.Parameterization.LAMBDA, 0, 0, null);
        this.sl = new StructureLearner(m[0].getAlphabetContainer(), this.getLength());
        this.modelType = model;
        if (order < 0) {
            throw new IllegalArgumentException("The value of order has to be non-negative.");
        }
        this.order = order;
        this.method = StructureLearner.LearningType.ML_OR_MAP;
    }

    public SharedStructureMixture(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public SharedStructureMixture clone() throws CloneNotSupportedException {
        SharedStructureMixture clone = (SharedStructureMixture)super.clone();
        clone.sl = new StructureLearner(this.alphabets, this.length);
        return clone;
    }

    public String getStructure() throws NotTrainedException {
        return ((FSDAGModel)this.model[0]).getStructure();
    }

    @Override
    public String getInstanceName() {
        return "ssMixModel(" + this.dimension + " " + IDGMParameterSet.getModelInstanceName(this.modelType, this.order, this.method, ((FSDAGModel)this.model[0]).getESS()) + ")";
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendEnumWithTags(xml, this.modelType, "model");
        XMLParser.appendByteWithTags(xml, this.order, "order");
        XMLParser.appendEnumWithTags(xml, this.method, "method");
        xml.append(super.toXML());
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        this.modelType = (StructureLearner.ModelType)((Object)XMLParser.extractEnumForTag(xml, "model"));
        this.order = XMLParser.extractByteForTag(xml, "order");
        this.method = (StructureLearner.LearningType)((Object)XMLParser.extractEnumForTag(xml, "method"));
        this.sl = new StructureLearner(this.getAlphabetContainer(), this.getLength());
        super.fromXML(xml);
    }

    @Override
    protected void getNewParameters(int iteration, double[][] seqWeights, double[] w) throws Exception {
        SymmetricTensor[] parts = new SymmetricTensor[this.dimension];
        double[] x = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.sl.setESS(((FSDAGModel)this.model[i]).getESS());
            parts[i] = this.sl.getTensor(this.sample[0], seqWeights[i], this.order, this.method);
            x[i] = 1.0;
        }
        FSDAGModel.train(this.model, StructureLearner.getStructure(new SymmetricTensor(parts, x), this.modelType, this.order), seqWeights, this.sample[0]);
        this.getNewComponentProbs(w);
    }
}

