/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.classifier.utils.PValueComputation;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.results.NumericalResult;
import de.jstacs.scoringFunctions.homogeneous.HMMScoringFunction;
import de.jstacs.utils.DoubleList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class SignificantMotifOccurrencesFinder {
    private RandomSeqType type;
    private boolean oneHistogram;
    private Sample bg;
    private MotifDiscoverer disc;
    private int numSequences;
    private double sign;
    private double[] sortedScores;

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, boolean oneHistogram, int numSequences, double sign) {
        this.disc = disc;
        if (type == RandomSeqType.BACKGROUND) {
            throw new IllegalArgumentException("This type can not be used in this constructor.");
        }
        this.type = type;
        this.oneHistogram = oneHistogram;
        this.numSequences = numSequences;
        this.sign = sign;
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, Sample bg, double sign) {
        this.disc = disc;
        this.type = RandomSeqType.BACKGROUND;
        this.oneHistogram = true;
        this.numSequences = bg.getNumberOfElements();
        this.bg = bg;
        this.sign = sign;
    }

    private void createBgSample(Sample s) throws Exception {
        switch (this.type) {
            case BACKGROUND: {
                break;
            }
            case PERMUTED: {
                Sequence[] seqs = new Sequence[s.getNumberOfElements() * this.numSequences];
                int n = 0;
                for (int i = 0; i < s.getNumberOfElements(); ++i) {
                    Sequence current = s.getElementAt(i);
                    int j = 0;
                    while (j < this.numSequences) {
                        seqs[n] = new PermutedSequence(current);
                        ++j;
                        ++n;
                    }
                }
                this.bg = new Sample("permuted " + s.getAnnotation(), seqs);
                break;
            }
            case hMM0: 
            case hMM1: 
            case hMM2: 
            case hMM3: 
            case hMM4: 
            case hMM5: {
                int order = this.type.getOrder();
                HMMScoringFunction hmm = new HMMScoringFunction(s.getAlphabetContainer(), order, 0.0, new double[order + 1], true, true, 1);
                hmm.initializeFunction(0, false, new Sample[]{s}, null);
                if (order > 0) {
                    double[][][] condProbs = hmm.getAllConditionalStationaryDistributions();
                    DoubleList list = new DoubleList((int)(1.5 * Math.pow(s.getAlphabetContainer().getAlphabetLengthAt(0), condProbs.length)));
                    for (int i = 0; i < condProbs.length; ++i) {
                        for (int j = 0; j < condProbs[i].length; ++j) {
                            for (int k = 0; k < condProbs[i][j].length; ++k) {
                                list.add(Math.log(condProbs[i][j][k]));
                            }
                        }
                    }
                    hmm.setParameters(list.toArray(), 0);
                }
                this.bg = hmm.emit(this.numSequences * s.getNumberOfElements(), s.getElementLength());
                break;
            }
        }
    }

    private void createBgSample(Sequence seq) throws Exception {
        this.createBgSample(new Sample("", seq));
    }

    private void fillSortedScoresArray(int[] idxsOfUsedComponents, int[] idxsOfMotifsInComponents, int start) throws Exception {
        int i;
        int num = 0;
        Sequence bgSeq = null;
        LinkedList<double[][]> scoreList = new LinkedList<double[][]>();
        Object temp = null;
        for (i = 0; i < this.numSequences; ++i) {
            bgSeq = this.bg.getElementAt(i);
            temp = new double[idxsOfUsedComponents.length][];
            for (int j = 0; j < idxsOfUsedComponents.length; ++j) {
                temp[j] = this.disc.getProfileOfScoresFor(idxsOfUsedComponents[j], idxsOfMotifsInComponents[j], bgSeq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                num += temp[j].length;
            }
            scoreList.add((double[][])temp);
        }
        this.sortedScores = new double[num];
        Iterator it = scoreList.iterator();
        num = 0;
        while (it.hasNext()) {
            temp = (double[][])it.next();
            for (i = 0; i < ((double[][])temp).length; ++i) {
                System.arraycopy(temp[i], 0, this.sortedScores, num, temp[i].length);
                num += temp[i].length;
            }
        }
        Arrays.sort(this.sortedScores);
    }

    private void findSignificantMotifOccurrences(int motif, Sequence seq, int start, int[] idxsOfUsedComponents, int[] idxsOfMotifsInComponents, AbstractList<MotifAnnotation> annotation, int addMax, AbstractList<Sequence> sites, int addLeftSymbols, int addRightSymbols) throws Exception {
        if (!this.oneHistogram) {
            this.createBgSample(seq);
            this.fillSortedScoresArray(idxsOfUsedComponents, idxsOfMotifsInComponents, start);
        }
        int i = 0;
        double[][] temp = new double[idxsOfUsedComponents.length][];
        for (i = 0; i < idxsOfUsedComponents.length; ++i) {
            temp[i] = this.disc.getProfileOfScoresFor(idxsOfUsedComponents[i], idxsOfMotifsInComponents[i], seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
        }
        int signIndex = PValueComputation.getBorder(this.sortedScores, this.sign);
        double thresh = PValueComputation.getThreshold(this.sortedScores, signIndex);
        int length = this.disc.getMotifLength(motif);
        int annotIndex = annotation != null ? annotation.size() : 0;
        int siteIndex = sites != null ? sites.size() : 0;
        DoubleList pValues = new DoubleList();
        for (i = 0; i < temp.length; ++i) {
            for (int j = 0; j < temp[i].length; ++j) {
                if (!(temp[i][j] > thresh)) continue;
                try {
                    if (sites != null) {
                        Sequence site = this.disc.getStrandFor(idxsOfUsedComponents[i], idxsOfMotifsInComponents[i], seq, j + start) == StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE ? seq.getSubSequence(j + start - addRightSymbols, length + addLeftSymbols + addRightSymbols).reverseComplement() : seq.getSubSequence(j + start - addLeftSymbols, length + addLeftSymbols + addRightSymbols);
                        sites.add(site);
                    }
                    double pVal = PValueComputation.getPValue(this.sortedScores, temp[i][j], signIndex);
                    pValues.add(pVal);
                    if (annotation == null) continue;
                    annotation.add(new MotifAnnotation("motif* " + motif, j + start, length, this.disc.getStrandFor(idxsOfUsedComponents[i], idxsOfMotifsInComponents[i], seq, j + start), new NumericalResult("component", "the component of the model where this motif was found", idxsOfUsedComponents[i]), new NumericalResult("p-value", "", pVal), new NumericalResult("score", "", temp[i][j])));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (pValues.length() > addMax) {
            double[] array = pValues.toArray();
            Arrays.sort(array);
            for (i = 0; i < pValues.length(); ++i) {
                if (pValues.get(i) >= array[addMax]) {
                    if (annotation != null) {
                        annotation.remove(annotIndex);
                    }
                    if (sites == null) continue;
                    sites.remove(siteIndex);
                    continue;
                }
                ++annotIndex;
                ++siteIndex;
            }
        }
    }

    private int getLocalIndexOfMotifInComponent(int component, int motif) {
        for (int i = 0; i < this.disc.getNumberOfMotifsInComponent(component); ++i) {
            if (this.disc.getGlobalIndexOfMotifInComponent(component, i) != motif) continue;
            return i;
        }
        return -1;
    }

    private int[][] computeIndices(int motif) {
        int num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            ++num;
        }
        int[][] idxs = new int[2][num];
        num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            idxs[0][num] = i;
            idxs[1][num] = loc;
            ++num;
        }
        return idxs;
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int start) throws Exception {
        int[][] idxs = this.computeIndices(motif);
        LinkedList<MotifAnnotation> list = new LinkedList<MotifAnnotation>();
        this.findSignificantMotifOccurrences(motif, seq, start, idxs[0], idxs[1], list, Integer.MAX_VALUE, null, 0, 0);
        return list.toArray(new MotifAnnotation[0]);
    }

    public Sample annotateMotifs(Sample data) throws Exception {
        return this.annotateMotifs(0, data, Integer.MAX_VALUE);
    }

    public Sample annotateMotifs(int startPos, Sample data) throws Exception {
        return this.annotateMotifs(startPos, data, Integer.MAX_VALUE);
    }

    public Sample annotateMotifs(Sample data, int addMax) throws Exception {
        return this.annotateMotifs(0, data, addMax);
    }

    public Sample annotateMotifs(int startPos, Sample data, int addMax) throws Exception {
        return (Sample)this.predictBS(startPos, data, addMax, 0, 0).get(0);
    }

    public Sample getBindingSites(Sample data) throws Exception {
        return this.getBindingSites(0, data, Integer.MAX_VALUE, 0, 0);
    }

    public Sample getBindingSites(int startPos, Sample data, int addMax, int addLeft, int addRight) throws Exception {
        return (Sample)this.predictBS(startPos, data, addMax, addLeft, addRight).get(1);
    }

    public int getNumberOfBoundSequences(Sample data, int motifIndex) throws Exception {
        return ((int[])this.predictBS(0, data, Integer.MAX_VALUE, 0, 0).get(2))[motifIndex];
    }

    public double getOffsetForAucPR() {
        return this.oneHistogram ? 0.0 : 1.0;
    }

    public double getFactorForAucPR() {
        return this.oneHistogram ? 1.0 : -1.0;
    }

    public double[][] getValuesForEachNucleotide(Sample data, int component, int motif, boolean addOnlyBest) throws Exception {
        double[][] res = new double[data.getNumberOfElements()][];
        if (!this.oneHistogram) {
            this.createBgSample(data);
            int[][] idxs = this.computeIndices(motif);
            this.fillSortedScoresArray(idxs[0], idxs[1], 0);
        }
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getValueForNucleotides(data.getElementAt(i), 0, component, motif, addOnlyBest);
        }
        return res;
    }

    private static int getIndexOfMax(double ... values) {
        int idx = 0;
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > values[idx])) continue;
            idx = i;
        }
        return idx;
    }

    private double[] getValueForNucleotides(Sequence seq, int start, int component, int motif, boolean addOnlyBest) throws Exception {
        double[] res;
        block6: {
            int i;
            int length;
            double[] temp;
            block5: {
                if (!this.oneHistogram) {
                    this.createBgSample(seq);
                    int[][] idxs = this.computeIndices(motif);
                    this.fillSortedScoresArray(idxs[0], idxs[1], start);
                }
                temp = this.disc.getProfileOfScoresFor(component, motif, seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                res = new double[seq.getLength() - start];
                length = this.disc.getMotifLength(motif);
                if (!addOnlyBest) break block5;
                Arrays.fill(res, this.oneHistogram ? Double.NEGATIVE_INFINITY : 1.0);
                int idx = SignificantMotifOccurrencesFinder.getIndexOfMax(temp);
                double best = this.oneHistogram ? temp[idx] : PValueComputation.getPValue(this.sortedScores, temp[idx]);
                for (int i2 = 0; i2 < length; ++i2) {
                    res[idx + i2] = best;
                }
                break block6;
            }
            Arrays.fill(res, temp[temp.length - 1]);
            System.arraycopy(temp, 0, res, 0, temp.length);
            for (i = res.length - 1; i >= 0; --i) {
                int k = i - 1;
                for (int j = 1; j < length && k >= 0; ++j, --k) {
                    if (!(res[i] < res[k])) continue;
                    res[i] = res[k];
                }
            }
            if (this.oneHistogram) break block6;
            for (i = 0; i < temp.length; ++i) {
                res[i] = PValueComputation.getPValue(this.sortedScores, temp[i]);
            }
        }
        return res;
    }

    private ArrayList predictBS(int startPos, Sample data, int addMax, int addLeft, int addRight) throws Exception {
        Sample bs;
        int j;
        int n = data.getNumberOfElements();
        int m = this.disc.getNumberOfMotifs();
        int[][][] idxs = new int[m][][];
        Sequence[] seqs = new Sequence[n];
        for (j = 0; j < m; ++j) {
            idxs[j] = this.computeIndices(j);
        }
        LinkedList<MotifAnnotation> seqAn = new LinkedList<MotifAnnotation>();
        LinkedList<Sequence> bsList = new LinkedList<Sequence>();
        SequenceAnnotation[] empty = new SequenceAnnotation[]{};
        int[] bound = new int[m];
        double[][] motifSortedScores = new double[m][];
        if (this.oneHistogram) {
            this.createBgSample(data);
            for (j = 0; j < m; ++j) {
                this.fillSortedScoresArray(idxs[j][0], idxs[j][1], startPos);
                motifSortedScores[j] = this.sortedScores;
            }
        }
        for (int i = 0; i < n; ++i) {
            seqs[i] = data.getElementAt(i);
            seqAn.clear();
            for (j = 0; j < m; ++j) {
                this.sortedScores = motifSortedScores[j];
                this.findSignificantMotifOccurrences(j, seqs[i], startPos, idxs[j][0], idxs[j][1], seqAn, addMax, bsList, addLeft, addRight);
                if (bsList.size() <= 0) continue;
                int n2 = j;
                bound[n2] = bound[n2] + 1;
                bsList.clear();
            }
            seqs[i] = seqs[i].annotate(false, seqAn.toArray(empty));
        }
        ArrayList<Object> res = new ArrayList<Object>(3);
        res.add(new Sample("annotated sample", seqs));
        try {
            bs = new Sample("annotated binding sites", bsList.toArray(new Sequence[0]));
        }
        catch (Exception e) {
            bs = null;
        }
        res.add(bs);
        res.add(bound);
        return res;
    }

    public static enum RandomSeqType {
        BACKGROUND(-2),
        PERMUTED(-1),
        hMM0(0),
        hMM1(1),
        hMM2(2),
        hMM3(3),
        hMM4(4),
        hMM5(5);

        private final int order;

        private RandomSeqType(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

