/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizedScoringFunction;
import de.jstacs.scoringFunctions.homogeneous.HomogeneousScoringFunction;
import de.jstacs.scoringFunctions.mix.AbstractMixtureScoringFunction;
import de.jstacs.scoringFunctions.mix.StrandScoringFunction;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;
import de.jstacs.scoringFunctions.mix.motifSearch.PositionScoringFunction;
import de.jstacs.scoringFunctions.mix.motifSearch.UniformDurationScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.Arrays;

public class HiddenMotifsMixture
extends AbstractMixtureScoringFunction
implements MutableMotifDiscoverer {
    public static final boolean CONTAINS_ALWAYS_A_MOTIF = true;
    public static final boolean CONTAINS_SOMETIMES_A_MOTIF = false;
    private double[][] simpleScore;
    private double[] bgHelp;
    private int[] anz;
    private int[] currentPos;
    private double ess;
    private int bgIndex;
    private boolean type;
    private boolean plugInBg;
    private HomogeneousScoringFunction bg;

    private static NormalizableScoringFunction[] getNormalizableScoringFunctions(int length, HomogeneousScoringFunction bg, NormalizableScoringFunction[] motif, DurationScoringFunction[] posPrior) {
        int m = motif.length;
        if (m == 0) {
            throw new IllegalArgumentException("Please insert at least one ScoringFunction for a motif.");
        }
        NormalizableScoringFunction[] erg = new NormalizableScoringFunction[2 * m + 1];
        if (posPrior == null) {
            posPrior = new DurationScoringFunction[m];
        } else if (m != posPrior.length) {
            throw new IllegalArgumentException("The number of motifs and durations has to be the same.");
        }
        int l = -1;
        AlphabetContainer seqABC = bg.getAlphabetContainer();
        if (!seqABC.isSimple()) {
            throw new IllegalArgumentException("The AlphabetContainer of the motif and background models has to be simple.");
        }
        AlphabetContainer posABC = null;
        for (int i = 0; i < m; ++i) {
            if (!seqABC.checkConsistency(motif[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("The " + i + "-th motif model is not correct. Check the AlphabetContainer.");
            }
            erg[2 * i] = motif[i];
            if (posPrior[i] != null) {
                if (0 > posPrior[i].getMin() || posPrior[i].getMax() > length - motif[i].getLength()) {
                    throw new IllegalArgumentException("The " + i + "-th model for the positional information is not correct. Check the AlphabetContainer.");
                }
                erg[2 * i + 1] = posPrior[i];
                continue;
            }
            if (posABC == null || motif[i].getLength() != l) {
                posABC = new AlphabetContainer(new DiscreteAlphabet(0, length - motif[i].getLength()));
            }
            erg[2 * i + 1] = new UniformDurationScoringFunction(0, length - motif[i].getLength());
            l = motif[i].getLength();
        }
        if (!seqABC.checkConsistency(bg.getAlphabetContainer())) {
            throw new IllegalArgumentException("The background model is not correct. Check the AlphabetContainer.");
        }
        erg[2 * i] = bg;
        return erg;
    }

    public HiddenMotifsMixture(boolean type, int length, int starts, boolean plugIn, HomogeneousScoringFunction bg, NormalizableScoringFunction motif, DurationScoringFunction posPrior, boolean plugInBg) throws Exception {
        this(type, length, starts, plugIn, bg, new NormalizableScoringFunction[]{motif}, new DurationScoringFunction[]{posPrior}, plugInBg);
    }

    public HiddenMotifsMixture(boolean type, int length, int starts, boolean plugIn, HomogeneousScoringFunction bg, NormalizableScoringFunction[] motif, DurationScoringFunction[] posPrior, boolean plugInBg) throws Exception {
        super(length, starts, motif.length + (type ? 0 : 1), true, plugIn, HiddenMotifsMixture.getNormalizableScoringFunctions(length, bg, motif, posPrior));
        if (!this.alphabets.isSimple()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be simple.");
        }
        this.type = type;
        this.plugInBg = plugInBg;
        this.initObject();
        this.setHyperParametersOfBackgroundModel();
        this.computeLogGammaSum();
    }

    public HiddenMotifsMixture(StringBuffer source) throws NonParsableException {
        super(source);
        this.initObject();
    }

    private void initObject() {
        this.bgIndex = this.function.length - 1;
        this.bg = (HomogeneousScoringFunction)this.function[this.bgIndex];
        this.simpleScore = new double[(this.function.length - 1) / 2][];
        this.ess = this.type ? 0.0 : this.bg.getEss();
        for (int i = 0; i < this.bgIndex; i += 2) {
            this.ess += this.function[i].getEss();
        }
        this.createSimpleScore();
        this.initBgHelp();
        this.anz = new int[this.componentScore.length + 1];
        this.currentPos = new int[1];
    }

    private void createSimpleScore() {
        for (int i = 0; i < this.bgIndex; i += 2) {
            this.simpleScore[i / 2] = new double[(int)this.function[i + 1].getAlphabetContainer().getAlphabetLengthAt(0)];
        }
    }

    private void setHyperParametersOfBackgroundModel() throws Exception {
        int i;
        int[] len = new int[this.length + 1];
        int[] l = new int[1];
        for (i = 0; i <= this.length; ++i) {
            len[i] = i;
        }
        double[] weight = new double[len.length];
        for (i = 0; i < this.bgIndex; i += 2) {
            boolean okay;
            int m = this.length - this.function[i].getLength();
            DurationScoringFunction dur = (DurationScoringFunction)this.function[i + 1];
            int anz = 0;
            dur.reset();
            do {
                dur.getInternalPosition(l);
                if (l[0] <= m) {
                    ++anz;
                    okay = dur.next();
                    continue;
                }
                okay = false;
            } while (okay);
            double w = this.function[i].getEss() / (double)anz;
            dur.reset();
            do {
                dur.getInternalPosition(l);
                if (l[0] <= m) {
                    int n = l[0];
                    weight[n] = weight[n] + w;
                    int n2 = m - l[0];
                    weight[n2] = weight[n2] + w;
                    okay = dur.next();
                    continue;
                }
                okay = false;
            } while (okay);
        }
        if (!this.type) {
            int n = this.length;
            weight[n] = weight[n] + this.bg.getEss();
        }
        this.bg.setStatisticForHyperparameters(len, weight);
    }

    @Override
    public HiddenMotifsMixture clone() throws CloneNotSupportedException {
        HiddenMotifsMixture clone = (HiddenMotifsMixture)super.clone();
        clone.simpleScore = new double[this.simpleScore.length][];
        for (int i = 0; i < this.simpleScore.length; ++i) {
            clone.simpleScore[i] = new double[this.simpleScore[i].length];
        }
        clone.bg = (HomogeneousScoringFunction)clone.function[this.bgIndex];
        clone.bgHelp = (double[])this.bgHelp.clone();
        clone.anz = (int[])this.anz.clone();
        clone.currentPos = (int[])this.currentPos.clone();
        return clone;
    }

    @Override
    public double getHyperparameterForHiddenParameter(int index) {
        return this.function[2 * index].getEss();
    }

    @Override
    protected double getLogNormalizationConstantForComponent(int i) {
        if ((i *= 2) >= 0 && i < this.bgIndex) {
            int l = this.length - this.function[i].getLength();
            return this.function[i].getLogNormalizationConstant() + this.function[i + 1].getLogNormalizationConstant() + this.bg.getLogNormalizationConstant(l);
        }
        if (i == this.bgIndex) {
            return this.bg.getLogNormalizationConstant();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        double res;
        int[] ind;
        if (this.isNormalized()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        if ((ind = this.getIndices(parameterIndex))[0] == this.function.length) {
            res = this.partNorm[ind[1]];
        } else if (ind[0] == this.bgIndex) {
            res = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.bgIndex; i += 2) {
                int l = this.length - this.function[i].getLength();
                res = Normalisation.getLogSum(res, this.logHiddenPotential[i / 2] + this.function[i].getLogNormalizationConstant() + this.function[i + 1].getLogNormalizationConstant() + this.bg.getLogPartialNormalizationConstant(ind[1], l));
            }
            if (!this.type) {
                res = Normalisation.getLogSum(res, this.logHiddenPotential[this.bgIndex / 2] + this.bg.getLogPartialNormalizationConstant(ind[1]));
            }
        } else if (ind[0] % 2 == 0) {
            int l = this.length - this.function[ind[0]].getLength();
            res = this.logHiddenPotential[ind[0] / 2] + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]) + this.function[ind[0] + 1].getLogNormalizationConstant() + this.bg.getLogNormalizationConstant(l);
        } else {
            int l = this.length - this.function[ind[0] - 1].getLength();
            res = this.logHiddenPotential[ind[0] / 2] + this.function[ind[0] - 1].getLogNormalizationConstant() + this.function[ind[0]].getLogPartialNormalizationConstant(ind[1]) + this.bg.getLogNormalizationConstant(l);
        }
        return res;
    }

    @Override
    public double getEss() {
        return this.ess;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int n = this.function.length - 1;
        for (int i = 0; i < n; ++i) {
            this.function[i].initializeFunctionRandomly(freeParams);
        }
        if (!this.plugInBg) {
            this.bg.initializeFunctionRandomly(freeParams);
        }
        if (this.optimizeHidden) {
            this.initializeHiddenPotentialRandomly();
        }
        this.init(freeParams);
        this.initBgHelp();
    }

    private void initBgHelp() {
        int n = this.bg.getNumberOfParameters();
        if (n == -1) {
            this.bgHelp = new double[0];
        } else if (this.bgHelp == null || this.bgHelp.length != n) {
            this.bgHelp = new double[n];
        }
    }

    @Override
    public String getInstanceName() {
        String erg = "hiddenMotifsMixture(" + (this.type ? "contains always a motif" : "contains sometimes a motif") + "; bg = " + this.bg.getInstanceName();
        for (int i = 0; i < this.function.length - 1; i += 2) {
            erg = erg + "; (" + this.function[i].getInstanceName() + ", " + this.function[i + 1].getInstanceName() + ")";
        }
        return erg + ")";
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start) {
        int j = 2 * i;
        int m = this.function[j].getLength();
        int l = 0;
        int bgOrder = this.bg.getMaximalMarkovOrder();
        PositionScoringFunction pos = (PositionScoringFunction)this.function[j + 1];
        pos.reset();
        do {
            pos.getInternalPosition(this.currentPos);
            int homSt = Math.max(0, this.currentPos[0] - bgOrder);
            int homE = Math.min(this.length, this.currentPos[0] + m + bgOrder);
            this.simpleScore[i][l++] = pos.getLogScoreForInternal() + this.function[j].getLogScore(seq, start + this.currentPos[0]) - this.bg.getLogScore(seq, start + homSt, homE - homSt) + this.bg.getLogScore(seq, start + homSt, this.currentPos[0] - homSt) + this.bg.getLogScore(seq, start + this.currentPos[0] + m, homE - this.currentPos[0] - m);
        } while (pos.next());
        return l;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        int i;
        for (i = 0; i < this.bgIndex / 2; ++i) {
            int j = this.fillComponentScoreOf(i, seq, start);
            this.componentScore[i] = this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.simpleScore[i]);
        }
        if (!this.type) {
            this.componentScore[i] = this.logHiddenPotential[i];
        }
    }

    @Override
    public double getLogScore(Sequence seq, int start) {
        this.fillComponentScores(seq, start);
        return this.bg.getLogScore(seq, start, this.length) + Normalisation.getLogSum(this.componentScore);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int i = 0;
        int j = 0;
        int bgOrder = this.bg.getMaximalMarkovOrder();
        this.anz[0] = partialDer.length();
        int[][] end = new int[4][];
        while (j < this.bgIndex) {
            int l;
            int counter;
            int m = this.function[j].getLength();
            int stop = this.length - m + 1;
            this.iList[j].clear();
            this.dList[j].clear();
            end[0] = new int[stop];
            this.iList[j + 1].clear();
            this.dList[j + 1].clear();
            PositionScoringFunction pos = (PositionScoringFunction)this.function[j + 1];
            pos.reset();
            end[1] = new int[stop];
            this.iList[this.bgIndex].clear();
            this.dList[this.bgIndex].clear();
            end[2] = new int[stop];
            end[3] = new int[stop];
            stop = 0;
            do {
                pos.getInternalPosition(this.currentPos);
                int homSt = Math.max(0, this.currentPos[0] - bgOrder);
                int homE = Math.min(this.length, this.currentPos[0] + m + bgOrder);
                this.simpleScore[i][stop] = pos.getLogScoreAndPartialDerivationForInternal(this.iList[j + 1], this.dList[j + 1]) + this.function[j].getLogScoreAndPartialDerivation(seq, start + this.currentPos[0], this.iList[j], this.dList[j]) - this.bg.getLogScoreAndPartialDerivation(seq, start + homSt, homE - homSt, this.iList[this.bgIndex], this.dList[this.bgIndex]);
                end[0][stop] = this.iList[j].length();
                end[1][stop] = this.iList[j + 1].length();
                end[2][stop] = this.iList[this.bgIndex].length();
                double[] dArray = this.simpleScore[i];
                int n = stop;
                dArray[n] = dArray[n] + (this.bg.getLogScoreAndPartialDerivation(seq, start + homSt, this.currentPos[0] - homSt, this.iList[this.bgIndex], this.dList[this.bgIndex]) + this.bg.getLogScoreAndPartialDerivation(seq, start + this.currentPos[0] + m, homE - this.currentPos[0] - m, this.iList[this.bgIndex], this.dList[this.bgIndex]));
                end[3][stop++] = this.iList[this.bgIndex].length();
            } while (pos.next());
            this.componentScore[i] = this.logHiddenPotential[i] + Normalisation.logSumNormalisation(this.simpleScore[i], 0, stop, this.simpleScore[i], 0);
            for (m = 0; m < 2; ++m) {
                counter = 0;
                for (l = 0; l < stop; ++l) {
                    while (counter < end[m][l]) {
                        indices.add(this.iList[j + m].get(counter) + this.paramRef[j + m]);
                        partialDer.add(this.dList[j + m].get(counter++) * this.simpleScore[i][l]);
                    }
                }
            }
            Arrays.fill(this.bgHelp, 0.0);
            counter = 0;
            for (l = 0; l < stop; ++l) {
                while (counter < end[2][l]) {
                    int n = this.iList[this.bgIndex].get(counter);
                    this.bgHelp[n] = this.bgHelp[n] - this.dList[this.bgIndex].get(counter) * this.simpleScore[i][l];
                    ++counter;
                }
                while (counter < end[3][l]) {
                    int n = this.iList[this.bgIndex].get(counter);
                    this.bgHelp[n] = this.bgHelp[n] + this.dList[this.bgIndex].get(counter) * this.simpleScore[i][l];
                    ++counter;
                }
            }
            for (counter = 0; counter < this.bgHelp.length; ++counter) {
                indices.add(this.paramRef[this.bgIndex] + counter);
                partialDer.add(this.bgHelp[counter]);
            }
            this.anz[i + 1] = partialDer.length();
            j = 2 * ++i;
        }
        if (!this.type) {
            this.componentScore[this.bgIndex / 2] = this.logHiddenPotential[this.bgIndex / 2];
        }
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        if (this.componentScore.length > 1) {
            for (i = 0; i < this.hiddenPotential.length; ++i) {
                partialDer.multiply(this.anz[i], this.anz[i + 1], this.componentScore[i]);
            }
        }
        this.iList[this.bgIndex].clear();
        this.dList[this.bgIndex].clear();
        logScore += this.bg.getLogScoreAndPartialDerivation(seq, start, this.length, this.iList[this.bgIndex], this.dList[this.bgIndex]);
        for (i = 0; i < this.iList[this.bgIndex].length(); ++i) {
            indices.add(this.paramRef[this.bgIndex] + this.iList[this.bgIndex].get(i));
            partialDer.add(this.dList[this.bgIndex].get(i));
        }
        int n = this.bgIndex + 1;
        i = this.paramRef[n + 1] - this.paramRef[n];
        for (j = 0; j < i; ++j) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
        }
        return logScore;
    }

    public String toString() {
        if (Double.isNaN(this.norm)) {
            this.precomputeNorm();
        }
        StringBuffer erg = new StringBuffer(this.function.length * 1000);
        erg.append("bg:\n" + this.bg.toString() + "\n");
        if (!this.type) {
            erg.append("\nno motif: " + Math.exp(this.partNorm[this.bgIndex / 2] - this.norm) + "\texp(" + this.partNorm[this.bgIndex / 2] + " - " + this.norm + ")\t" + this.logHiddenPotential[this.bgIndex / 2] + "\n");
        }
        for (int i = 0; i < this.bgIndex; i += 2) {
            erg.append("\nmotif " + i / 2 + ": ");
            if (this.hiddenPotential.length > 1) {
                erg.append(Math.exp(this.partNorm[i / 2] - this.norm) + "\texp(" + this.partNorm[i / 2] + " - " + this.norm + ")\t" + this.logHiddenPotential[i / 2]);
            }
            erg.append("\n" + this.function[i].toString() + "\n" + this.function[i + 1].toString() + "\n");
        }
        return erg.toString();
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer erg = new StringBuffer(200);
        XMLParser.appendBooleanWithTags(erg, this.type, "type");
        XMLParser.appendBooleanWithTags(erg, this.plugInBg, "plugInBg");
        return erg;
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.type = XMLParser.extractBooleanForTag(xml, "type");
        this.plugInBg = XMLParser.extractBooleanForTag(xml, "plugInBg");
    }

    @Override
    public boolean modifyMotif(int motif, int offsetLeft, int offsetRight) throws Exception {
        int c = this.getNumberOfComponents() - 1;
        if ((motif < c || motif == c && this.type) && this.function[2 * motif] instanceof Mutable) {
            double norm_old = this.function[2 * motif].getLogNormalizationConstant();
            boolean res = ((Mutable)((Object)this.function[0])).modify(offsetLeft, offsetRight);
            if (res) {
                this.setHyperParametersOfBackgroundModel();
                this.init(this.freeParams);
                ((DurationScoringFunction)this.function[2 * motif + 1]).modify(offsetLeft - offsetRight);
                this.simpleScore[motif] = new double[(int)this.function[2 * motif + 1].getAlphabetContainer().getAlphabetLengthAt(0)];
                double norm_new = this.function[2 * motif].getLogNormalizationConstant();
                int n = motif;
                this.hiddenParameter[n] = this.hiddenParameter[n] + (norm_old - norm_new);
                this.norm = Double.NaN;
                this.setHiddenParameters(this.hiddenParameter, 0);
            }
            return res;
        }
        return false;
    }

    @Override
    public void initializeMotif(int motif, Sample data, double[] weights) throws Exception {
        Object object;
        Sample[] sampleArray;
        NormalizableScoringFunction normalizableScoringFunction;
        int c = this.getNumberOfComponents() - 1;
        if (motif < c || motif == c && this.type) {
            normalizableScoringFunction = this.function[2 * motif];
            sampleArray = new Sample[]{data};
            if (weights == null) {
                object = null;
            } else {
                double[][] dArrayArray = new double[1][];
                object = dArrayArray;
                dArrayArray[0] = weights;
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        normalizableScoringFunction.initializeFunction(0, this.freeParams, sampleArray, (double[][])object);
        this.init(this.freeParams);
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        int c = this.getNumberOfComponents() - 1;
        if (!(motif < c || motif == c && this.type)) {
            throw new IndexOutOfBoundsException();
        }
        this.function[2 * motif].initializeFunctionRandomly(this.freeParams);
        this.function[2 * motif + 1].initializeFunctionRandomly(this.freeParams);
        this.init(this.freeParams);
    }

    @Override
    public int getNumberOfMotifs() {
        return this.getNumberOfComponents() - (this.type ? 0 : 1);
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        int c = this.getNumberOfComponents() - 1;
        if (component < c || component == c && this.type) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) {
        return this.getIndexOfMaximalComponentFor(sequence, 0);
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        return component;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile dist) throws WrongLengthException {
        if (this.length != sequence.getLength() - startpos) {
            throw new WrongLengthException("The model can not score a sequence of this length.");
        }
        int c = this.getNumberOfComponents() - (!this.type ? 1 : 0);
        if (motif == 0 && component < c) {
            this.fillComponentScoreOf(component, sequence, startpos);
            double d = 0.0;
            switch (dist) {
                case UNNORMALIZED_JOINT: {
                    d = this.logHiddenPotential[component];
                }
                case UNNORMALIZED_CONDITIONAL: {
                    d += this.bg.getLogScore(sequence, startpos, this.length);
                    break;
                }
                case NORMALIZED_CONDITIONAL: {
                    d = -Normalisation.getLogSum(0, this.simpleScore[component].length, this.simpleScore[component]);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
            double[] res = new double[this.length - this.function[2 * component].getLength() + 1];
            DurationScoringFunction posPrior = (DurationScoringFunction)this.function[2 * component + 1];
            posPrior.reset();
            int[] internal = new int[1];
            posPrior.getInternalPosition(internal);
            int j = 0;
            for (int i = 0; i < res.length; ++i) {
                if (i == internal[0]) {
                    res[i] = this.simpleScore[component][j++] + d;
                    boolean b = posPrior.next();
                    if (b) {
                        posPrior.getInternalPosition(internal);
                        continue;
                    }
                    internal[0] = -1;
                    continue;
                }
                res[i] = Double.NEGATIVE_INFINITY;
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getMotifLength(int motif) {
        int c = this.getNumberOfComponents() - 1;
        if (motif < c || motif == c && this.type) {
            return this.function[2 * motif].getLength();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void adjustHiddenParameters(int classIndex, Sample[] data, double[][] dataWeights) throws Exception {
        this.initializeHiddenUniformly();
        this.adjustParameters(classIndex, data, dataWeights, false, true, false);
        this.adjustParameters(classIndex, data, dataWeights, true, false, false);
    }

    @Override
    protected void initializeUsingPlugIn(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        double[] old = null;
        if (this.plugInBg) {
            old = this.bg.getCurrentParameterValues();
        }
        this.bg.initializeFunction(index, freeParams, data, weights);
        int num = this.getNumberOfMotifs();
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double d = 0.1 / (double)(a - 1);
        d = (1.0 - (double)a * d) / ((double)a * d);
        for (int motif = 0; motif < num; ++motif) {
            int l = this.function[2 * motif].getLength();
            int s = r.nextInt(data[index].getNumberOfElements());
            Sequence seq = data[index].getElementAt(s);
            int p = r.nextInt(seq.getLength() - l + 1);
            seq = seq.getSubSequence(p, l);
            double h = d * this.function[2 * motif].getEss();
            this.function[2 * motif].initializeFunction(0, freeParams, new Sample[]{new Sample("", seq)}, new double[][]{{h}});
        }
        this.initializeHiddenUniformly();
        this.adjustParameters(index, data, weights, false, true, false);
        this.adjustParameters(index, data, weights, true, false, true);
        if (this.plugInBg) {
            this.bg.setParameters(old, 0);
        } else {
            this.bg.initializeUniformly(freeParams);
        }
    }

    private void adjustParameters(int index, Sample[] data, double[][] dataWeights, boolean adjustComponent, boolean adjustDuration, boolean adjustMotif) throws Exception {
        int l;
        int c = this.getNumberOfComponents();
        int stop = c - (this.type ? 0 : 1);
        int i = 0;
        int n = 0;
        int anz = data[index].getNumberOfElements();
        Object len = null;
        Sequence[][] seqs = null;
        double[][] seqComponentWeights = null;
        Object weightsPos = null;
        Object weightsNeg = null;
        if (adjustDuration || adjustMotif) {
            len = new int[stop][];
            for (i = 0; i < stop; ++i) {
                DurationScoringFunction dur = (DurationScoringFunction)this.function[2 * i + 1];
                len[i] = new int[dur.getNumberOfPossibilities()];
                dur.reset();
                l = 0;
                do {
                    len[i][l++] = dur.internal[0];
                } while (dur.next());
            }
            if (adjustMotif) {
                seqs = new Sequence[this.getNumberOfMotifs()][anz];
                seqComponentWeights = new double[seqs.length][anz];
            }
            if (adjustDuration) {
                weightsPos = new double[stop][];
                weightsNeg = new double[stop][];
                for (i = 0; i < stop; ++i) {
                    weightsPos[i] = new double[len[i].length];
                    weightsNeg[i] = new double[len[i].length];
                }
            }
        }
        double[] stat = new double[this.hiddenParameter.length];
        double w = 1.0;
        for (int d = 0; d < data.length; ++d) {
            anz = data[d].getNumberOfElements();
            for (n = 0; n < anz; ++n) {
                if (dataWeights != null) {
                    w = dataWeights[d][n];
                }
                Sequence current = data[d].getElementAt(n);
                this.fillComponentScores(current, 0);
                Normalisation.logSumNormalisation(this.componentScore);
                for (i = 0; i < c; ++i) {
                    double scw = this.componentScore[i] * w;
                    if (adjustComponent && d == index) {
                        int n2 = i;
                        stat[n2] = stat[n2] + scw;
                    }
                    if (!adjustDuration && !adjustMotif || i >= stop) continue;
                    int maxIndex = 0;
                    for (l = 0; l < this.simpleScore[i].length; ++l) {
                        if (!(this.simpleScore[i][l] >= this.simpleScore[i][maxIndex])) continue;
                        maxIndex = l;
                    }
                    if (adjustDuration) {
                        if (d == index) {
                            double[] dArray = weightsPos[i];
                            int n3 = maxIndex;
                            dArray[n3] = dArray[n3] + scw;
                        } else {
                            double[] dArray = weightsNeg[i];
                            int n4 = maxIndex;
                            dArray[n4] = dArray[n4] + scw;
                        }
                    }
                    if (!adjustMotif || d != index) continue;
                    seqComponentWeights[i][n] = scw;
                    seqs[i][n] = current.getSubSequence(len[i][maxIndex], this.function[2 * i].getLength());
                    if (this.getStrandFor(i, 0, seqs[i][n], 0) != StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE) continue;
                    seqs[i][n] = seqs[i][n].reverseComplement();
                }
            }
        }
        if (adjustComponent) {
            this.computeHiddenParameter(stat);
        }
        if (adjustDuration) {
            anz = data[index].getNumberOfElements();
            n = this.length / anz;
            c = Math.max(1, n / 2);
            for (i = 0; i < stop; ++i) {
                int x;
                int z;
                int binEnd;
                int y;
                double[] help = new double[weightsPos[i].length];
                double sumPos = 0.0;
                for (y = 0; y < help.length; ++y) {
                    help[y] = 0.0;
                    binEnd = Math.min(help.length - 1, y + c);
                    z = 0;
                    x = Math.max(0, y - c);
                    while (x <= binEnd) {
                        int n5 = y;
                        help[n5] = help[n5] + weightsPos[i][x];
                        ++x;
                        ++z;
                    }
                    int n6 = y;
                    help[n6] = help[n6] / (double)z;
                    sumPos += help[y];
                }
                weightsPos[i] = help;
                double sumNeg = 0.0;
                for (y = 0; y < help.length; ++y) {
                    help[y] = 0.0;
                    binEnd = Math.min(help.length, y + c);
                    z = 0;
                    x = Math.max(0, y - c);
                    while (x < binEnd) {
                        int n7 = y;
                        help[n7] = help[n7] + weightsNeg[i][x];
                        ++x;
                        ++z;
                    }
                    int n8 = y;
                    help[n8] = help[n8] / (double)z;
                    sumNeg += help[y];
                }
                weightsNeg[i] = help;
                double f = sumNeg > 0.0 ? sumPos / sumNeg : 0.0;
                for (int x2 = 0; x2 < ((double[][])weightsPos).length; ++x2) {
                    weightsPos[i][x2] = weightsPos[i][x2] > 1.2 * f * weightsNeg[i][x2] ? weightsPos[i][x2] - f * weightsNeg[i][x2] : 0.0;
                }
                ((DurationScoringFunction)this.function[2 * i + 1]).adjust(len[i], weightsPos[i]);
            }
        }
        if (adjustMotif) {
            for (i = 0; i < stop; ++i) {
                this.function[2 * i].initializeFunction(0, this.freeParams, new Sample[]{new Sample("picked sites " + i, seqs[i])}, new double[][]{seqComponentWeights[i]});
            }
        }
    }

    @Override
    public StrandedLocatedSequenceAnnotationWithLength.Strand getStrandFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        int c = this.getNumberOfComponents() - (!this.type ? 1 : 0);
        if (motif > 0 || component >= c) {
            throw new IndexOutOfBoundsException();
        }
        NormalizableScoringFunction m = this.function[2 * component];
        while (m instanceof NormalizedScoringFunction) {
            m = ((NormalizedScoringFunction)m).getFunction();
        }
        if (m instanceof StrandScoringFunction) {
            return ((StrandScoringFunction)m).getIndexOfMaximalComponentFor(sequence, startpos) == 0 ? StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD : StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE;
        }
        return StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD;
    }
}

