/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.ga.impl;

import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.ga.Organism;

public abstract class AbstractOrganism
extends AbstractChangeable
implements Organism {
    SymbolList[] chromosomes;
    String name;

    protected AbstractOrganism() {
        this.chromosomes = new SymbolList[0];
        this.name = "";
    }

    protected AbstractOrganism(Organism org, String name) {
        this.chromosomes = org.getChromosomes();
        this.name = name;
    }

    public final SymbolList[] getChromosomes() {
        return this.chromosomes;
    }

    protected abstract void setChromImpl(SymbolList[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChromosomes(SymbolList[] chromosomes) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.setChromImpl(chromosomes);
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Organism.CHROMOSOMES, chromosomes, this.chromosomes);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(Organism.CHROMOSOMES);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.chromosomes = chromosomes;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setName(String name) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.name = name;
        } else {
            ChangeSupport changeSupport;
            ChangeEvent ce = new ChangeEvent(this, Organism.NAME, this.chromosomes, this.chromosomes);
            ChangeSupport changeSupport2 = changeSupport = super.getChangeSupport(Organism.NAME);
            synchronized (changeSupport2) {
                changeSupport.firePreChangeEvent(ce);
                this.name = name;
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public abstract boolean isHaploid();
}

