/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture.gibbssampling;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.mixture.gibbssampling.BurnInTest;
import de.jstacs.utils.DoubleList;

public abstract class AbstractBurnInTest
extends BurnInTest {
    protected DoubleList[] values;
    private int currentSamplingIndex;
    private boolean computed;
    private int burnInLength;

    protected AbstractBurnInTest(int starts) {
        this.values = new DoubleList[starts];
        for (int i = 0; i < starts; ++i) {
            this.values[i] = new DoubleList();
        }
        this.resetAllValues();
    }

    protected AbstractBurnInTest(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getXMLTag());
        this.computed = XMLParser.extractBooleanForTag(xml, "computed");
        this.burnInLength = XMLParser.extractIntForTag(xml, "burnInLength");
        this.currentSamplingIndex = XMLParser.extractIntForTag(xml, "currentSamplingIndex");
        this.values = (DoubleList[])XMLParser.extractStorableArrayForTag(xml, "values");
        this.setFurtherInformation(xml);
    }

    @Override
    public final void resetAllValues() {
        this.currentSamplingIndex = -1;
        int end = this.values.length;
        for (int i = 0; i < end; ++i) {
            this.values[i].clear();
        }
        this.computed = false;
    }

    @Override
    public final void setCurrentSamplingIndex(int index) {
        this.currentSamplingIndex = index;
    }

    @Override
    public final void setValue(double val) {
        this.values[this.currentSamplingIndex].add(val);
        this.computed = false;
    }

    @Override
    public final StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(this.values.length * 10000);
        XMLParser.appendBooleanWithTags(xml, this.computed, "computed");
        XMLParser.appendIntWithTags(xml, this.burnInLength, "burnInLength");
        XMLParser.appendIntWithTags(xml, this.currentSamplingIndex, "currentSamplingIndex");
        XMLParser.appendStorableArrayWithTags(xml, this.values, "values");
        xml.append(this.getFurtherInformation());
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected abstract String getXMLTag();

    protected abstract StringBuffer getFurtherInformation();

    protected abstract void setFurtherInformation(StringBuffer var1) throws NonParsableException;

    @Override
    public final int getLengthOfBurnIn() {
        if (!this.computed) {
            this.burnInLength = this.computeLengthOfBurnIn();
            this.computed = true;
        }
        return this.burnInLength;
    }

    protected abstract int computeLengthOfBurnIn();
}

