/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Sample;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;

public class MixtureDuration
extends DurationScoringFunction {
    private DurationScoringFunction[] function;
    private double[] hiddenParams;
    private double[] scores;
    private double logNorm;
    private int[] paramRef;
    private int[] partDerOffset;
    private int starts;
    private IntList help;
    private static String XML_TAG = "MixtureDuration";

    private static double getESS(DurationScoringFunction ... function) {
        double ess = function[0].getEss();
        boolean noESS = ess == 0.0;
        for (int i = 1; i < function.length; ++i) {
            double e = function[i].getEss();
            if (noESS) {
                if (!(e > 0.0)) continue;
                throw new IllegalArgumentException("The ESS of duration " + i + " has to be zero.");
            }
            ess += e;
        }
        return ess;
    }

    public MixtureDuration(int starts, DurationScoringFunction ... function) throws WrongAlphabetException, CloneNotSupportedException, IllegalArgumentException {
        super(function[0].getMin(), function[0].getMax(), MixtureDuration.getESS(function));
        if (starts <= 0) {
            throw new IllegalArgumentException("The number of recommended starts should be positive.");
        }
        this.starts = starts;
        this.function = new DurationScoringFunction[function.length];
        this.scores = new double[function.length];
        this.hiddenParams = new double[function.length];
        this.paramRef = null;
        this.partDerOffset = new int[function.length];
        for (int i = 0; i < function.length; ++i) {
            if (!this.alphabets.checkConsistency(function[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("All durations have to have the same alphabet: Violated at position " + i);
            }
            this.function[i] = (DurationScoringFunction)function[i].clone();
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
        this.help = new IntList();
    }

    private void setParamRef(boolean freeParams) {
        int i;
        if (this.paramRef == null || this.paramRef.length != this.function.length + 2) {
            this.paramRef = new int[this.function.length + 2];
        }
        boolean unknown = false;
        for (i = 0; i < this.function.length; ++i) {
            int n = this.function[i].getNumberOfParameters();
            unknown |= n < 0;
            this.paramRef[i + 1] = this.paramRef[i] + n;
        }
        this.paramRef[i + 1] = unknown ? -1 : this.paramRef[i] + this.scores.length - (freeParams ? 1 : 0);
    }

    public MixtureDuration(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public MixtureDuration clone() throws CloneNotSupportedException {
        MixtureDuration clone = (MixtureDuration)super.clone();
        clone.function = (DurationScoringFunction[])ArrayHandler.clone((Cloneable[])this.function);
        clone.scores = (double[])this.scores.clone();
        clone.paramRef = (int[])this.paramRef.clone();
        clone.partDerOffset = (int[])this.partDerOffset.clone();
        clone.hiddenParams = (double[])this.hiddenParams.clone();
        clone.help = new IntList();
        return clone;
    }

    @Override
    public void adjust(int[] length, double[] weight) {
        double[][] assignedWeights = new double[this.function.length][];
        double[] stat = new double[this.hiddenParams.length];
        double all = 0.0;
        for (int i = 0; i < this.function.length; ++i) {
            this.function[i].adjust(length, weight);
            this.hiddenParams[i] = 0.0;
            assignedWeights[i] = new double[weight.length];
            stat[i] = this.function[i].getEss();
            all += stat[i];
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        int[] values = new int[1];
        for (int l = 0; l < length.length; ++l) {
            int i;
            values[0] = length[l];
            for (i = 0; i < this.function.length; ++i) {
                this.scores[i] = this.hiddenParams[i] + this.function[i].getLogScore(values);
            }
            Normalisation.logSumNormalisation(this.scores);
            for (i = 0; i < this.function.length; ++i) {
                assignedWeights[i][l] = weight[l] * this.scores[i];
                int n = i;
                stat[n] = stat[n] + weight[l] * this.scores[i];
            }
            all += weight[l];
        }
        for (int i = 0; i < this.function.length; ++i) {
            this.function[i].adjust(length, assignedWeights[i]);
            this.hiddenParams[i] = Math.log(stat[i] / all);
        }
        this.logNorm = 0.0;
    }

    @Override
    public double getLogScore(int ... values) {
        for (int i = 0; i < this.function.length; ++i) {
            this.scores[i] = this.hiddenParams[i] + this.function[i].getLogScore(values);
        }
        return Normalisation.getLogSum(this.scores) - this.logNorm;
    }

    @Override
    public double getLogScoreAndPartialDerivation(IntList indices, DoubleList partialDer, int ... values) {
        int j;
        int i;
        int o = partialDer.length();
        for (i = 0; i < this.function.length; ++i) {
            this.help.clear();
            this.scores[i] = this.hiddenParams[i] + this.function[i].getLogScoreAndPartialDerivation(this.help, partialDer, values);
            this.partDerOffset[i] = partialDer.length();
            for (j = 0; j < this.help.length(); ++j) {
                indices.add(this.paramRef[i] + this.help.get(j));
            }
        }
        double logScore = Normalisation.logSumNormalisation(this.scores);
        for (i = 0; i < this.function.length; ++i) {
            partialDer.multiply(o, this.partDerOffset[i], this.scores[i]);
            o = this.partDerOffset[i];
        }
        i = 0;
        j = this.paramRef[this.function.length];
        while (j < this.paramRef[this.function.length + 1]) {
            indices.add(j);
            partialDer.add(this.scores[i] - Math.exp(this.hiddenParams[i] - this.logNorm));
            ++j;
            ++i;
        }
        return logScore - this.logNorm;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        if (this.ess > 0.0) {
            for (int i = 0; i < this.function.length; ++i) {
                this.function[i].addGradientOfLogPriorTerm(grad, this.paramRef[i] + start);
            }
            int j = 0;
            int i = this.paramRef[this.function.length];
            while (i < this.paramRef[this.function.length + 1]) {
                grad[i + start] = this.function[j].getEss() - this.ess * Math.exp(this.hiddenParams[j] - this.logNorm);
                ++i;
                ++j;
            }
        }
    }

    @Override
    public double getLogPriorTerm() {
        double lp = 0.0;
        if (this.ess > 0.0) {
            for (int i = 0; i < this.function.length; ++i) {
                lp += this.function[i].getLogPriorTerm() + this.function[i].getEss() * this.hiddenParams[i];
            }
            lp -= this.ess * this.logNorm;
        }
        return lp;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        int n = this.getNumberOfParameters();
        if (n > 0) {
            double[] params = new double[n];
            for (int i = 0; i < this.function.length; ++i) {
                double[] current = this.function[i].getCurrentParameterValues();
                System.arraycopy(current, 0, params, this.paramRef[i], current.length);
            }
            int j = 0;
            int i = this.paramRef[this.function.length];
            while (i < this.paramRef[this.function.length + 1]) {
                params[i] = this.hiddenParams[j];
                ++i;
                ++j;
            }
            return params;
        }
        throw new RuntimeException();
    }

    @Override
    public String getInstanceName() {
        String name = "mixture duration(" + this.function[0].getInstanceName();
        for (int i = 1; i < this.function.length; ++i) {
            name = name + ", " + this.function[i].getInstanceName();
        }
        return name + ")";
    }

    @Override
    public int getNumberOfParameters() {
        return this.paramRef[this.function.length + 1];
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        int i;
        double w = 1.0;
        double all = 0.0;
        for (i = 0; i < this.function.length; ++i) {
            this.hiddenParams[i] = this.function[i].getEss();
            all += this.hiddenParams[i];
        }
        DirichletMRGParams params = new DirichletMRGParams(this.hiddenParams);
        double[] current = new double[this.function.length];
        if (weights == null) {
            weights = new double[data.length][];
        }
        double[] help = weights[index];
        double[][] componentWeights = new double[this.function.length][data[index].getNumberOfElements()];
        for (int j = 0; j < componentWeights[0].length; ++j) {
            DirichletMRG.DEFAULT_INSTANCE.generate(current, 0, this.function.length, params);
            if (help != null) {
                w = help[j];
            }
            all += w;
            for (i = 0; i < this.function.length; ++i) {
                componentWeights[i][j] = w * current[i];
                int n = i;
                this.hiddenParams[n] = this.hiddenParams[n] + componentWeights[i][j];
            }
        }
        for (i = 0; i < this.function.length; ++i) {
            weights[index] = componentWeights[i];
            this.function[i].initializeFunction(index, freeParams, data, (double[][])weights);
            this.hiddenParams[i] = Math.log(this.hiddenParams[i] / all);
        }
        this.logNorm = 0.0;
        weights[index] = help;
        this.setParamRef(freeParams);
    }

    @Override
    public void initializeUniformly() {
        for (int i = 0; i < this.function.length; ++i) {
            this.function[i].initializeUniformly();
            this.hiddenParams[i] = 0.0;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int i;
        boolean noPrior = this.ess == 0.0;
        double[] hyper = (double[])this.scores.clone();
        for (i = 0; i < this.function.length; ++i) {
            this.function[i].initializeFunctionRandomly(freeParams);
            hyper[i] = noPrior ? 1.0 : this.function[i].getEss();
        }
        DirichletMRG.DEFAULT_INSTANCE.generate(this.hiddenParams, 0, this.function.length, new DirichletMRGParams(hyper));
        for (i = 0; i < this.function.length; ++i) {
            this.hiddenParams[i] = Math.log(this.hiddenParams[i]);
        }
        this.logNorm = 0.0;
        this.setParamRef(freeParams);
    }

    @Override
    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.function.length && this.function[i].isInitialized(); ++i) {
        }
        return i == this.function.length;
    }

    @Override
    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.function.length; ++i) {
            this.function[i].setParameters(params, start + this.paramRef[i]);
        }
        int j = 0;
        int i = this.paramRef[this.function.length];
        while (i < this.paramRef[this.function.length + 1]) {
            this.hiddenParams[j] = params[start + i];
            ++i;
            ++j;
        }
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
    }

    @Override
    protected String getRNotation(String distributionName) {
        String r = "";
        String sum = null;
        for (int i = 0; i < this.function.length; ++i) {
            r = r + this.function[i].getRNotation(distributionName + i) + "\n";
            sum = sum == null ? distributionName + " = " + Math.exp(this.hiddenParams[i] - this.logNorm) + " * " + distributionName + i : sum + " + " + Math.exp(this.hiddenParams[i] - this.logNorm) + " * " + distributionName + i;
        }
        return r + sum + ";";
    }

    @Override
    public void modify(int delta) {
        if (delta != 0) {
            super.modify(delta);
            for (int i = 0; i < this.function.length; ++i) {
                this.function[i].modify(delta);
            }
        }
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return this.starts;
    }

    @Override
    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, XML_TAG);
        super.fromXML(xml);
        this.function = ArrayHandler.cast(DurationScoringFunction.class, XMLParser.extractStorableArrayForTag(xml, "components"));
        this.hiddenParams = XMLParser.extractDoubleArrayForTag(xml, "hiddenParams");
        this.starts = XMLParser.extractIntForTag(xml, "starts");
        this.scores = new double[this.function.length];
        this.paramRef = null;
        this.partDerOffset = new int[this.function.length];
        this.logNorm = Normalisation.getLogSum(this.hiddenParams);
        this.setParamRef(false);
        this.help = new IntList();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = super.toXML();
        XMLParser.appendStorableArrayWithTags(xml, this.function, "components");
        XMLParser.appendDoubleArrayWithTags(xml, this.hiddenParams, "hiddenParams");
        XMLParser.appendIntWithTags(xml, this.starts, "starts");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }
}

