/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.algorithms.optimization.Function;
import de.jstacs.algorithms.optimization.Optimizer;

public abstract class OneDimensionalFunction
implements Function {
    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        if (x == null || x.length != 1) {
            throw new DimensionException();
        }
        return this.evaluateFunction(x[0]);
    }

    public abstract double evaluateFunction(double var1) throws EvaluationException;

    public double[] findMin(double lower, double fLower, double eps, double startDistance) throws EvaluationException {
        double[] bracket = Optimizer.findBracket(this, lower, fLower, startDistance);
        return Optimizer.brentsMethod(this, bracket[0], bracket[2], bracket[3], bracket[4], eps);
    }

    @Override
    public final int getDimensionOfScope() {
        return 1;
    }
}

