/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.utils.Time;

public class SmallStepCondition
implements TerminationCondition {
    private double epsilon;

    public SmallStepCondition(double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("The espilon has to be non-negative.");
        }
        this.epsilon = epsilon;
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        double s = 0.0;
        for (int counter = 0; counter < direction.length; ++counter) {
            s += direction[counter] * direction[counter];
        }
        return s * (alpha * alpha) >= this.epsilon;
    }
}

