/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.parameters.ParameterSet;

public abstract class DiscreteGraphicalModel
extends AbstractModel
implements InstantiableFromParameterSet {
    private static final long serialVersionUID = 1L;
    protected DGMParameterSet params;
    protected boolean trained;

    public DiscreteGraphicalModel(DGMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params.getAlphabetContainer(), params.getLength());
        this.fromParameterSet(params);
    }

    public DiscreteGraphicalModel(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public DiscreteGraphicalModel clone() throws CloneNotSupportedException {
        DiscreteGraphicalModel clone = (DiscreteGraphicalModel)super.clone();
        clone.params = this.params.clone();
        return clone;
    }

    @Override
    public final DGMParameterSet getCurrentParameterSet() throws Exception {
        return this.params.clone();
    }

    public final String getDescription() {
        return (String)this.params.getParameterAt(1).getValue();
    }

    public final double getESS() {
        return (Double)this.params.getParameterAt(0).getValue();
    }

    private void fromParameterSet(ParameterSet parameters) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        DGMParameterSet p = (DGMParameterSet)parameters;
        if (!p.hasDefaultOrIsSet()) {
            throw new IllegalArgumentException("Parameters were not correct instantiated");
        }
        this.set(p, false);
    }

    @Override
    protected final void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer erg = XMLParser.extractForTag(representation, this.getXMLTag());
        try {
            this.set((DGMParameterSet)XMLParser.extractStorableForTag(erg, "ParameterSet"), XMLParser.extractBooleanForTag(erg, "trained"));
        }
        catch (CloneNotSupportedException e) {
            NonParsableException n = new NonParsableException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        this.setFurtherModelInfos(erg);
    }

    @Override
    public final boolean isTrained() {
        return this.trained;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public final StringBuffer toXML() {
        StringBuffer erg = new StringBuffer();
        XMLParser.appendStorableWithTags(erg, this.params, "ParameterSet");
        XMLParser.appendBooleanWithTags(erg, this.trained, "trained");
        StringBuffer help = this.getFurtherModelInfos();
        if (help != null) {
            erg.append(help);
        }
        XMLParser.addTags(erg, this.getXMLTag());
        return erg;
    }

    protected void check(Sequence sequence, int startpos, int endpos) throws NotTrainedException, IllegalArgumentException {
        if (!this.trained) {
            throw new NotTrainedException();
        }
        if (!this.alphabets.checkConsistency(sequence.getAlphabetContainer().getSubContainer(startpos, endpos - startpos + 1))) {
            throw new IllegalArgumentException("This sequence is not possible with the given alphabet.");
        }
        if (startpos < 0) {
            throw new IllegalArgumentException("This startposition is impossible. Try: 0 <= startposition");
        }
    }

    protected abstract StringBuffer getFurtherModelInfos();

    protected abstract String getXMLTag();

    protected abstract void setFurtherModelInfos(StringBuffer var1) throws NonParsableException;

    protected void set(DGMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        if (!params.getInstanceClass().equals(this.getClass())) {
            throw new RuntimeException("The parameters set can not be used for this class.");
        }
        this.params = params.clone();
        this.alphabets = params.getAlphabetContainer();
        this.length = params.getLength();
        this.trained = trained;
    }
}

