/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public abstract class PositionScoringFunction
extends AbstractNormalizableScoringFunction {
    protected int[] internal;

    protected PositionScoringFunction(AlphabetContainer con, int length) {
        super(con, length);
        this.internal = new int[length];
        this.reset();
    }

    protected PositionScoringFunction(int min, int max) {
        this(new AlphabetContainer(new DiscreteAlphabet(min, max)), 1);
    }

    protected PositionScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public PositionScoringFunction clone() throws CloneNotSupportedException {
        PositionScoringFunction clone = (PositionScoringFunction)super.clone();
        clone.internal = (int[])this.internal.clone();
        return clone;
    }

    public abstract void reset();

    public abstract boolean next();

    public void getInternalPosition(int[] positions) {
        for (int i = 0; i < this.length; ++i) {
            positions[i] = this.internal[i];
        }
    }

    public double getLogScoreForInternal() {
        return this.getLogScore(this.internal);
    }

    public double getLogScoreAndPartialDerivationForInternal(IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(indices, partialDer, this.internal);
    }

    public abstract double getLogScore(int ... var1);

    public abstract double getLogScoreAndPartialDerivation(IntList var1, DoubleList var2, int ... var3);

    @Override
    public double getLogScore(Sequence seq, int start) {
        return this.getLogScore(this.getValuesFromSequence(seq, start));
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(indices, partialDer, this.getValuesFromSequence(seq, start));
    }

    protected int[] getValuesFromSequence(Sequence seq, int start) {
        int[] res = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            res[i] = seq.discreteVal(start + i);
        }
        return res;
    }

    public abstract boolean isPossible(int ... var1);

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendStorableWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendIntWithTags(xml, this.length, "length");
        XMLParser.appendIntArrayWithTags(xml, this.internal, "internal");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "AlphabetContainer");
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.internal = XMLParser.extractIntArrayForTag(xml, "internal");
    }
}

