/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.results.Result;
import java.util.LinkedList;

public class SplitSequenceAnnotationParser
implements SequenceAnnotationParser {
    private String keyValueDelimiter;
    private String annotationDelimiter;
    private LinkedList<SequenceAnnotation> annot;
    private static final SequenceAnnotation[] empty = new SequenceAnnotation[0];

    public SplitSequenceAnnotationParser() {
        this("=", ";");
    }

    public SplitSequenceAnnotationParser(String keyValueDelimiter, String annotationDelimiter) {
        if (keyValueDelimiter.equals(annotationDelimiter)) {
            throw new IllegalArgumentException("The delimiters have to be different.");
        }
        this.annotationDelimiter = annotationDelimiter;
        this.keyValueDelimiter = keyValueDelimiter;
        this.annot = new LinkedList();
    }

    @Override
    public void addToAnnotation(String unparsed) {
        String[] split;
        for (String current : split = unparsed.substring(1).split(this.annotationDelimiter)) {
            int idx = current.indexOf(this.keyValueDelimiter);
            if (idx < 0) continue;
            this.annot.add(new SequenceAnnotation(current.substring(0, idx).trim(), current.substring(idx + this.keyValueDelimiter.length()).trim(), (Result[][])new Result[0][]));
        }
    }

    @Override
    public void clearAnnotation() {
        this.annot.clear();
    }

    @Override
    public SequenceAnnotation[] getCurrentAnnotation() {
        return this.annot.size() == 0 ? null : this.annot.toArray(empty);
    }

    @Override
    public String parseAnnotationToComment(char commentChar, SequenceAnnotation ... annotations) {
        StringBuffer res = new StringBuffer();
        res.append(commentChar);
        if (annotations != null && annotations.length > 0) {
            res.append(annotations[0].getType() + this.keyValueDelimiter + annotations[0].getIdentifier());
            for (int i = 1; i < annotations.length; ++i) {
                res.append(this.annotationDelimiter + " " + annotations[i].getType() + this.keyValueDelimiter + annotations[i].getIdentifier());
            }
        }
        return res.toString();
    }
}

