/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.SimpleResult;

public class NumericalResult
extends SimpleResult {
    public NumericalResult(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    NumericalResult(DataType datatype, String name, String comment, Comparable result) {
        super(name, comment, datatype);
        try {
            this.setResult(result);
        }
        catch (Exception e) {
            IllegalArgumentException n = new IllegalArgumentException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public NumericalResult(String name, String comment, double result) {
        this(DataType.DOUBLE, name, comment, new Double(result));
    }

    public NumericalResult(String name, String comment, int result) {
        this(DataType.INT, name, comment, new Integer(result));
    }

    public NumericalResult(String name, String comment, Integer result) {
        this(DataType.INT, name, comment, result);
    }

    public NumericalResult(String name, String comment, long result) {
        this(DataType.LONG, name, comment, new Long(result));
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "numericalResult");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        super.fromXML(XMLParser.extractForTag(representation, "numericalResult"));
    }

    @Override
    public String toString() {
        return this.getResultString() + " \t= " + this.name + " \t(" + this.comment + ")";
    }

    private String getResultString() {
        String erg = "" + this.result;
        int l = 20 - erg.length();
        for (int i = 0; i < l; ++i) {
            erg = erg + " ";
        }
        return erg;
    }
}

