/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.classifier.AbstractClassifier;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.Model;
import de.jstacs.results.Result;

public class StorableResult
extends Result {
    public static final byte NA = -1;
    public static final byte FALSE = 0;
    public static final byte TRUE = 1;
    private Storable object;

    public StorableResult(String name, String comment, Storable object) {
        super(name, comment, DataType.STORABLE);
        this.object = object;
    }

    public StorableResult(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public byte isTrained() {
        if (this.object instanceof AbstractModel) {
            return ((Model)this.object).isTrained() ? (byte)1 : 0;
        }
        if (this.object instanceof AbstractClassifier) {
            return ((AbstractClassifier)this.object).isTrained() ? (byte)1 : 0;
        }
        return -1;
    }

    public String getClassName() {
        return this.object.getClass().getName();
    }

    @Override
    public String getResult() {
        return this.object.toXML().toString();
    }

    public Storable getResultInstance() {
        return this.object;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        this.appendMainInfo(buf);
        XMLParser.appendStorableWithTags(buf, this.object, "object");
        XMLParser.addTags(buf, "objectResult");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "objectResult");
        this.extractMainInfo(representation);
        this.object = XMLParser.extractStorableForTag(representation, "object");
    }

    public String toString() {
        return this.name + ":\n" + this.object.toXML() + "\n";
    }
}

