/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DNASample
extends Sample {
    private static AlphabetContainer DNA_ALPHABETCONTAINER;

    public DNASample(String fName) throws FileNotFoundException, WrongAlphabetException, EmptySampleException, WrongLengthException, IOException {
        this(fName, '>');
    }

    public DNASample(String fName, char ignore) throws FileNotFoundException, WrongAlphabetException, EmptySampleException, WrongLengthException, IOException {
        this(fName, ignore, null);
    }

    public DNASample(String fName, char ignore, SequenceAnnotationParser parser) throws FileNotFoundException, WrongAlphabetException, EmptySampleException, WrongLengthException, IOException {
        super(DNA_ALPHABETCONTAINER, new SparseStringExtractor(fName, ignore, parser));
    }

    static {
        try {
            DNA_ALPHABETCONTAINER = new AlphabetContainer(new DNAAlphabet());
        }
        catch (Exception doesNotHappen) {
            System.err.println("Unexpected Error:");
            doesNotHappen.printStackTrace();
            System.exit(1);
        }
    }
}

