/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.utils.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.naming.OperationNotSupportedException;

public final class KMereStatistic {
    private AlphabetContainer abc;
    private int length;
    private int k;
    private int n;
    private int[] powers;
    private int[][] counts;

    public KMereStatistic(Sample data, int k) {
        int i;
        this.abc = data.getAlphabetContainer();
        this.length = data.getElementLength();
        if (!this.abc.isSimple() || this.length == 0) {
            throw new IllegalArgumentException("Can not compute the statistic: check the sample");
        }
        if (k < 1 || k >= this.length) {
            throw new IllegalArgumentException("Can not compute the statistic: check the order");
        }
        this.k = k;
        this.powers = new int[Math.max(k + 1, 2)];
        this.powers[0] = 1;
        this.powers[1] = (int)this.abc.getAlphabetLengthAt(0);
        for (i = 2; i < this.powers.length; ++i) {
            this.powers[i] = this.powers[1] * this.powers[i - 1];
        }
        this.counts = new int[this.length - k + 1][this.powers[k]];
        for (i = 0; i < data.getNumberOfElements(); ++i) {
            int l;
            Sequence seq = data.getElementAt(i);
            int idx = 0;
            for (l = 0; l < k - 1; ++l) {
                idx = idx * this.powers[1] + seq.discreteVal(l);
            }
            int s = 0;
            while (l < this.length) {
                idx = (idx * this.powers[1] + seq.discreteVal(l)) % this.powers[k];
                int[] nArray = this.counts[s];
                int n = idx;
                nArray[n] = nArray[n] + 1;
                ++l;
                ++s;
            }
        }
        this.n = data.getNumberOfElements();
    }

    public double[][] getSmoothedProfile(int window, String ... kmere) {
        Sequence[] seq = null;
        try {
            seq = new Sequence[kmere.length];
            for (int i = 0; i < seq.length; ++i) {
                seq[i] = Sequence.create(this.abc, kmere[i]);
            }
        }
        catch (Exception e) {
            seq = null;
        }
        if (seq == null) {
            throw new IllegalArgumentException();
        }
        return this.getSmoothedProfile(window, seq);
    }

    public double[][] getSmoothedProfile(int window, Sequence ... seq) {
        if (window < 1) {
            throw new IllegalArgumentException("The window has to have at least length 1.");
        }
        if (seq == null) {
            throw new IllegalArgumentException("check the subsequences");
        }
        int i = 0;
        int m = this.n * window;
        double[][] res = new double[seq.length][this.counts.length - window + 1];
        for (i = 0; i < seq.length; ++i) {
            int s;
            int l;
            if (seq[i].getLength() != this.k) {
                throw new IllegalArgumentException();
            }
            int idx = 0;
            for (l = 0; l < this.k; ++l) {
                idx = idx * this.powers[1] + seq[i].discreteVal(l);
            }
            for (l = 0; l < window; ++l) {
                double[] dArray = res[i];
                dArray[0] = dArray[0] + (double)this.counts[l][idx];
            }
            for (s = 1; s < res[i].length; ++s) {
                res[i][s] = res[i][s - 1] - (double)this.counts[l - window][idx] + (double)this.counts[l][idx];
                double[] dArray = res[i];
                int n = s - 1;
                dArray[n] = dArray[n] / (double)m;
                ++l;
            }
            double[] dArray = res[i];
            int n = s - 1;
            dArray[n] = dArray[n] / (double)m;
        }
        return res;
    }

    public static Sequence[] getCommonString(Sample data, int motifLength, boolean bothStrands) throws Exception {
        int f = bothStrands ? 2 : 1;
        LinkedList<Sequence> candidates = new LinkedList<Sequence>();
        HashSet<Sequence> current = new HashSet<Sequence>(f * data.getMaximalElementLength());
        Sequence s = data.getElementAt(0);
        int end = s.getLength() - motifLength;
        for (int i = 0; i <= end; ++i) {
            Sequence help = s.getSubSequence(i, motifLength);
            if (current.contains(help)) continue;
            current.add(help);
            candidates.add(help);
        }
        for (int j = 1; candidates.size() > 0 && j < data.getNumberOfElements(); ++j) {
            current.clear();
            KMereStatistic.add(current, data.getElementAt(j), motifLength);
            KMereStatistic.intersection(candidates, current, bothStrands);
        }
        Object[] empty = new Sequence[]{};
        empty = candidates.toArray(empty);
        Arrays.sort(empty);
        return empty;
    }

    private static void add(HashSet<Sequence> hash, Sequence sequence, int motifLength) {
        int end = sequence.getLength() - motifLength;
        for (int i = 0; i <= end; ++i) {
            Sequence help = sequence.getSubSequence(i, motifLength);
            if (hash.contains(help)) continue;
            hash.add(help);
        }
    }

    private static void intersection(LinkedList<Sequence> candidates, HashSet<Sequence> current, boolean bothStrands) throws OperationNotSupportedException {
        int i = 0;
        while (i < candidates.size()) {
            Sequence seq = candidates.get(i);
            if (!current.contains(seq) && !current.contains(seq.reverseComplement())) {
                candidates.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static Sample.WeightedSampleFactory getAbsoluteKMereFrequencies(Sample data, int k, boolean bothStrands) throws Exception {
        return KMereStatistic.getAbsoluteKMereFrequencies(data, k, bothStrands, Sample.WeightedSampleFactory.SortOperation.NO_SORT);
    }

    public static Sample.WeightedSampleFactory getAbsoluteKMereFrequencies(Sample data, int k, boolean bothStrands, Sample.WeightedSampleFactory.SortOperation sortOp) throws Exception {
        Sample myData = data;
        if (bothStrands) {
            Sequence[] seqs = new Sequence[2 * data.getNumberOfElements()];
            for (int j = 0; j < data.getNumberOfElements(); ++j) {
                seqs[2 * j] = data.getElementAt(j);
                seqs[2 * j + 1] = seqs[2 * j].reverseComplement();
            }
            myData = new Sample("both strands of " + data.getAnnotation(), seqs);
        }
        Sample.WeightedSampleFactory wsf = new Sample.WeightedSampleFactory(sortOp, myData, null, k);
        if (bothStrands) {
            wsf = KMereStatistic.removeReverseComplements(wsf, 2, sortOp);
        }
        return wsf;
    }

    public static Hashtable<Sequence, BitSet[]> getKmereSequenceStatistic(int k, boolean bothStrands, Sample ... data) throws WrongAlphabetException, OperationNotSupportedException {
        AlphabetContainer con = data[0].getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        int[] anz = new int[data.length];
        for (int d = 0; d < data.length; ++d) {
            if (!con.checkConsistency(data[d].getAlphabetContainer())) {
                throw new WrongAlphabetException();
            }
            anz[d] = data[d].getNumberOfElements();
        }
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        boolean add = false;
        for (int d = 0; d < data.length; ++d) {
            for (int n = 0; n < anz[d]; ++n) {
                Sequence seq = data[d].getElementAt(n);
                int m = seq.getLength() - k + 1;
                for (int l = 0; l < m; ++l) {
                    Sequence current = seq.getSubSequence(con, l, k);
                    BitSet[] b = res.get(current);
                    if (b == null && bothStrands) {
                        b = res.get(current.reverseComplement());
                    }
                    if (b == null) {
                        b = new BitSet[data.length];
                        for (int h = 0; h < data.length; ++h) {
                            b[h] = new BitSet(anz[h]);
                        }
                        add = true;
                    }
                    b[d].set(n);
                    if (!add) continue;
                    res.put(current, b);
                    add = false;
                }
            }
        }
        return res;
    }

    public static Hashtable<Sequence, BitSet[]> merge(Hashtable<Sequence, BitSet[]> statistic, int maximalMissmatch, boolean bothStrands) throws OperationNotSupportedException, CloneNotSupportedException, WrongLengthException, WrongAlphabetException {
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        Set<Map.Entry<Sequence, BitSet[]>> set = statistic.entrySet();
        Sequence rc = null;
        Map.Entry[] array = (Map.Entry[])ArrayHandler.cast(set.toArray());
        for (int i = 0; i < array.length; ++i) {
            res.put((Sequence)array[i].getKey(), (BitSet[])ArrayHandler.clone((Cloneable[])((Cloneable[])array[i].getValue())));
        }
        for (int arrayIndex1 = 0; arrayIndex1 < array.length; ++arrayIndex1) {
            Sequence s1 = (Sequence)array[arrayIndex1].getKey();
            BitSet[] o1 = (BitSet[])array[arrayIndex1].getValue();
            BitSet[] b1 = res.get(s1);
            if (bothStrands) {
                rc = s1.reverseComplement();
            }
            for (int arrayIndex2 = arrayIndex1 + 1; arrayIndex2 < array.length; ++arrayIndex2) {
                Sequence s2 = (Sequence)array[arrayIndex2].getKey();
                int d = s1.getHammingDistance(s2);
                if (bothStrands) {
                    d = Math.min(d, rc.getHammingDistance(s2));
                }
                if (d > maximalMissmatch) continue;
                BitSet[] o2 = (BitSet[])array[arrayIndex2].getValue();
                BitSet[] b2 = res.get(s2);
                for (int idx = 0; idx < b1.length; ++idx) {
                    b1[idx].or(o2[idx]);
                    b2[idx].or(o1[idx]);
                }
            }
        }
        return res;
    }

    public static LinkedList<Sequence> getConservedPatterns(Hashtable<Sequence, BitSet[]> statistic, int dataSetIndex, int threshold) {
        Iterator<Map.Entry<Sequence, BitSet[]>> it = statistic.entrySet().iterator();
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        while (it.hasNext()) {
            Map.Entry<Sequence, BitSet[]> e = it.next();
            if (e.getValue()[dataSetIndex].cardinality() < threshold) continue;
            list.add(e.getKey());
        }
        return list;
    }

    public static Hashtable<Sequence, BitSet[]> removeBackground(Hashtable<Sequence, BitSet[]> statistic, int fgIndex, int bgIndex, double fgWeight, double bgWeight) {
        Hashtable<Sequence, BitSet[]> res = new Hashtable<Sequence, BitSet[]>();
        for (Map.Entry<Sequence, BitSet[]> e : statistic.entrySet()) {
            BitSet[] b = e.getValue();
            if (!((double)b[fgIndex].cardinality() * fgWeight > (double)b[bgIndex].cardinality() * bgWeight)) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    private static Sample.WeightedSampleFactory removeReverseComplements(Sample.WeightedSampleFactory wsf, int div, Sample.WeightedSampleFactory.SortOperation so) throws Exception {
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        DoubleList weight = new DoubleList();
        for (int j = 0; j < wsf.getNumberOfElements(); ++j) {
            Sequence seq = wsf.getElementAt(j);
            if (seq.equals(seq.reverseComplement())) {
                seqs.add(seq);
                weight.add(wsf.getWeight(j) / (double)div);
                continue;
            }
            if (seq.compareTo(seq.reverseComplement()) >= 0) continue;
            seqs.add(seq);
            weight.add(wsf.getWeight(j));
        }
        return new Sample.WeightedSampleFactory(so, new Sample(null, seqs.toArray(new Sequence[0])), weight.toArray());
    }
}

