/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.gendismix;

import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifier;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifier.scoringFunctionBased.gendismix.LearningPrinciple;
import de.jstacs.classifier.scoringFunctionBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifier.scoringFunctionBased.logPrior.DoesNothingLogPrior;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.data.Sample;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import java.util.Arrays;

public class GenDisMixClassifier
extends ScoreClassifier {
    protected LogPrior prior;
    protected LogGenDisMixFunction function;
    protected double[] beta;
    private static final String XML_TAG = "gendismix-classifier";

    protected GenDisMixClassifier(GenDisMixClassifierParameterSet params, LogPrior prior, double lastScore, double[] beta, ScoringFunction ... score) throws CloneNotSupportedException {
        super(params, lastScore, score);
        this.setWeights(beta);
        this.setPrior(prior);
    }

    public GenDisMixClassifier(GenDisMixClassifierParameterSet params, LogPrior prior, double lastScore, double[] beta, NormalizableScoringFunction ... score) throws CloneNotSupportedException {
        this(params, prior, lastScore, beta, (ScoringFunction[])score);
    }

    public GenDisMixClassifier(GenDisMixClassifierParameterSet params, LogPrior prior, double[] beta, NormalizableScoringFunction ... score) throws CloneNotSupportedException {
        this(params, prior, Double.NaN, beta, score);
    }

    public GenDisMixClassifier(GenDisMixClassifierParameterSet params, LogPrior prior, double genBeta, double disBeta, double priorBeta, NormalizableScoringFunction ... score) throws CloneNotSupportedException {
        this(params, prior, Double.NaN, new double[]{disBeta, genBeta, priorBeta}, score);
    }

    public GenDisMixClassifier(GenDisMixClassifierParameterSet params, LogPrior prior, LearningPrinciple key, NormalizableScoringFunction ... score) throws CloneNotSupportedException {
        this(params, prior, Double.NaN, LearningPrinciple.getBeta(key), score);
    }

    public GenDisMixClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public GenDisMixClassifier clone() throws CloneNotSupportedException {
        GenDisMixClassifier clone = (GenDisMixClassifier)super.clone();
        clone.prior = this.prior.getNewInstance();
        clone.beta = (double[])this.beta.clone();
        return clone;
    }

    @Override
    protected LogGenDisMixFunction getFunction(Sample[] data, double[][] weights) throws Exception {
        GenDisMixClassifierParameterSet p = (GenDisMixClassifierParameterSet)this.params;
        return new LogGenDisMixFunction(p.getNumberOfThreads(), ArrayHandler.cast(NormalizableScoringFunction.class, this.score), data, weights, this.prior, this.beta, p.shouldBeNormalized(), p.useOnlyFreeParameter());
    }

    public void setPrior(LogPrior prior) {
        this.prior = prior != null ? prior : DoesNothingLogPrior.defaultInstance;
        this.hasBeenOptimized = false;
    }

    public void setWeights(double ... beta) throws IllegalArgumentException {
        this.beta = LearningPrinciple.checkWeights(beta);
        this.hasBeenOptimized = false;
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendDoubleArrayWithTags(xml, this.beta, "beta");
        if (!(this.prior instanceof DoesNothingLogPrior)) {
            StringBuffer pr = new StringBuffer(1000);
            pr.append("<prior>\n");
            XMLParser.appendStringWithTags(pr, this.prior.getClass().getName(), "className");
            pr.append(this.prior.toXML());
            pr.append("\t</prior>\n");
            xml.append(pr);
        }
        return xml;
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        double[] help;
        xml = new StringBuffer(xml.toString().replaceAll("de.jstacs.classifier.scoringFunctionBased.cll.CLLClassifier", GenDisMixClassifier.class.getName()));
        super.extractFurtherClassifierInfosFromXML(xml);
        if (xml.indexOf("beta") > 0) {
            help = XMLParser.extractDoubleArrayForTag(xml, "beta");
        } else {
            System.out.println("Warning loading old weighting.");
            if (xml.indexOf("alpha") > 0) {
                help = XMLParser.extractDoubleArrayForTag(xml, "alpha");
                double slot = help[0];
                help[0] = help[1];
                help[1] = slot;
            } else {
                help = LearningPrinciple.getBeta(LearningPrinciple.MSP);
            }
        }
        this.beta = LearningPrinciple.checkWeights(help);
        StringBuffer pr = XMLParser.extractForTag(xml, "prior");
        if (pr != null) {
            String className = XMLParser.extractStringForTag(pr, "className");
            try {
                this.prior = (LogPrior)Class.forName(className).getConstructor(StringBuffer.class).newInstance(pr);
            }
            catch (NoSuchMethodException e) {
                NonParsableException n = new NonParsableException("You must provide a constructor " + className + "(StringBuffer).");
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
            catch (Exception e) {
                NonParsableException n = new NonParsableException("problem at " + className + ": " + e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.prior = DoesNothingLogPrior.defaultInstance;
        }
        try {
            this.prior.set(((GenDisMixClassifierParameterSet)this.params).useOnlyFreeParameter(), this.score);
        }
        catch (Exception e) {
            NonParsableException n = new NonParsableException("problem when setting the kind of parameter: " + e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
    }

    public static GenDisMixClassifier[] create(GenDisMixClassifierParameterSet params, LogPrior prior, double[] weights, NormalizableScoringFunction[] ... functions) throws CloneNotSupportedException {
        int anz = 1;
        int[] current = new int[functions.length];
        int[] max = new int[functions.length];
        NormalizableScoringFunction[] sf = new NormalizableScoringFunction[functions.length];
        for (int counter1 = 0; counter1 < functions.length; ++counter1) {
            anz *= functions[counter1].length;
            max[counter1] = functions[counter1].length - 1;
        }
        GenDisMixClassifier[] erg = new GenDisMixClassifier[anz];
        anz = sf.length - 1;
        for (int counter1 = 0; counter1 < erg.length; ++counter1) {
            int counter2;
            for (counter2 = 0; counter2 < sf.length; ++counter2) {
                sf[counter2] = functions[counter2][current[counter2]];
            }
            erg[counter1] = new GenDisMixClassifier(params, prior, weights, sf);
            counter2 = 0;
            while (counter2 < anz && current[counter2] == max[counter2]) {
                current[counter2++] = 0;
            }
            int n = counter2;
            current[n] = current[n] + 1;
        }
        return erg;
    }

    @Override
    public String getInstanceName() {
        return super.getInstanceName() + " with weights=" + Arrays.toString(this.beta) + (this.prior == null || this.prior == DoesNothingLogPrior.defaultInstance ? "" : " and with " + this.prior.getInstanceName());
    }

    public int getNumberOfThreads() {
        return ((GenDisMixClassifierParameterSet)this.params).getNumberOfThreads();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.score.length * 5000);
        String heading = "function ";
        for (int i = 0; i < this.score.length; ++i) {
            sb.append(heading + i);
            sb.append("\n" + this.score[i].toString() + "\n");
        }
        return sb.toString();
    }

    public void setNumberOfThreads(int threads) throws SimpleParameter.IllegalValueException {
        ((GenDisMixClassifierParameterSet)this.params).setNumberOfThreads(threads);
    }

    @Override
    protected Class<? extends ScoreClassifierParameterSet> getClassOfParameterSet() {
        return GenDisMixClassifierParameterSet.class;
    }
}

