/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sequence;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.DiscreteGraphicalModel;
import de.jstacs.models.discrete.inhomogeneous.parameters.IDGMParameterSet;
import de.jstacs.utils.SafeOutputStream;
import java.io.OutputStream;

public abstract class InhomogeneousDGM
extends DiscreteGraphicalModel {
    int[] alphabetLength;
    protected SafeOutputStream sostream;
    protected static final OutputStream DEFAULT_STREAM = System.out;

    public InhomogeneousDGM(IDGMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public InhomogeneousDGM(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public InhomogeneousDGM clone() throws CloneNotSupportedException {
        InhomogeneousDGM i = (InhomogeneousDGM)super.clone();
        i.alphabetLength = (int[])this.alphabetLength.clone();
        i.setOutputStream(this.sostream.doesNothing() ? null : SafeOutputStream.DEFAULT_STREAM);
        return i;
    }

    public abstract String getStructure() throws NotTrainedException;

    public void setOutputStream(OutputStream stream) {
        this.sostream = new SafeOutputStream(stream);
    }

    @Override
    protected void check(Sequence sequence, int startpos, int endpos) throws NotTrainedException, IllegalArgumentException {
        super.check(sequence, startpos, endpos);
        if (startpos > endpos || endpos >= sequence.getLength()) {
            throw new IllegalArgumentException("This endposition is impossible. Try: startposition <= endposition < sequence.length");
        }
        if (endpos - startpos + 1 != this.length) {
            throw new IllegalArgumentException("This sequence has not length " + this.length + ".");
        }
    }

    @Override
    protected void set(DGMParameterSet parameter, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(parameter, trained);
        this.alphabetLength = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.alphabetLength[i] = (int)this.alphabets.getAlphabetLengthAt(i);
        }
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
    }
}

