/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.rootFinding;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealVectorValuedFunctionOfSeveralVariablesWithJacobien;

public class Newton {
    static final double DEFAULT_MAX_STEPSIZE = 1.0;
    static final double ALF = 1.0E-4;

    Newton() {
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray) {
        Newton.search(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray, 200, 1.0E-8, 1.0E-10, 1.0E-15, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray, int n, double d, double d2) {
        Newton.search(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray, n, d, d / 100.0, d2, 1.0);
    }

    public static void search(RealVectorValuedFunctionOfSeveralVariablesWithJacobien realVectorValuedFunctionOfSeveralVariablesWithJacobien, double[] dArray, int n, double d, double d2, double d3, double d4) {
        int n2 = realVectorValuedFunctionOfSeveralVariablesWithJacobien.getDimensionOfTargetSpace();
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        double[] dArray4 = new double[n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n2];
        boolean[] blArray = new boolean[1];
        RealFunctionOfSeveralVariables realFunctionOfSeveralVariables = Newton.normSqr(realVectorValuedFunctionOfSeveralVariablesWithJacobien, dArray7);
        double d5 = realFunctionOfSeveralVariables.eval(dArray);
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (!(Math.abs(dArray7[i]) > d6)) continue;
            d6 = Math.abs(dArray7[i]);
        }
        if (d6 < 0.01 * d) {
            return;
        }
        double d7 = d4 * Math.max(Math.sqrt(VectorOperations.normSqr(dArray)), (double)n2);
        for (int i = 1; i <= n; ++i) {
            int n3;
            realVectorValuedFunctionOfSeveralVariablesWithJacobien.eval(dArray, dArray7, 0, dArray2);
            MatrixOperations.times(dArray7, dArray2, dArray4);
            VectorOperations.assign(dArray, dArray6);
            double d8 = Householder.decompose(dArray2, dArray3, dArray8, dArray9);
            if (d8 == 0.0) {
                new RuntimeException("singular Jacobian");
            }
            MatrixOperations.times(dArray7, dArray3, dArray5);
            VectorOperations.neg(dArray5, dArray5);
            RXB.solve(dArray2, dArray5);
            d5 = Newton.lnsrch(dArray6, d5, dArray4, dArray5, dArray, d3, d7, blArray, realFunctionOfSeveralVariables);
            d6 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!(Math.abs(dArray7[n3]) > d6)) continue;
                d6 = Math.abs(dArray7[n3]);
            }
            if (d6 < d) {
                return;
            }
            if (blArray[0]) {
                d6 = 0.0;
                double d9 = Math.max(d5, 0.5 * (double)n2);
                for (int j = 0; j < n2; ++j) {
                    double d10 = Math.abs(dArray4[j]) * Math.max(Math.abs(dArray[j]), 1.0) / d9;
                    if (!(d10 > d6)) continue;
                    d6 = d10;
                }
                if (d6 < d2) {
                    throw new HitLocalMinimumException();
                }
                return;
            }
            d6 = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                double d11 = Math.abs(dArray[n3] - dArray6[n3]) / Math.max(Math.abs(dArray[n3]), 1.0);
                if (!(d11 > d6)) continue;
                d6 = d11;
            }
            if (!(d6 < d3)) continue;
            return;
        }
        throw new RuntimeException("exeed maximal number of iterations");
    }

    static RealFunctionOfSeveralVariables normSqr(final RealVectorValuedFunctionOfSeveralVariables realVectorValuedFunctionOfSeveralVariables, final double[] dArray) {
        return new RealFunctionOfSeveralVariables(){
            final double[] values;
            {
                this.values = dArray;
            }

            public double eval(double[] dArray2) {
                realVectorValuedFunctionOfSeveralVariables.eval(dArray2, this.values, 0);
                return VectorOperations.normSqr(this.values) / 2.0;
            }

            public int getNumberOfVariables() {
                return realVectorValuedFunctionOfSeveralVariables.getNumberOfVariables();
            }
        };
    }

    public static double lnsrch(double[] dArray, double d, double[] dArray2, double[] dArray3, double[] dArray4, double d2, double d3, boolean[] blArray, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        int n;
        int n2 = realFunctionOfSeveralVariables.getNumberOfVariables();
        blArray[0] = false;
        double d4 = 0.0;
        for (n = 0; n < n2; ++n) {
            d4 += dArray3[n] * dArray3[n];
        }
        if ((d4 = Math.sqrt(d4)) > d3) {
            n = 0;
            while (n < n2) {
                int n3 = n++;
                dArray3[n3] = dArray3[n3] * (d3 / d4);
            }
        }
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d5 += dArray2[i] * dArray3[i];
        }
        double d6 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d7 = Math.abs(dArray3[i]) / Math.max(Math.abs(dArray[i]), 1.0);
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        double d8 = d2 / d6;
        double d9 = 1.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n4 = 0;
        while (true) {
            double d13;
            for (int i = 0; i < n2; ++i) {
                dArray4[i] = dArray[i] + d9 * dArray3[i];
            }
            double d14 = realFunctionOfSeveralVariables.eval(dArray4);
            if (d9 < d8) {
                for (int i = 0; i < n2; ++i) {
                    dArray4[i] = dArray[i];
                }
                blArray[0] = true;
                return d14;
            }
            if (d14 <= d + 1.0E-4 * d9 * d5) {
                return d14;
            }
            if (d9 == 1.0) {
                d13 = -d5 / (2.0 * (d14 - d - d5));
            } else {
                double d15 = d14 - d - d9 * d5;
                double d16 = d11 - d12 - d10 * d5;
                double d17 = (d15 / (d9 * d9) - d16 / (d10 * d10)) / (d9 - d10);
                double d18 = (-d10 * d15 / (d9 * d9) + d9 * d16 / (d10 * d10)) / (d9 - d10);
                if (d17 == 0.0) {
                    d13 = -d5 / (2.0 * d18);
                } else {
                    double d19 = d18 * d18 - 3.0 * d17 * d5;
                    if (d19 < 0.0) {
                        throw new RuntimeException("Roundoff problem in lnsrch.");
                    }
                    d13 = (-d18 + Math.sqrt(d19)) / (3.0 * d17);
                }
                if (d13 > 0.5 * d9) {
                    d13 = 0.5 * d9;
                }
            }
            d10 = d9;
            d11 = d14;
            d12 = d;
            d9 = Math.max(d13, 0.1 * d9);
            ++n4;
        }
    }

    public static class HitLocalMinimumException
    extends RuntimeException {
        public HitLocalMinimumException() {
        }

        public HitLocalMinimumException(String string) {
        }
    }
}

