/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.NonParsableException;
import de.jstacs.data.sequences.annotation.LocatedSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.Collection;

public class LocatedSequenceAnnotationWithLength
extends LocatedSequenceAnnotation {
    private int length;

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, Result ... results) {
        super(position, type, identifier, results);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, Collection<Result> results) {
        super(position, type, identifier, results);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(int position, int length, String type, String identifier, SequenceAnnotation[] annotations, Result ... additionalAnnotations) {
        super(position, type, identifier, annotations, additionalAnnotations);
        this.length = length;
    }

    public LocatedSequenceAnnotationWithLength(String type, String identifier, LocatedSequenceAnnotation[] annotations, Result ... additionalAnnotations) {
        super(type, identifier, annotations, additionalAnnotations);
        int end = -2147483647;
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i] instanceof LocatedSequenceAnnotationWithLength) {
                if (((LocatedSequenceAnnotationWithLength)annotations[i]).getEnd() <= end) continue;
                end = ((LocatedSequenceAnnotationWithLength)annotations[i]).getEnd();
                continue;
            }
            if (annotations[i].getPosition() + 1 <= end) continue;
            end = annotations[i].getPosition() + 1;
        }
        this.length = end - this.getPosition();
    }

    public LocatedSequenceAnnotationWithLength(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "locatedSequenceAnnotationWithLength");
        super.fromXML(XMLParser.extractForTag(representation, "locatedSequenceAnnotation"));
        this.length = XMLParser.extractIntForTag(representation, "length");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "locatedSequenceAnnotation");
        XMLParser.appendIntWithTags(buf, this.length, "length");
        XMLParser.addTags(buf, "locatedSequenceAnnotationWithLength");
        return buf;
    }

    public int getLength() {
        return this.length;
    }

    public int getEnd() {
        return this.getPosition() + this.length;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("length: ");
        buf.append(this.length);
        buf.append("\n");
        return buf.toString();
    }
}

